/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.message;

import org.apache.ignite.internal.compute.ComputeMessagesTypeInfos;
import org.apache.ignite.internal.compute.message.ExecuteRequest;
import org.apache.ignite.internal.compute.message.ExecuteRequestImpl;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class ExecuteRequestSerializer
implements MessageSerializer<ExecuteRequest> {
    public static final ExecuteRequestSerializer INSTANCE = new ExecuteRequestSerializer();

    private ExecuteRequestSerializer() {
    }

    public boolean writeMessage(ExecuteRequest msg, MessageWriter writer) throws MessageMappingException {
        ExecuteRequestImpl message = (ExecuteRequestImpl)msg;
        writer.setMessageTypeInfo(ComputeMessagesTypeInfos.executeRequest());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)5)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeList("deploymentUnits", message.deploymentUnits(), MessageCollectionItemType.MSG);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeByteArray("executeOptionsByteArray", message.executeOptionsByteArray());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeByteArray("inputByteArray", message.inputByteArray());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeString("jobClassName", message.jobClassName());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeMessage("userContext", (NetworkMessage)message.userContext());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

