/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.message;

import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.internal.compute.message.JobStateRequest;
import org.apache.ignite.internal.compute.message.JobStateRequestBuilder;
import org.apache.ignite.internal.compute.message.JobStateRequestSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class JobStateRequestImpl
implements JobStateRequest,
Cloneable {
    public static final short GROUP_TYPE = 6;
    public static final short TYPE = 5;
    @IgniteToStringInclude
    private final UUID jobId;

    private JobStateRequestImpl(UUID jobId) {
        this.jobId = jobId;
    }

    @Override
    public UUID jobId() {
        return this.jobId;
    }

    public MessageSerializer serializer() {
        return JobStateRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 6;
    }

    public String toString() {
        return S.toString(JobStateRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 5;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        JobStateRequestImpl otherMessage = (JobStateRequestImpl)other;
        return Objects.equals(this.jobId, otherMessage.jobId);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.jobId);
        return result;
    }

    public JobStateRequestImpl clone() {
        try {
            return (JobStateRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static JobStateRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements JobStateRequestBuilder {
        private UUID jobId;

        private Builder() {
        }

        @Override
        public JobStateRequestBuilder jobId(UUID jobId) {
            Objects.requireNonNull(jobId, "jobId is not marked @Nullable");
            this.jobId = jobId;
            return this;
        }

        @Override
        public UUID jobId() {
            return this.jobId;
        }

        @Override
        public JobStateRequest build() {
            return new JobStateRequestImpl(Objects.requireNonNull(this.jobId, "jobId is not marked @Nullable"));
        }

        @Override
        public JobStateRequest buildDeserialized() {
            return new JobStateRequestImpl(this.jobId);
        }
    }
}

