/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute.executor;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.Ignite;
import org.apache.ignite.cache.manager.IgniteCaches;
import org.apache.ignite.catalog.IgniteCatalog;
import org.apache.ignite.compute.IgniteCompute;
import org.apache.ignite.internal.catalog.sql.IgniteCatalogSqlImpl;
import org.apache.ignite.internal.compute.SecuredIgniteCompute;
import org.apache.ignite.internal.compute.executor.SecuredIgniteTables;
import org.apache.ignite.internal.sql.api.SecuredIgniteSql;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.network.ClusterNode;
import org.apache.ignite.network.IgniteCluster;
import org.apache.ignite.sql.IgniteSql;
import org.apache.ignite.table.IgniteTables;
import org.apache.ignite.tx.IgniteTransactions;
import org.gridgain.internal.rbac.authorization.Authorizer;
import org.gridgain.internal.security.context.SecurityContext;
import org.gridgain.structure.IgniteStructures;

public class SecuredIgnite
implements Ignite,
Wrapper {
    private final Ignite delegate;
    private final SecuredIgniteTables tables;
    private final IgniteSql sql;
    private final IgniteCompute compute;

    public SecuredIgnite(Ignite delegate, IgniteSql sql, IgniteCompute compute, Authorizer authorizer, SecurityContext securityContext) {
        this.delegate = delegate;
        this.tables = new SecuredIgniteTables(delegate.tables(), delegate.caches(), authorizer, securityContext);
        this.sql = new SecuredIgniteSql(sql, securityContext);
        this.compute = new SecuredIgniteCompute(compute, securityContext);
    }

    public String name() {
        return this.delegate.name();
    }

    public IgniteTables tables() {
        return this.tables;
    }

    public IgniteCaches caches() {
        return this.tables;
    }

    public IgniteTransactions transactions() {
        return this.delegate.transactions();
    }

    public IgniteSql sql() {
        return this.sql;
    }

    public IgniteCompute compute() {
        return this.compute;
    }

    public Collection<ClusterNode> clusterNodes() {
        return this.delegate.clusterNodes();
    }

    public CompletableFuture<Collection<ClusterNode>> clusterNodesAsync() {
        return this.delegate.clusterNodesAsync();
    }

    public IgniteCatalog catalog() {
        return new IgniteCatalogSqlImpl(this.sql, (IgniteTables)this.tables, (IgniteCaches)this.tables);
    }

    public IgniteCluster cluster() {
        return this.delegate.cluster();
    }

    public IgniteStructures structures() {
        return this.delegate.structures();
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return (T)Wrappers.unwrap((Object)this.delegate, classToUnwrap);
    }
}

