/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.compress;

import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.DiskPageCompression;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.pagemem.wal.record.CheckpointRecord;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWALPointer;
import org.apache.ignite.internal.processors.compress.AbstractPageCompressionIntegrationTest;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.junit.Test;

public class WalPageCompressionIntegrationTest
extends AbstractPageCompressionIntegrationTest {
    protected IgniteConfiguration getConfiguration(String igniteName) throws Exception {
        DataStorageConfiguration dsCfg = new DataStorageConfiguration().setDefaultDataRegionConfiguration(new DataRegionConfiguration().setPersistenceEnabled(true)).setWalPageCompression(this.compression).setWalPageCompressionLevel(this.compressionLevel);
        return super.getConfiguration(igniteName).setDataStorageConfiguration(dsCfg).setDiscoverySpi((DiscoverySpi)new TcpDiscoverySpi().setIpFinder((TcpDiscoveryIpFinder)new TcpDiscoveryVmIpFinder(true)));
    }

    @Override
    protected void doTestPageCompression() throws Exception {
        int i;
        IgniteEx ignite0 = this.startGrid(0);
        this.compression = DiskPageCompression.DISABLED;
        this.compressionLevel = null;
        IgniteEx ignite1 = this.startGrid(1);
        ignite0.cluster().active(true);
        ignite1.cluster().active(true);
        String cacheName = "test";
        CacheConfiguration ccfg = new CacheConfiguration().setName(cacheName).setBackups(0).setAtomicityMode(CacheAtomicityMode.ATOMIC).setIndexedTypes(new Class[]{Integer.class, AbstractPageCompressionIntegrationTest.TestVal.class});
        IgniteCache cache0 = ignite0.getOrCreateCache(ccfg);
        IgniteCache cache1 = ignite1.getOrCreateCache(ccfg);
        int cnt = 20000;
        for (i = 0; i < cnt; ++i) {
            WalPageCompressionIntegrationTest.assertTrue((boolean)cache0.putIfAbsent((Object)i, (Object)new AbstractPageCompressionIntegrationTest.TestVal(i)));
            WalPageCompressionIntegrationTest.assertTrue((boolean)cache1.putIfAbsent((Object)i, (Object)new AbstractPageCompressionIntegrationTest.TestVal(i)));
        }
        for (i = 0; i < cnt; i += 2) {
            WalPageCompressionIntegrationTest.assertEquals((Object)new AbstractPageCompressionIntegrationTest.TestVal(i), (Object)cache0.getAndRemove((Object)i));
            WalPageCompressionIntegrationTest.assertEquals((Object)new AbstractPageCompressionIntegrationTest.TestVal(i), (Object)cache1.getAndRemove((Object)i));
        }
        FileWALPointer ptr0 = (FileWALPointer)ignite0.context().cache().context().wal().log((WALRecord)new CheckpointRecord(null));
        FileWALPointer ptr1 = (FileWALPointer)ignite1.context().cache().context().wal().log((WALRecord)new CheckpointRecord(null));
        log.info("Compressed WAL pointer: " + ptr0);
        log.info("Uncompressed WAL pointer: " + ptr1);
        WalPageCompressionIntegrationTest.assertTrue((String)("Compressed WAL must be smaller than uncompressed [ptr0=" + ptr0 + ", ptr1=" + ptr1 + ']'), (ptr0.compareTo(ptr1) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSkipGarbageApplyPageSnapshotWrongAssertion() throws Exception {
        this.compression = DiskPageCompression.SKIP_GARBAGE;
        IgniteEx ignite = this.startGrid(0);
        ignite.cluster().active(true);
        ignite.getOrCreateCache("default");
        this.stopGrid(0, true);
        this.startGrid(0);
    }
}

