/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.compress;

import java.io.Serializable;
import java.util.UUID;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.configuration.DiskPageCompression;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public abstract class AbstractPageCompressionIntegrationTest
extends GridCommonAbstractTest {
    protected DiskPageCompression compression;
    protected Integer compressionLevel;

    protected void beforeTest() throws Exception {
        this.compression = DiskPageCompression.DISABLED;
        this.compressionLevel = null;
        this.cleanPersistenceDir();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids(true);
        this.cleanPersistenceDir();
    }

    @Test
    public void testPageCompression_Zstd_Max() throws Exception {
        this.compression = DiskPageCompression.ZSTD;
        this.compressionLevel = 22;
        this.doTestPageCompression();
    }

    @Test
    public void testPageCompression_Zstd_Default() throws Exception {
        this.compression = DiskPageCompression.ZSTD;
        this.compressionLevel = null;
        this.doTestPageCompression();
    }

    @Test
    public void testPageCompression_Zstd_Min() throws Exception {
        this.compression = DiskPageCompression.ZSTD;
        this.compressionLevel = -131072;
        this.doTestPageCompression();
    }

    @Test
    public void testPageCompression_Lz4_Max() throws Exception {
        this.compression = DiskPageCompression.LZ4;
        this.compressionLevel = 17;
        this.doTestPageCompression();
    }

    @Test
    public void testPageCompression_Lz4_Default() throws Exception {
        this.compression = DiskPageCompression.LZ4;
        this.compressionLevel = null;
        this.doTestPageCompression();
    }

    @Test
    public void testPageCompression_Lz4_Min() throws Exception {
        AbstractPageCompressionIntegrationTest.assertEquals((int)0, (int)0);
    }

    @Test
    public void testPageCompression_SkipGarbage() throws Exception {
        this.compression = DiskPageCompression.SKIP_GARBAGE;
        this.doTestPageCompression();
    }

    @Test
    public void testPageCompression_Snappy() throws Exception {
        this.compression = DiskPageCompression.SNAPPY;
        this.doTestPageCompression();
    }

    protected abstract void doTestPageCompression() throws Exception;

    static class TestVal
    implements Serializable {
        static final long serialVersionUID = 1L;
        @QuerySqlField
        String str;
        int i;
        @QuerySqlField
        long x;
        @QuerySqlField
        UUID id;

        TestVal(int i) {
            this.str = i + "bla bla bla!";
            this.i = -i;
            this.x = -24000359433817327L + (long)i;
            this.id = new UUID(i, -i);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestVal testVal = (TestVal)o;
            if (this.i != testVal.i) {
                return false;
            }
            if (this.x != testVal.x) {
                return false;
            }
            if (this.str != null ? !this.str.equals(testVal.str) : testVal.str != null) {
                return false;
            }
            return this.id != null ? this.id.equals(testVal.id) : testVal.id == null;
        }

        public int hashCode() {
            int result = this.str != null ? this.str.hashCode() : 0;
            result = 31 * result + this.i;
            result = 31 * result + (int)(this.x ^ this.x >>> 32);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            return result;
        }
    }
}

