/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit.metastore;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.ignite.deployment.version.Version;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyEventListener;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite.internal.deployunit.DeploymentStatus;
import org.apache.ignite.internal.deployunit.FileDeployerService;
import org.apache.ignite.internal.deployunit.metastore.ClusterEventCallback;
import org.apache.ignite.internal.deployunit.metastore.DeploymentUnitStore;
import org.apache.ignite.internal.deployunit.metastore.NodeEventCallback;
import org.apache.ignite.internal.deployunit.metastore.status.UnitClusterStatus;
import org.apache.ignite.internal.deployunit.metastore.status.UnitNodeStatus;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;

public class DeploymentUnitFailover {
    private static final IgniteLogger LOG = Loggers.forClass(DeploymentUnitFailover.class);
    private final LogicalTopologyService logicalTopology;
    private final DeploymentUnitStore deploymentUnitStore;
    private final FileDeployerService deployer;
    private final String nodeName;

    public DeploymentUnitFailover(LogicalTopologyService logicalTopology, DeploymentUnitStore deploymentUnitStore, FileDeployerService deployer, String nodeName) {
        this.logicalTopology = logicalTopology;
        this.deploymentUnitStore = deploymentUnitStore;
        this.deployer = deployer;
        this.nodeName = nodeName;
    }

    public void registerTopologyChangeCallback(final NodeEventCallback nodeEventCallback, ClusterEventCallback clusterEventCallback) {
        this.logicalTopology.addEventListener(new LogicalTopologyEventListener(){

            public void onNodeJoined(LogicalNode joinedNode, LogicalTopologySnapshot newTopology) {
                String consistentId = joinedNode.name();
                if (Objects.equals(consistentId, DeploymentUnitFailover.this.nodeName)) {
                    DeploymentUnitFailover.this.deploymentUnitStore.getNodeStatuses(consistentId).thenAccept(nodeStatuses -> nodeStatuses.forEach(unitNodeStatus -> DeploymentUnitFailover.this.deploymentUnitStore.getClusterStatus(unitNodeStatus.id(), unitNodeStatus.version()).thenAccept(unitClusterStatus -> DeploymentUnitFailover.this.processStatus((UnitClusterStatus)unitClusterStatus, (UnitNodeStatus)unitNodeStatus, nodeEventCallback))));
                }
            }
        });
    }

    private void processStatus(UnitClusterStatus unitClusterStatus, UnitNodeStatus unitNodeStatus, NodeEventCallback nodeEventCallback) {
        LOG.info("Processing unit status, cluster {}, node {}.", new Object[]{unitClusterStatus, unitNodeStatus});
        String id = unitNodeStatus.id();
        Version version = unitNodeStatus.version();
        if (unitClusterStatus == null) {
            this.undeploy(id, version, unitNodeStatus.opId());
            return;
        }
        if (this.checkAbaProblem(unitClusterStatus, unitNodeStatus)) {
            return;
        }
        DeploymentStatus nodeStatus = unitNodeStatus.status();
        switch (unitClusterStatus.status()) {
            case UPLOADING: 
            case DEPLOYED: {
                if (nodeStatus != DeploymentStatus.UPLOADING) break;
                this.deploymentUnitStore.getAllNodeStatuses(id, version).thenAccept(nodes -> nodeEventCallback.onUpdate(unitNodeStatus, (List<UnitNodeStatus>)nodes));
                break;
            }
            case OBSOLETE: {
                if (nodeStatus != DeploymentStatus.DEPLOYED && nodeStatus != DeploymentStatus.OBSOLETE) break;
                this.deploymentUnitStore.updateNodeStatus(this.nodeName, id, version, DeploymentStatus.REMOVING);
                break;
            }
            case REMOVING: {
                this.deploymentUnitStore.getAllNodeStatuses(id, version).thenAccept(nodes -> {
                    UnitNodeStatus status = new UnitNodeStatus(id, version, DeploymentStatus.REMOVING, unitClusterStatus.opId(), this.nodeName);
                    nodeEventCallback.onUpdate(status, (List<UnitNodeStatus>)nodes);
                });
                break;
            }
        }
    }

    private void undeploy(String id, Version version, UUID opId) {
        this.deployer.undeploy(id, version).thenAccept(success -> {
            if (success.booleanValue()) {
                this.deploymentUnitStore.removeNodeStatus(this.nodeName, id, version, opId);
            }
        });
    }

    private boolean checkAbaProblem(UnitClusterStatus clusterStatus, UnitNodeStatus nodeStatus) {
        String id = nodeStatus.id();
        Version version = nodeStatus.version();
        UUID opId = nodeStatus.opId();
        if (!Objects.equals(clusterStatus.opId(), opId)) {
            if (nodeStatus.status() == DeploymentStatus.DEPLOYED) {
                this.undeploy(id, version, opId);
            } else {
                this.deploymentUnitStore.removeNodeStatus(this.nodeName, id, version, opId);
            }
            return true;
        }
        return false;
    }
}

