/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.deployment.version.Version;
import org.apache.ignite.internal.cluster.management.ClusterManagementGroupManager;
import org.apache.ignite.internal.deployunit.DownloadTracker;
import org.apache.ignite.internal.deployunit.FileDeployerService;
import org.apache.ignite.internal.deployunit.UnitContent;
import org.apache.ignite.internal.deployunit.exception.DeploymentUnitReadException;
import org.apache.ignite.internal.deployunit.message.DeployUnitMessageTypes;
import org.apache.ignite.internal.deployunit.message.DeploymentUnitFactory;
import org.apache.ignite.internal.deployunit.message.DownloadUnitRequest;
import org.apache.ignite.internal.deployunit.message.DownloadUnitResponse;
import org.apache.ignite.internal.deployunit.message.StopDeployRequest;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.ChannelType;
import org.apache.ignite.internal.network.ClusterService;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.internal.network.NetworkMessage;

public class DeployMessagingService {
    private static final IgniteLogger LOG = Loggers.forClass(DeployMessagingService.class);
    static final ChannelType DEPLOYMENT_CHANNEL = new ChannelType(2, "DeploymentUnits");
    private final ClusterService clusterService;
    private final ClusterManagementGroupManager cmgManager;
    private final FileDeployerService deployerService;
    private final DownloadTracker tracker;
    private final DeploymentUnitFactory messageFactory = new DeploymentUnitFactory();

    public DeployMessagingService(ClusterService clusterService, ClusterManagementGroupManager cmgManager, FileDeployerService deployerService, DownloadTracker tracker) {
        this.clusterService = clusterService;
        this.cmgManager = cmgManager;
        this.deployerService = deployerService;
        this.tracker = tracker;
    }

    public void subscribe() {
        this.clusterService.messagingService().addMessageHandler(DeployUnitMessageTypes.class, (message, sender, correlationId) -> {
            if (message instanceof DownloadUnitRequest) {
                this.processDownloadRequest((DownloadUnitRequest)message, sender, correlationId);
            } else if (message instanceof StopDeployRequest) {
                this.processStopDeployRequest((StopDeployRequest)message, sender, correlationId);
            }
        });
    }

    CompletableFuture<UnitContent> downloadUnitContent(String id, Version version, Collection<String> nodes) {
        DownloadUnitRequest request = this.messageFactory.downloadUnitRequest().id(id).version(version.render()).build();
        InternalClusterNode clusterNode = this.resolveClusterNode(nodes);
        return this.clusterService.messagingService().invoke(clusterNode, DEPLOYMENT_CHANNEL, (NetworkMessage)request, Long.MAX_VALUE).thenApply(message -> ((DownloadUnitResponse)message).unitContent());
    }

    private InternalClusterNode resolveClusterNode(Collection<String> nodes) {
        return nodes.stream().map(node -> this.clusterService.topologyService().getByConsistentId(node)).filter(Objects::nonNull).findAny().orElseThrow(() -> {
            LOG.error("No any available node for download unit from {}", new Object[]{nodes});
            return new DeploymentUnitReadException("No any available node for download unit from " + nodes);
        });
    }

    CompletableFuture<Void> stopInProgressDeploy(String id, Version version) {
        LOG.info("Stop in progress deploy for " + id + ":" + version, new Object[0]);
        return this.cmgManager.logicalTopology().thenCompose(topology -> {
            StopDeployRequest request = this.messageFactory.stopDeployRequest().id(id).version(version.render()).build();
            CompletableFuture[] sendFutures = (CompletableFuture[])topology.nodes().stream().map(node -> this.clusterService.messagingService().invoke((InternalClusterNode)node, DEPLOYMENT_CHANNEL, (NetworkMessage)request, Long.MAX_VALUE)).toArray(CompletableFuture[]::new);
            return CompletableFuture.allOf(sendFutures);
        });
    }

    private void processStopDeployRequest(StopDeployRequest request, InternalClusterNode sender, long correlationId) {
        this.tracker.cancelIfDownloading(request.id(), Version.parseVersion((String)request.version()));
        this.clusterService.messagingService().respond(sender, (NetworkMessage)this.messageFactory.stopDeployResponse().build(), correlationId);
    }

    private void processDownloadRequest(DownloadUnitRequest request, InternalClusterNode sender, long correlationId) {
        this.deployerService.getUnitContent(request.id(), Version.parseVersion((String)request.version())).thenApply(content -> this.clusterService.messagingService().respond(sender, (NetworkMessage)this.messageFactory.downloadUnitResponse().unitContent((UnitContent)content).build(), correlationId));
    }
}

