/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.ignite.internal.deployunit.structure.UnitFile;
import org.apache.ignite.internal.deployunit.structure.UnitFolder;

public class UnitStructureBuilder {
    private final Deque<UnitFolder> folderStack = new ArrayDeque<UnitFolder>();

    public void pushFolder(String folderName) {
        UnitFolder folder = this.folderStack.peek();
        UnitFolder newFolder = new UnitFolder(folderName);
        if (folder != null) {
            folder.addChild(newFolder);
        }
        this.folderStack.push(newFolder);
    }

    public void popFolder(String folderName) {
        UnitFolder lastFolder = this.folderStack.pop();
        assert (lastFolder.name().equals(folderName));
    }

    public void addFile(String fileName, long size) {
        UnitFolder folder = this.folderStack.peek();
        folder.addChild(new UnitFile(fileName, size));
    }

    public UnitFolder build() {
        return this.folderStack.pop();
    }
}

