/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.ignite.internal.deployunit.DeploymentUnitProcessor;
import org.apache.ignite.internal.deployunit.FilesDeploymentUnit;
import org.apache.ignite.internal.deployunit.ZipDeploymentUnit;

public class DeployerProcessor
implements DeploymentUnitProcessor<Path> {
    private static final String TMP_SUFFIX = ".tmp";

    @Override
    public void processContent(FilesDeploymentUnit unit, Path unitFolder) throws IOException {
        for (Map.Entry<String, InputStream> e : unit.content().entrySet()) {
            DeployerProcessor.doDeploy(unitFolder, e.getKey(), e.getValue());
        }
    }

    @Override
    public void processContentWithUnzip(ZipDeploymentUnit unit, Path unitFolder) throws IOException {
        ZipEntry ze;
        ZipInputStream zis = unit.zis();
        while ((ze = zis.getNextEntry()) != null) {
            if (ze.isDirectory()) {
                Path entryPath = unitFolder.resolve(ze.getName());
                Files.createDirectories(entryPath, new FileAttribute[0]);
                continue;
            }
            DeployerProcessor.doDeploy(unitFolder, ze.getName(), zis);
        }
    }

    private static void doDeploy(Path unitFolder, String entryName, InputStream is) throws IOException {
        Path unitPath = unitFolder.resolve(entryName);
        Files.createDirectories(unitPath.getParent(), new FileAttribute[0]);
        Path unitPathTmp = unitFolder.resolve(entryName + TMP_SUFFIX);
        Files.copy(is, unitPathTmp, StandardCopyOption.REPLACE_EXISTING);
        Files.move(unitPathTmp, unitPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
    }
}

