/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.ignite.deployment.version.Version;
import org.apache.ignite.internal.deployunit.DeployerProcessor;
import org.apache.ignite.internal.deployunit.DeploymentUnit;
import org.apache.ignite.internal.deployunit.DeploymentUnitProcessor;
import org.apache.ignite.internal.deployunit.UnitContent;
import org.apache.ignite.internal.deployunit.exception.DeploymentUnitNotFoundException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.thread.IgniteThreadFactory;
import org.apache.ignite.internal.thread.ThreadOperation;
import org.apache.ignite.internal.util.IgniteUtils;

public class FileDeployerService {
    private static final IgniteLogger LOG = Loggers.forClass(FileDeployerService.class);
    private static final int DEPLOYMENT_EXECUTOR_SIZE = 4;
    private Path unitsFolder;
    private final ExecutorService executor;
    private final DeploymentUnitProcessor<Path> deployProcessor = new DeployerProcessor();

    public FileDeployerService(String nodeName) {
        this.executor = Executors.newFixedThreadPool(4, (ThreadFactory)IgniteThreadFactory.create((String)nodeName, (String)"deployment", (IgniteLogger)LOG, (ThreadOperation[])new ThreadOperation[0]));
    }

    public void initUnitsFolder(Path unitsFolder) {
        this.unitsFolder = unitsFolder;
    }

    public CompletableFuture<Boolean> deploy(String id, Version version, DeploymentUnit deploymentUnit) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Path unitFolder = this.unitPath(id, version);
                Files.createDirectories(unitFolder, new FileAttribute[0]);
                deploymentUnit.process(this.deployProcessor, unitFolder);
                return true;
            }
            catch (IOException e) {
                LOG.error("Failed to deploy unit " + id + ":" + String.valueOf(version), (Throwable)e);
                return false;
            }
        }, this.executor);
    }

    public CompletableFuture<Boolean> undeploy(String id, Version version) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                IgniteUtils.deleteIfExistsThrowable((Path)this.unitPath(id, version));
                return true;
            }
            catch (IOException e) {
                LOG.debug("Failed to undeploy unit " + id + ":" + String.valueOf(version), (Throwable)e);
                return false;
            }
        }, this.executor);
    }

    public CompletableFuture<UnitContent> getUnitContent(String id, Version version) {
        return CompletableFuture.supplyAsync(() -> {
            final HashMap<String, byte[]> result = new HashMap<String, byte[]>();
            try {
                final Path unitFolder = this.unitPath(id, version);
                Files.walkFileTree(unitFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path unitStructure = unitFolder.relativize(file);
                        result.put(unitStructure.toString(), Files.readAllBytes(file));
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                LOG.debug("Failed to get content for unit " + id + ":" + String.valueOf(version), (Throwable)e);
            }
            return new UnitContent(result);
        }, this.executor);
    }

    Path unitPath(String id, Version version, boolean checkExistence) {
        Path path = this.unitPath(id, version);
        if (checkExistence && !Files.exists(path, new LinkOption[0])) {
            throw new DeploymentUnitNotFoundException(id, version);
        }
        return path;
    }

    Path unitPath(String id, Version version) {
        return this.unitsFolder.resolve(id).resolve(version.render());
    }

    public void stop() {
        this.executor.shutdown();
    }
}

