/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit.loader;

import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ignite.internal.deployunit.DisposableDeploymentUnit;
import org.apache.ignite.internal.deployunit.loader.UnitsClassLoaderImpl;
import org.apache.ignite.internal.deployunit.loader.UnitsClasspath;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.lang.IgniteException;

public class UnitsClassLoader
implements AutoCloseable {
    private static final IgniteLogger LOG = Loggers.forClass(UnitsClassLoader.class);
    private final List<DisposableDeploymentUnit> units;
    private final ClassLoader parent;
    private volatile UnitsClassLoaderImpl impl;

    public UnitsClassLoader(List<DisposableDeploymentUnit> units, ClassLoader parent) {
        this.units = units;
        this.parent = parent;
    }

    public List<DisposableDeploymentUnit> units() {
        return this.units;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader classLoader() {
        if (this.impl == null) {
            UnitsClassLoader unitsClassLoader = this;
            synchronized (unitsClassLoader) {
                if (this.impl == null) {
                    this.impl = this.createClassLoader();
                }
            }
        }
        return this.impl;
    }

    private UnitsClassLoaderImpl createClassLoader() {
        return AccessController.doPrivileged(() -> {
            Object[] classpath = (URL[])this.units.stream().map(DisposableDeploymentUnit::path).flatMap(UnitsClasspath::collectClasspath).toArray(URL[]::new);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Created class loader with classpath: {}", new Object[]{Arrays.toString(classpath)});
            }
            return new UnitsClassLoaderImpl(this.units, (URL[])classpath, this.parent);
        });
    }

    @Override
    public void close() {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (DisposableDeploymentUnit unit : this.units) {
            try {
                unit.release();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        try {
            UnitsClassLoaderImpl impl0 = this.impl;
            if (impl0 != null) {
                impl0.close();
            }
        }
        catch (Exception e) {
            exceptions.add(e);
        }
        if (!exceptions.isEmpty()) {
            IgniteException igniteException = new IgniteException(ErrorGroups.Compute.CLASS_LOADER_ERR, "Failed to close class loader");
            for (Exception exception : exceptions) {
                igniteException.addSuppressed((Throwable)exception);
            }
            throw igniteException;
        }
    }
}

