/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.metrics.message.MetricDisableResponse;
import org.apache.ignite.internal.metrics.message.MetricDisableResponseBuilder;
import org.apache.ignite.internal.metrics.message.MetricDisableResponseSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class MetricDisableResponseImpl
implements MetricDisableResponse,
Cloneable {
    public static final short GROUP_TYPE = 16;
    public static final short TYPE = 3;
    @IgniteToStringInclude
    private Throwable throwable;
    private byte[] throwableByteArray;

    private MetricDisableResponseImpl(Throwable throwable, byte[] throwableByteArray) {
        this.throwable = throwable;
        this.throwableByteArray = throwableByteArray;
    }

    byte[] throwableByteArray() {
        return this.throwableByteArray;
    }

    @Override
    public Throwable throwable() {
        return this.throwable;
    }

    public MessageSerializer serializer() {
        return MetricDisableResponseSerializer.INSTANCE;
    }

    public short groupType() {
        return 16;
    }

    public String toString() {
        return S.toString(MetricDisableResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 3;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MetricDisableResponseImpl otherMessage = (MetricDisableResponseImpl)other;
        return Objects.equals(this.throwable, otherMessage.throwable);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.throwable);
        return result;
    }

    public MetricDisableResponseImpl clone() {
        try {
            return (MetricDisableResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static MetricDisableResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject throwableByteArraymo = marshaller.marshal((Object)this.throwable);
        usedDescriptors.addAll((IntCollection)throwableByteArraymo.usedDescriptorIds());
        this.throwableByteArray = throwableByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.throwable = (Throwable)marshaller.unmarshal(this.throwableByteArray, descriptorsObj);
        this.throwableByteArray = null;
    }

    private static class Builder
    implements MetricDisableResponseBuilder {
        private Throwable throwable;
        private byte[] throwableByteArray;

        private Builder() {
        }

        @Override
        public MetricDisableResponseBuilder throwable(Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        @Override
        public MetricDisableResponseBuilder throwableByteArray(byte[] throwableByteArray) {
            this.throwableByteArray = throwableByteArray;
            return this;
        }

        @Override
        public Throwable throwable() {
            return this.throwable;
        }

        @Override
        public byte[] throwableByteArray() {
            return this.throwableByteArray;
        }

        @Override
        public MetricDisableResponse build() {
            return new MetricDisableResponseImpl(this.throwable, this.throwableByteArray);
        }

        @Override
        public MetricDisableResponse buildDeserialized() {
            return new MetricDisableResponseImpl(this.throwable, this.throwableByteArray);
        }
    }
}

