/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.message;

import java.util.Objects;
import org.apache.ignite.internal.metrics.message.MetricDisableRequest;
import org.apache.ignite.internal.metrics.message.MetricDisableRequestBuilder;
import org.apache.ignite.internal.metrics.message.MetricDisableRequestSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class MetricDisableRequestImpl
implements MetricDisableRequest,
Cloneable {
    public static final short GROUP_TYPE = 16;
    public static final short TYPE = 2;
    @IgniteToStringInclude
    private final String sourceName;

    private MetricDisableRequestImpl(String sourceName) {
        this.sourceName = sourceName;
    }

    @Override
    public String sourceName() {
        return this.sourceName;
    }

    public MessageSerializer serializer() {
        return MetricDisableRequestSerializer.INSTANCE;
    }

    public short groupType() {
        return 16;
    }

    public String toString() {
        return S.toString(MetricDisableRequestImpl.class, (Object)this);
    }

    public short messageType() {
        return 2;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MetricDisableRequestImpl otherMessage = (MetricDisableRequestImpl)other;
        return Objects.equals(this.sourceName, otherMessage.sourceName);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.sourceName);
        return result;
    }

    public MetricDisableRequestImpl clone() {
        try {
            return (MetricDisableRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static MetricDisableRequestBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements MetricDisableRequestBuilder {
        private String sourceName;

        private Builder() {
        }

        @Override
        public MetricDisableRequestBuilder sourceName(String sourceName) {
            Objects.requireNonNull(sourceName, "sourceName is not marked @Nullable");
            this.sourceName = sourceName;
            return this;
        }

        @Override
        public String sourceName() {
            return this.sourceName;
        }

        @Override
        public MetricDisableRequest build() {
            return new MetricDisableRequestImpl(Objects.requireNonNull(this.sourceName, "sourceName is not marked @Nullable"));
        }

        @Override
        public MetricDisableRequest buildDeserialized() {
            return new MetricDisableRequestImpl(this.sourceName);
        }
    }
}

