/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.message;

import org.apache.ignite.internal.metrics.message.MetricSourcesResponse;
import org.apache.ignite.internal.metrics.message.MetricSourcesResponseBuilder;
import org.apache.ignite.internal.metrics.messaging.MetricMessagesFactory;
import org.apache.ignite.internal.metrics.messaging.MetricMessagesTypeInfos;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class MetricSourcesResponseDeserializer
implements MessageDeserializer<MetricSourcesResponse> {
    private final MetricSourcesResponseBuilder msg;

    MetricSourcesResponseDeserializer(MetricMessagesFactory messageFactory) {
        this.msg = messageFactory.metricSourcesResponse();
    }

    public Class<MetricSourcesResponse> klass() {
        return MetricSourcesResponse.class;
    }

    public MetricSourcesResponse getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(MetricMessagesTypeInfos.metricSourcesResponse());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                byte[] tmp = reader.readByteArray("sourcesByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.sourcesByteArray(tmp);
                }
                reader.incrementState();
            }
            case 1: {
                byte[] tmp = reader.readByteArray("throwableByteArray");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.throwableByteArray(tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(MetricSourcesResponse.class);
    }
}

