/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management;

import org.apache.ignite.internal.cluster.management.ClusterStateV2;
import org.apache.ignite.internal.cluster.management.ClusterStateV2Impl;
import org.apache.ignite.internal.cluster.management.network.messages.CmgMessagesTypeInfos;
import org.apache.ignite.internal.network.NetworkMessage;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class ClusterStateV2Serializer
implements MessageSerializer<ClusterStateV2> {
    public static final ClusterStateV2Serializer INSTANCE = new ClusterStateV2Serializer();

    private ClusterStateV2Serializer() {
    }

    public boolean writeMessage(ClusterStateV2 msg, MessageWriter writer) throws MessageMappingException {
        ClusterStateV2Impl message = (ClusterStateV2Impl)msg;
        writer.setMessageTypeInfo(CmgMessagesTypeInfos.clusterStateV2());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)7)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeMessage("clusterTag", (NetworkMessage)message.clusterTag());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeSet("cmgNodes", message.cmgNodes(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                boolean written = writer.writeList("formerClusterIds", message.formerClusterIds(), MessageCollectionItemType.UUID);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                boolean written = writer.writeString("initialClusterConfiguration", message.initialClusterConfiguration());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                boolean written = writer.writeSet("metaStorageNodes", message.metaStorageNodes(), MessageCollectionItemType.STRING);
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                boolean written = writer.writeString("nextVersion", message.nextVersion());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                boolean written = writer.writeString("version", message.version());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

