/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.raft.commands;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.cluster.management.ClusterState;
import org.apache.ignite.internal.cluster.management.raft.commands.ClusterNodeMessage;
import org.apache.ignite.internal.cluster.management.raft.commands.InitCmgStateCommand;
import org.apache.ignite.internal.cluster.management.raft.commands.InitCmgStateCommandBuilder;
import org.apache.ignite.internal.cluster.management.raft.commands.InitCmgStateCommandSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class InitCmgStateCommandImpl
implements InitCmgStateCommand,
Cloneable {
    public static final short GROUP_TYPE = 7;
    public static final short TYPE = 40;
    @IgniteToStringInclude
    private final ClusterState clusterState;
    @IgniteToStringInclude
    private final ClusterNodeMessage node;

    private InitCmgStateCommandImpl(ClusterState clusterState, ClusterNodeMessage node) {
        this.clusterState = clusterState;
        this.node = node;
    }

    @Override
    public ClusterState clusterState() {
        return this.clusterState;
    }

    @Override
    public ClusterNodeMessage node() {
        return this.node;
    }

    public MessageSerializer serializer() {
        return InitCmgStateCommandSerializer.INSTANCE;
    }

    public short groupType() {
        return 7;
    }

    public String toString() {
        return S.toString(InitCmgStateCommandImpl.class, (Object)this);
    }

    public short messageType() {
        return 40;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        InitCmgStateCommandImpl otherMessage = (InitCmgStateCommandImpl)other;
        return Objects.equals(this.clusterState, otherMessage.clusterState) && Objects.equals(this.node, otherMessage.node);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.clusterState, this.node);
        return result;
    }

    public InitCmgStateCommandImpl clone() {
        try {
            return (InitCmgStateCommandImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static InitCmgStateCommandBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.clusterState != null) {
            this.clusterState.prepareMarshal(usedDescriptors, marshaller);
        }
        if (this.node != null) {
            this.node.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.clusterState != null) {
            this.clusterState.unmarshal(marshaller, descriptorsObj);
        }
        if (this.node != null) {
            this.node.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements InitCmgStateCommandBuilder {
        private ClusterState clusterState;
        private ClusterNodeMessage node;

        private Builder() {
        }

        @Override
        public InitCmgStateCommandBuilder clusterState(ClusterState clusterState) {
            Objects.requireNonNull(clusterState, "clusterState is not marked @Nullable");
            this.clusterState = clusterState;
            return this;
        }

        @Override
        public InitCmgStateCommandBuilder node(ClusterNodeMessage node) {
            Objects.requireNonNull(node, "node is not marked @Nullable");
            this.node = node;
            return this;
        }

        @Override
        public ClusterState clusterState() {
            return this.clusterState;
        }

        @Override
        public ClusterNodeMessage node() {
            return this.node;
        }

        @Override
        public InitCmgStateCommand build() {
            return new InitCmgStateCommandImpl(Objects.requireNonNull(this.clusterState, "clusterState is not marked @Nullable"), Objects.requireNonNull(this.node, "node is not marked @Nullable"));
        }

        @Override
        public InitCmgStateCommand buildDeserialized() {
            return new InitCmgStateCommandImpl(this.clusterState, this.node);
        }
    }
}

