/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management;

import org.apache.ignite.internal.cluster.management.ClusterTag;
import org.apache.ignite.internal.cluster.management.ClusterTagImpl;
import org.apache.ignite.internal.cluster.management.network.messages.CmgMessagesTypeInfos;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageWriter;

class ClusterTagSerializer
implements MessageSerializer<ClusterTag> {
    public static final ClusterTagSerializer INSTANCE = new ClusterTagSerializer();

    private ClusterTagSerializer() {
    }

    public boolean writeMessage(ClusterTag msg, MessageWriter writer) throws MessageMappingException {
        ClusterTagImpl message = (ClusterTagImpl)msg;
        writer.setMessageTypeInfo(CmgMessagesTypeInfos.clusterTag());
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(message.groupType(), message.messageType(), (byte)2)) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                boolean written = writer.writeUuid("clusterId", message.clusterId());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                boolean written = writer.writeString("clusterName", message.clusterName());
                if (!written) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }
}

