/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.cluster.management.ClusterState;
import org.apache.ignite.internal.cluster.management.ClusterStateBuilder;
import org.apache.ignite.internal.cluster.management.ClusterTag;
import org.apache.ignite.internal.cluster.management.network.messages.CmgMessagesFactory;
import org.apache.ignite.internal.cluster.management.network.messages.CmgMessagesTypeInfos;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class ClusterStateDeserializer
implements MessageDeserializer<ClusterState> {
    private final ClusterStateBuilder msg;

    ClusterStateDeserializer(CmgMessagesFactory messageFactory) {
        this.msg = messageFactory.clusterState();
    }

    public Class<ClusterState> klass() {
        return ClusterState.class;
    }

    public ClusterState getMessage() {
        return this.msg.buildDeserialized();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        reader.setMessageTypeInfo(CmgMessagesTypeInfos.clusterState());
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = (ClusterTag)reader.readMessage("clusterTag");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.clusterTag((ClusterTag)tmp);
                }
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readSet("cmgNodes", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.cmgNodes((Set<String>)tmp);
                }
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readList("formerClusterIds", MessageCollectionItemType.UUID);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.formerClusterIds((List<UUID>)tmp);
                }
                reader.incrementState();
            }
            case 3: {
                Object tmp = reader.readString("initialClusterConfiguration");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.initialClusterConfiguration((String)tmp);
                }
                reader.incrementState();
            }
            case 4: {
                Object tmp = reader.readSet("metaStorageNodes", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.metaStorageNodes((Set<String>)tmp);
                }
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readString("version");
                if (!reader.isLastRead()) {
                    return false;
                }
                if (tmp != null) {
                    this.msg.version((String)tmp);
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ClusterState.class);
    }
}

