/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management;

import java.util.Objects;
import java.util.Set;
import org.apache.ignite.internal.cluster.management.MetaStorageInfo;
import org.apache.ignite.internal.cluster.management.MetaStorageInfoBuilder;
import org.apache.ignite.internal.cluster.management.MetaStorageInfoSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class MetaStorageInfoImpl
implements MetaStorageInfo,
Cloneable {
    public static final short GROUP_TYPE = 7;
    public static final short TYPE = 7;
    @IgniteToStringInclude
    private final Set<String> metaStorageNodes;
    @IgniteToStringInclude
    private final Long metastorageRepairingConfigIndex;

    private MetaStorageInfoImpl(Set<String> metaStorageNodes, Long metastorageRepairingConfigIndex) {
        this.metaStorageNodes = metaStorageNodes;
        this.metastorageRepairingConfigIndex = metastorageRepairingConfigIndex;
    }

    @Override
    public Set<String> metaStorageNodes() {
        return this.metaStorageNodes;
    }

    @Override
    public Long metastorageRepairingConfigIndex() {
        return this.metastorageRepairingConfigIndex;
    }

    public MessageSerializer serializer() {
        return MetaStorageInfoSerializer.INSTANCE;
    }

    public short groupType() {
        return 7;
    }

    public String toString() {
        return S.toString(MetaStorageInfoImpl.class, (Object)this);
    }

    public short messageType() {
        return 7;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MetaStorageInfoImpl otherMessage = (MetaStorageInfoImpl)other;
        return Objects.equals(this.metaStorageNodes, otherMessage.metaStorageNodes) && Objects.equals(this.metastorageRepairingConfigIndex, otherMessage.metastorageRepairingConfigIndex);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.metaStorageNodes, this.metastorageRepairingConfigIndex);
        return result;
    }

    public MetaStorageInfoImpl clone() {
        try {
            return (MetaStorageInfoImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static MetaStorageInfoBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements MetaStorageInfoBuilder {
        private Set<String> metaStorageNodes;
        private Long metastorageRepairingConfigIndex;

        private Builder() {
        }

        @Override
        public MetaStorageInfoBuilder metaStorageNodes(Set<String> metaStorageNodes) {
            Objects.requireNonNull(metaStorageNodes, "metaStorageNodes is not marked @Nullable");
            this.metaStorageNodes = metaStorageNodes;
            return this;
        }

        @Override
        public MetaStorageInfoBuilder metastorageRepairingConfigIndex(Long metastorageRepairingConfigIndex) {
            this.metastorageRepairingConfigIndex = metastorageRepairingConfigIndex;
            return this;
        }

        @Override
        public Set<String> metaStorageNodes() {
            return this.metaStorageNodes;
        }

        @Override
        public Long metastorageRepairingConfigIndex() {
            return this.metastorageRepairingConfigIndex;
        }

        @Override
        public MetaStorageInfo build() {
            return new MetaStorageInfoImpl(Objects.requireNonNull(this.metaStorageNodes, "metaStorageNodes is not marked @Nullable"), this.metastorageRepairingConfigIndex);
        }

        @Override
        public MetaStorageInfo buildDeserialized() {
            return new MetaStorageInfoImpl(this.metaStorageNodes, this.metastorageRepairingConfigIndex);
        }
    }
}

