/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.topology.api;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.network.ClusterNodeImpl;
import org.apache.ignite.internal.network.InternalClusterNode;
import org.apache.ignite.network.NetworkAddress;
import org.apache.ignite.network.NodeMetadata;
import org.jetbrains.annotations.Nullable;

public class LogicalNode
extends ClusterNodeImpl {
    private final Map<String, String> userAttributes;
    private final Map<String, String> systemAttributes;
    private final List<String> storageProfiles;

    public LogicalNode(UUID id, String name, NetworkAddress address) {
        this(id, name, address, null, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList());
    }

    public LogicalNode(InternalClusterNode clusterNode, Map<String, String> userAttributes) {
        this(clusterNode, userAttributes, Collections.emptyMap(), Collections.emptyList());
    }

    public LogicalNode(InternalClusterNode node, Map<String, String> userAttributes, Map<String, String> systemAttributes, List<String> storageProfiles) {
        this(node.id(), node.name(), node.address(), node.nodeMetadata(), userAttributes, systemAttributes, storageProfiles);
    }

    public LogicalNode(InternalClusterNode clusterNode) {
        this(clusterNode, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList());
    }

    LogicalNode(UUID id, String name, NetworkAddress address, @Nullable NodeMetadata nodeMetadata, Map<String, String> userAttributes, Map<String, String> systemAttributes, List<String> storageProfiles) {
        super(id, name, address, nodeMetadata);
        this.userAttributes = Map.copyOf(userAttributes);
        this.systemAttributes = Map.copyOf(systemAttributes);
        this.storageProfiles = List.copyOf(storageProfiles);
    }

    public Map<String, String> userAttributes() {
        return this.userAttributes;
    }

    public Map<String, String> systemAttributes() {
        return this.systemAttributes;
    }

    public List<String> storageProfiles() {
        return this.storageProfiles;
    }
}

