/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management.network.messages;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.cluster.management.network.messages.CmgInitMessage;
import org.apache.ignite.internal.cluster.management.network.messages.CmgInitMessageBuilder;
import org.apache.ignite.internal.cluster.management.network.messages.CmgInitMessageSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class CmgInitMessageImpl
implements CmgInitMessage,
Cloneable {
    public static final short GROUP_TYPE = 7;
    public static final short TYPE = 1;
    @IgniteToStringInclude
    private final UUID clusterId;
    @IgniteToStringInclude
    private final String clusterName;
    @IgniteToStringInclude
    private final Set<String> cmgNodes;
    @IgniteToStringInclude
    private final String initialClusterConfiguration;
    @IgniteToStringInclude
    private final Set<String> metaStorageNodes;

    private CmgInitMessageImpl(UUID clusterId, String clusterName, Set<String> cmgNodes, String initialClusterConfiguration, Set<String> metaStorageNodes) {
        this.clusterId = clusterId;
        this.clusterName = clusterName;
        this.cmgNodes = cmgNodes;
        this.initialClusterConfiguration = initialClusterConfiguration;
        this.metaStorageNodes = metaStorageNodes;
    }

    @Override
    public UUID clusterId() {
        return this.clusterId;
    }

    @Override
    public String clusterName() {
        return this.clusterName;
    }

    @Override
    public Set<String> cmgNodes() {
        return this.cmgNodes;
    }

    @Override
    public String initialClusterConfiguration() {
        return this.initialClusterConfiguration;
    }

    @Override
    public Set<String> metaStorageNodes() {
        return this.metaStorageNodes;
    }

    public MessageSerializer serializer() {
        return CmgInitMessageSerializer.INSTANCE;
    }

    public short groupType() {
        return 7;
    }

    public String toString() {
        return S.toString(CmgInitMessageImpl.class, (Object)this);
    }

    public short messageType() {
        return 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CmgInitMessageImpl otherMessage = (CmgInitMessageImpl)other;
        return Objects.equals(this.clusterId, otherMessage.clusterId) && Objects.equals(this.clusterName, otherMessage.clusterName) && Objects.equals(this.cmgNodes, otherMessage.cmgNodes) && Objects.equals(this.initialClusterConfiguration, otherMessage.initialClusterConfiguration) && Objects.equals(this.metaStorageNodes, otherMessage.metaStorageNodes);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.clusterId, this.clusterName, this.cmgNodes, this.initialClusterConfiguration, this.metaStorageNodes);
        return result;
    }

    public CmgInitMessageImpl clone() {
        try {
            return (CmgInitMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static CmgInitMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements CmgInitMessageBuilder {
        private UUID clusterId;
        private String clusterName;
        private Set<String> cmgNodes;
        private String initialClusterConfiguration;
        private Set<String> metaStorageNodes;

        private Builder() {
        }

        @Override
        public CmgInitMessageBuilder clusterId(UUID clusterId) {
            Objects.requireNonNull(clusterId, "clusterId is not marked @Nullable");
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public CmgInitMessageBuilder clusterName(String clusterName) {
            Objects.requireNonNull(clusterName, "clusterName is not marked @Nullable");
            this.clusterName = clusterName;
            return this;
        }

        @Override
        public CmgInitMessageBuilder cmgNodes(Set<String> cmgNodes) {
            Objects.requireNonNull(cmgNodes, "cmgNodes is not marked @Nullable");
            this.cmgNodes = cmgNodes;
            return this;
        }

        @Override
        public CmgInitMessageBuilder initialClusterConfiguration(String initialClusterConfiguration) {
            this.initialClusterConfiguration = initialClusterConfiguration;
            return this;
        }

        @Override
        public CmgInitMessageBuilder metaStorageNodes(Set<String> metaStorageNodes) {
            Objects.requireNonNull(metaStorageNodes, "metaStorageNodes is not marked @Nullable");
            this.metaStorageNodes = metaStorageNodes;
            return this;
        }

        @Override
        public UUID clusterId() {
            return this.clusterId;
        }

        @Override
        public String clusterName() {
            return this.clusterName;
        }

        @Override
        public Set<String> cmgNodes() {
            return this.cmgNodes;
        }

        @Override
        public String initialClusterConfiguration() {
            return this.initialClusterConfiguration;
        }

        @Override
        public Set<String> metaStorageNodes() {
            return this.metaStorageNodes;
        }

        @Override
        public CmgInitMessage build() {
            return new CmgInitMessageImpl(Objects.requireNonNull(this.clusterId, "clusterId is not marked @Nullable"), Objects.requireNonNull(this.clusterName, "clusterName is not marked @Nullable"), Objects.requireNonNull(this.cmgNodes, "cmgNodes is not marked @Nullable"), this.initialClusterConfiguration, Objects.requireNonNull(this.metaStorageNodes, "metaStorageNodes is not marked @Nullable"));
        }

        @Override
        public CmgInitMessage buildDeserialized() {
            return new CmgInitMessageImpl(this.clusterId, this.clusterName, this.cmgNodes, this.initialClusterConfiguration, this.metaStorageNodes);
        }
    }
}

