/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.cluster.management.ClusterState;
import org.apache.ignite.internal.cluster.management.ClusterStateBuilder;
import org.apache.ignite.internal.cluster.management.ClusterStateSerializer;
import org.apache.ignite.internal.cluster.management.ClusterTag;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ClusterStateImpl
implements ClusterState,
Cloneable {
    public static final short GROUP_TYPE = 7;
    public static final short TYPE = 61;
    @IgniteToStringInclude
    private final ClusterTag clusterTag;
    @IgniteToStringInclude
    private final Set<String> cmgNodes;
    @IgniteToStringInclude
    private final List<UUID> formerClusterIds;
    @IgniteToStringInclude
    private final String initialClusterConfiguration;
    @IgniteToStringInclude
    private final Set<String> metaStorageNodes;
    @IgniteToStringInclude
    private final String version;

    private ClusterStateImpl(ClusterTag clusterTag, Set<String> cmgNodes, List<UUID> formerClusterIds, String initialClusterConfiguration, Set<String> metaStorageNodes, String version) {
        this.clusterTag = clusterTag;
        this.cmgNodes = cmgNodes;
        this.formerClusterIds = formerClusterIds;
        this.initialClusterConfiguration = initialClusterConfiguration;
        this.metaStorageNodes = metaStorageNodes;
        this.version = version;
    }

    @Override
    public ClusterTag clusterTag() {
        return this.clusterTag;
    }

    @Override
    public Set<String> cmgNodes() {
        return this.cmgNodes;
    }

    @Override
    public List<UUID> formerClusterIds() {
        return this.formerClusterIds;
    }

    @Override
    public String initialClusterConfiguration() {
        return this.initialClusterConfiguration;
    }

    @Override
    public Set<String> metaStorageNodes() {
        return this.metaStorageNodes;
    }

    @Override
    public String version() {
        return this.version;
    }

    public MessageSerializer serializer() {
        return ClusterStateSerializer.INSTANCE;
    }

    public short groupType() {
        return 7;
    }

    public String toString() {
        return S.toString(ClusterStateImpl.class, (Object)this);
    }

    public short messageType() {
        return 61;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClusterStateImpl otherMessage = (ClusterStateImpl)other;
        return Objects.equals(this.clusterTag, otherMessage.clusterTag) && Objects.equals(this.cmgNodes, otherMessage.cmgNodes) && Objects.equals(this.formerClusterIds, otherMessage.formerClusterIds) && Objects.equals(this.initialClusterConfiguration, otherMessage.initialClusterConfiguration) && Objects.equals(this.metaStorageNodes, otherMessage.metaStorageNodes) && Objects.equals(this.version, otherMessage.version);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.clusterTag, this.cmgNodes, this.formerClusterIds, this.initialClusterConfiguration, this.metaStorageNodes, this.version);
        return result;
    }

    public ClusterStateImpl clone() {
        try {
            return (ClusterStateImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ClusterStateBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.clusterTag != null) {
            this.clusterTag.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.clusterTag != null) {
            this.clusterTag.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements ClusterStateBuilder {
        private ClusterTag clusterTag;
        private Set<String> cmgNodes;
        private List<UUID> formerClusterIds;
        private String initialClusterConfiguration;
        private Set<String> metaStorageNodes;
        private String version;

        private Builder() {
        }

        @Override
        public ClusterStateBuilder clusterTag(ClusterTag clusterTag) {
            Objects.requireNonNull(clusterTag, "clusterTag is not marked @Nullable");
            this.clusterTag = clusterTag;
            return this;
        }

        @Override
        public ClusterStateBuilder cmgNodes(Set<String> cmgNodes) {
            Objects.requireNonNull(cmgNodes, "cmgNodes is not marked @Nullable");
            this.cmgNodes = cmgNodes;
            return this;
        }

        @Override
        public ClusterStateBuilder formerClusterIds(List<UUID> formerClusterIds) {
            this.formerClusterIds = formerClusterIds;
            return this;
        }

        @Override
        public ClusterStateBuilder initialClusterConfiguration(String initialClusterConfiguration) {
            this.initialClusterConfiguration = initialClusterConfiguration;
            return this;
        }

        @Override
        public ClusterStateBuilder metaStorageNodes(Set<String> metaStorageNodes) {
            Objects.requireNonNull(metaStorageNodes, "metaStorageNodes is not marked @Nullable");
            this.metaStorageNodes = metaStorageNodes;
            return this;
        }

        @Override
        public ClusterStateBuilder version(String version) {
            Objects.requireNonNull(version, "version is not marked @Nullable");
            this.version = version;
            return this;
        }

        @Override
        public ClusterTag clusterTag() {
            return this.clusterTag;
        }

        @Override
        public Set<String> cmgNodes() {
            return this.cmgNodes;
        }

        @Override
        public List<UUID> formerClusterIds() {
            return this.formerClusterIds;
        }

        @Override
        public String initialClusterConfiguration() {
            return this.initialClusterConfiguration;
        }

        @Override
        public Set<String> metaStorageNodes() {
            return this.metaStorageNodes;
        }

        @Override
        public String version() {
            return this.version;
        }

        @Override
        public ClusterState build() {
            return new ClusterStateImpl(Objects.requireNonNull(this.clusterTag, "clusterTag is not marked @Nullable"), Objects.requireNonNull(this.cmgNodes, "cmgNodes is not marked @Nullable"), this.formerClusterIds, this.initialClusterConfiguration, Objects.requireNonNull(this.metaStorageNodes, "metaStorageNodes is not marked @Nullable"), Objects.requireNonNull(this.version, "version is not marked @Nullable"));
        }

        @Override
        public ClusterState buildDeserialized() {
            return new ClusterStateImpl(this.clusterTag, this.cmgNodes, this.formerClusterIds, this.initialClusterConfiguration, this.metaStorageNodes, this.version);
        }
    }
}

