/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster.management;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.cluster.management.ClusterStateV2;
import org.apache.ignite.internal.cluster.management.ClusterStateV2Builder;
import org.apache.ignite.internal.cluster.management.ClusterStateV2Serializer;
import org.apache.ignite.internal.cluster.management.ClusterTag;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class ClusterStateV2Impl
implements ClusterStateV2,
Cloneable {
    public static final short GROUP_TYPE = 7;
    public static final short TYPE = 1002;
    @IgniteToStringInclude
    private final ClusterTag clusterTag;
    @IgniteToStringInclude
    private final Set<String> cmgNodes;
    @IgniteToStringInclude
    private final List<UUID> formerClusterIds;
    @IgniteToStringInclude
    private final String initialClusterConfiguration;
    @IgniteToStringInclude
    private final Set<String> metaStorageNodes;
    @IgniteToStringInclude
    private final String nextVersion;
    @IgniteToStringInclude
    private final String version;

    private ClusterStateV2Impl(ClusterTag clusterTag, Set<String> cmgNodes, List<UUID> formerClusterIds, String initialClusterConfiguration, Set<String> metaStorageNodes, String nextVersion, String version) {
        this.clusterTag = clusterTag;
        this.cmgNodes = cmgNodes;
        this.formerClusterIds = formerClusterIds;
        this.initialClusterConfiguration = initialClusterConfiguration;
        this.metaStorageNodes = metaStorageNodes;
        this.nextVersion = nextVersion;
        this.version = version;
    }

    @Override
    public ClusterTag clusterTag() {
        return this.clusterTag;
    }

    @Override
    public Set<String> cmgNodes() {
        return this.cmgNodes;
    }

    @Override
    public List<UUID> formerClusterIds() {
        return this.formerClusterIds;
    }

    @Override
    public String initialClusterConfiguration() {
        return this.initialClusterConfiguration;
    }

    @Override
    public Set<String> metaStorageNodes() {
        return this.metaStorageNodes;
    }

    @Override
    public String nextVersion() {
        return this.nextVersion;
    }

    @Override
    public String version() {
        return this.version;
    }

    public MessageSerializer serializer() {
        return ClusterStateV2Serializer.INSTANCE;
    }

    public short groupType() {
        return 7;
    }

    public String toString() {
        return S.toString(ClusterStateV2Impl.class, (Object)this);
    }

    public short messageType() {
        return 1002;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ClusterStateV2Impl otherMessage = (ClusterStateV2Impl)other;
        return Objects.equals(this.clusterTag, otherMessage.clusterTag) && Objects.equals(this.cmgNodes, otherMessage.cmgNodes) && Objects.equals(this.formerClusterIds, otherMessage.formerClusterIds) && Objects.equals(this.initialClusterConfiguration, otherMessage.initialClusterConfiguration) && Objects.equals(this.metaStorageNodes, otherMessage.metaStorageNodes) && Objects.equals(this.nextVersion, otherMessage.nextVersion) && Objects.equals(this.version, otherMessage.version);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.clusterTag, this.cmgNodes, this.formerClusterIds, this.initialClusterConfiguration, this.metaStorageNodes, this.nextVersion, this.version);
        return result;
    }

    public ClusterStateV2Impl clone() {
        try {
            return (ClusterStateV2Impl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ClusterStateV2Builder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.clusterTag != null) {
            this.clusterTag.prepareMarshal(usedDescriptors, marshaller);
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.clusterTag != null) {
            this.clusterTag.unmarshal(marshaller, descriptorsObj);
        }
    }

    private static class Builder
    implements ClusterStateV2Builder {
        private ClusterTag clusterTag;
        private Set<String> cmgNodes;
        private List<UUID> formerClusterIds;
        private String initialClusterConfiguration;
        private Set<String> metaStorageNodes;
        private String nextVersion;
        private String version;

        private Builder() {
        }

        @Override
        public ClusterStateV2Builder clusterTag(ClusterTag clusterTag) {
            Objects.requireNonNull(clusterTag, "clusterTag is not marked @Nullable");
            this.clusterTag = clusterTag;
            return this;
        }

        @Override
        public ClusterStateV2Builder cmgNodes(Set<String> cmgNodes) {
            Objects.requireNonNull(cmgNodes, "cmgNodes is not marked @Nullable");
            this.cmgNodes = cmgNodes;
            return this;
        }

        @Override
        public ClusterStateV2Builder formerClusterIds(List<UUID> formerClusterIds) {
            this.formerClusterIds = formerClusterIds;
            return this;
        }

        @Override
        public ClusterStateV2Builder initialClusterConfiguration(String initialClusterConfiguration) {
            this.initialClusterConfiguration = initialClusterConfiguration;
            return this;
        }

        @Override
        public ClusterStateV2Builder metaStorageNodes(Set<String> metaStorageNodes) {
            Objects.requireNonNull(metaStorageNodes, "metaStorageNodes is not marked @Nullable");
            this.metaStorageNodes = metaStorageNodes;
            return this;
        }

        @Override
        public ClusterStateV2Builder nextVersion(String nextVersion) {
            this.nextVersion = nextVersion;
            return this;
        }

        @Override
        public ClusterStateV2Builder version(String version) {
            Objects.requireNonNull(version, "version is not marked @Nullable");
            this.version = version;
            return this;
        }

        @Override
        public ClusterTag clusterTag() {
            return this.clusterTag;
        }

        @Override
        public Set<String> cmgNodes() {
            return this.cmgNodes;
        }

        @Override
        public List<UUID> formerClusterIds() {
            return this.formerClusterIds;
        }

        @Override
        public String initialClusterConfiguration() {
            return this.initialClusterConfiguration;
        }

        @Override
        public Set<String> metaStorageNodes() {
            return this.metaStorageNodes;
        }

        @Override
        public String nextVersion() {
            return this.nextVersion;
        }

        @Override
        public String version() {
            return this.version;
        }

        @Override
        public ClusterStateV2 build() {
            return new ClusterStateV2Impl(Objects.requireNonNull(this.clusterTag, "clusterTag is not marked @Nullable"), Objects.requireNonNull(this.cmgNodes, "cmgNodes is not marked @Nullable"), this.formerClusterIds, this.initialClusterConfiguration, Objects.requireNonNull(this.metaStorageNodes, "metaStorageNodes is not marked @Nullable"), this.nextVersion, Objects.requireNonNull(this.version, "version is not marked @Nullable"));
        }

        @Override
        public ClusterStateV2 buildDeserialized() {
            return new ClusterStateV2Impl(this.clusterTag, this.cmgNodes, this.formerClusterIds, this.initialClusterConfiguration, this.metaStorageNodes, this.nextVersion, this.version);
        }
    }
}

