/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.discovery.tcp.ipfinder.cloud;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinderAdapter;
import org.jclouds.ContextBuilder;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.Location;
import org.jclouds.googlecloud.GoogleCredentialsFromJson;

public class TcpDiscoveryCloudIpFinder
extends TcpDiscoveryIpFinderAdapter {
    private static final String JCLOUD_CONNECTION_TIMEOUT = "10000";
    private String provider;
    private String identity;
    @GridToStringExclude
    private String credential;
    @GridToStringExclude
    private String credentialPath;
    private TreeSet<String> regions;
    private TreeSet<String> zones;
    private Predicate<ComputeMetadata> nodesFilter;
    @GridToStringExclude
    private final AtomicBoolean initGuard = new AtomicBoolean();
    @GridToStringExclude
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private ComputeService computeService;

    public TcpDiscoveryCloudIpFinder() {
        this.setShared(true);
    }

    public Collection<InetSocketAddress> getRegisteredAddresses() throws IgniteSpiException {
        this.initComputeService();
        LinkedList<InetSocketAddress> addresses = new LinkedList<InetSocketAddress>();
        try {
            Set<NodeMetadata> nodes;
            if (this.nodesFilter != null) {
                nodes = this.computeService.listNodesDetailsMatching(this.nodesFilter);
            } else {
                nodes = new HashSet();
                for (ComputeMetadata computeMetadata : this.computeService.listNodes()) {
                    nodes.add(this.computeService.getNodeMetadata(computeMetadata.getId()));
                }
            }
            for (NodeMetadata nodeMetadata : nodes) {
                if (nodeMetadata.getStatus() != NodeMetadata.Status.RUNNING) continue;
                for (String addr : nodeMetadata.getPrivateAddresses()) {
                    addresses.add(new InetSocketAddress(addr, 0));
                }
                for (String addr : nodeMetadata.getPublicAddresses()) {
                    addresses.add(new InetSocketAddress(addr, 0));
                }
            }
        }
        catch (Exception e) {
            throw new IgniteSpiException("Failed to get registered addresses for the provider: " + this.provider, (Throwable)e);
        }
        return addresses;
    }

    public void registerAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
    }

    public void unregisterAddresses(Collection<InetSocketAddress> addrs) throws IgniteSpiException {
    }

    @IgniteSpiConfiguration(optional=false)
    public TcpDiscoveryCloudIpFinder setProvider(String provider) {
        this.provider = provider;
        return this;
    }

    @IgniteSpiConfiguration(optional=false)
    public TcpDiscoveryCloudIpFinder setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoveryCloudIpFinder setCredential(String credential) {
        this.credential = credential;
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoveryCloudIpFinder setCredentialPath(String credentialPath) {
        this.credentialPath = credentialPath;
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoveryCloudIpFinder setZones(Collection<String> zones) {
        if (!F.isEmpty(zones)) {
            this.zones = new TreeSet<String>(zones);
        }
        return this;
    }

    @IgniteSpiConfiguration(optional=true)
    public TcpDiscoveryCloudIpFinder setRegions(Collection<String> regions) {
        if (!F.isEmpty(regions)) {
            this.regions = new TreeSet<String>(regions);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initComputeService() {
        if (this.initGuard.compareAndSet(false, true)) {
            try {
                if (this.provider == null) {
                    throw new IgniteSpiException("Cloud provider is not set.");
                }
                if (this.identity == null) {
                    throw new IgniteSpiException("Cloud identity is not set.");
                }
                if (this.credential != null && this.credentialPath != null) {
                    throw new IgniteSpiException("Both credential and credentialPath are set. Use only one method.");
                }
                if (this.credentialPath != null) {
                    this.credential = this.getCredentialFromFile();
                }
                try {
                    ContextBuilder ctxBuilder = ContextBuilder.newBuilder((String)this.provider);
                    ctxBuilder.credentials(this.identity, this.credential);
                    Properties properties = new Properties();
                    properties.setProperty("jclouds.so-timeout", JCLOUD_CONNECTION_TIMEOUT);
                    properties.setProperty("jclouds.connection-timeout", JCLOUD_CONNECTION_TIMEOUT);
                    if (!F.isEmpty(this.regions)) {
                        properties.setProperty("jclouds.regions", this.keysSetToStr(this.regions));
                    }
                    if (!F.isEmpty(this.zones)) {
                        properties.setProperty("jclouds.zones", this.keysSetToStr(this.zones));
                    }
                    ctxBuilder.overrides(properties);
                    this.computeService = ((ComputeServiceContext)ctxBuilder.buildView(ComputeServiceContext.class)).getComputeService();
                    if (F.isEmpty(this.zones) && F.isEmpty(this.regions)) return;
                    this.nodesFilter = new Predicate<ComputeMetadata>(){

                        public boolean apply(ComputeMetadata computeMetadata) {
                            String region = null;
                            String zone = null;
                            block4: for (Location location = computeMetadata.getLocation(); location != null; location = location.getParent()) {
                                switch (location.getScope()) {
                                    case ZONE: {
                                        zone = location.getId();
                                        continue block4;
                                    }
                                    case REGION: {
                                        region = location.getId();
                                    }
                                }
                            }
                            if (TcpDiscoveryCloudIpFinder.this.regions != null && region != null && !TcpDiscoveryCloudIpFinder.this.regions.contains(region)) {
                                return false;
                            }
                            return TcpDiscoveryCloudIpFinder.this.zones == null || zone == null || TcpDiscoveryCloudIpFinder.this.zones.contains(zone);
                        }
                    };
                    return;
                }
                catch (Exception e) {
                    throw new IgniteSpiException("Failed to connect to the provider: " + this.provider, (Throwable)e);
                }
            }
            finally {
                this.initLatch.countDown();
            }
        }
        try {
            U.await((CountDownLatch)this.initLatch);
        }
        catch (IgniteInterruptedCheckedException e) {
            throw new IgniteSpiException("Thread has been interrupted.", (Throwable)e);
        }
        if (this.computeService != null) return;
        throw new IgniteSpiException("Ip finder has not been initialized properly.");
    }

    private String getCredentialFromFile() throws IgniteSpiException {
        try {
            String fileContents = Files.toString((File)new File(this.credentialPath), (Charset)Charsets.UTF_8);
            if (this.provider.equals("google-compute-engine")) {
                GoogleCredentialsFromJson credentialSupplier = new GoogleCredentialsFromJson(fileContents);
                return ((Credentials)credentialSupplier.get()).credential;
            }
            return fileContents;
        }
        catch (IOException e) {
            throw new IgniteSpiException("Failed to retrieve the private key from the file: " + this.credentialPath, (Throwable)e);
        }
    }

    private String keysSetToStr(Set<String> set) {
        Iterator<String> iter = set.iterator();
        StringBuilder builder = new StringBuilder();
        while (iter.hasNext()) {
            builder.append(iter.next());
            if (!iter.hasNext()) continue;
            builder.append(',');
        }
        return builder.toString();
    }

    public TcpDiscoveryCloudIpFinder setShared(boolean shared) {
        super.setShared(shared);
        return this;
    }

    public String toString() {
        return S.toString(TcpDiscoveryCloudIpFinder.class, (Object)((Object)this));
    }
}

