/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.processors.cache.WalModeChangeAbstractSelfTest;

public class JdbcThinWalModeChangeSelfTest
extends WalModeChangeAbstractSelfTest {
    public JdbcThinWalModeChangeSelfTest() {
        super(false, true);
    }

    protected void createCache(Ignite node, CacheConfiguration ccfg) throws IgniteCheckedException {
        String template = ccfg.getCacheMode() == CacheMode.PARTITIONED ? "PARTITIONED" : "REPLICATED";
        String cmd = "CREATE TABLE IF NOT EXISTS " + ccfg.getName() + " (k BIGINT PRIMARY KEY, v BIGINT) WITH \"TEMPLATE=" + template + ", CACHE_NAME=" + ccfg.getName() + ", ATOMICITY=" + ccfg.getAtomicityMode() + (ccfg.getGroupName() != null ? ", CACHE_GROUP=" + ccfg.getGroupName() : "") + (ccfg.getDataRegionName() != null ? ", DATA_REGION=" + ccfg.getDataRegionName() : "") + "\"";
        JdbcThinWalModeChangeSelfTest.execute(node, cmd);
        this.alignCacheTopologyVersion(node);
    }

    protected void destroyCache(Ignite node, String cacheName) throws IgniteCheckedException {
        String cmd = "DROP TABLE IF EXISTS " + cacheName;
        JdbcThinWalModeChangeSelfTest.execute(node, cmd);
        this.alignCacheTopologyVersion(node);
    }

    protected boolean walEnable(Ignite node, String cacheName) {
        try {
            String cmd = "ALTER TABLE " + cacheName + " LOGGING";
            JdbcThinWalModeChangeSelfTest.execute(node, cmd);
            return true;
        }
        catch (RuntimeException e) {
            SQLException e0;
            if (e.getCause() != null && e.getCause() instanceof SQLException && (e0 = (SQLException)e.getCause()).getMessage().startsWith("Logging already enabled")) {
                return false;
            }
            throw e;
        }
    }

    protected boolean walDisable(Ignite node, String cacheName) {
        try {
            String cmd = "ALTER TABLE " + cacheName + " NOLOGGING";
            JdbcThinWalModeChangeSelfTest.execute(node, cmd);
            return true;
        }
        catch (RuntimeException e) {
            SQLException e0;
            if (e.getCause() != null && e.getCause() instanceof SQLException && (e0 = (SQLException)e.getCause()).getMessage().startsWith("Logging already disabled")) {
                return false;
            }
            throw e;
        }
    }

    private static void execute(Ignite node, String cmd) {
        try (Connection conn = JdbcThinWalModeChangeSelfTest.connect(node);
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate(cmd);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Connection connect(Ignite node) throws Exception {
        IgniteKernal node0 = (IgniteKernal)node;
        int port = node0.context().sqlListener().port();
        return DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:" + port);
    }
}

