/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.NestedTxMode;
import org.apache.ignite.internal.processors.query.h2.ConnectionManager;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.junit.Test;

public class JdbcThinTransactionsLeaksMvccTest
extends JdbcThinAbstractSelfTest {
    private static final String URL = "jdbc:ignite:thin://127.0.0.1";
    private static final int KEYS = 10;
    private static final int ITERATIONS = 1000;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        return super.getConfiguration(igniteInstanceName).setSystemWorkerBlockedTimeout(Long.MAX_VALUE);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrids(3);
        try (Connection c = JdbcThinTransactionsLeaksMvccTest.c(true, NestedTxMode.ERROR);
             Statement s = c.createStatement();){
            s.execute("CREATE TABLE TEST (k int primary key, v int) WITH \"atomicity=transactional_snapshot\"");
            for (int i = 0; i < 10; ++i) {
                s.execute("INSERT INTO TEST VALUES (" + i + ", " + i + ")");
            }
        }
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
    }

    private static Connection c(boolean autoCommit, NestedTxMode nestedTxMode) throws SQLException {
        Connection res = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1/?nestedTransactionsMode=" + nestedTxMode.name());
        res.setAutoCommit(autoCommit);
        return res;
    }

    @Test
    @WithSystemProperty(key="IGNITE_MAX_COMPLETED_TX_COUNT", value="1024")
    public void testLeaks() {
        this.runQueries(1000);
        int prevUsedConns = this.usedConnectionsCount(this.grid(0));
        this.runQueries(2000);
        int curUsedConns = this.usedConnectionsCount(this.grid(0));
        JdbcThinTransactionsLeaksMvccTest.assertTrue((String)("Used connection leaks: prevSize=" + prevUsedConns + ", curSize=" + curUsedConns), (curUsedConns < prevUsedConns * 2 + 1 ? 1 : 0) != 0);
    }

    private void runQueries(int iters) {
        for (int i = 0; i < iters; ++i) {
            try (Connection c = JdbcThinTransactionsLeaksMvccTest.c(false, NestedTxMode.ERROR);
                 Statement s = c.createStatement();){
                s.execute("BEGIN");
                s.execute("SELECT * FROM TEST");
                ResultSet rs = s.getResultSet();
                int cnt = 0;
                while (rs.next()) {
                    ++cnt;
                }
                JdbcThinTransactionsLeaksMvccTest.assertEquals((int)10, (int)cnt);
                c.commit();
                continue;
            }
            catch (SQLException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private int usedConnectionsCount(IgniteEx igx) {
        ConnectionManager connMgr = ((IgniteH2Indexing)igx.context().query().getIndexing()).connections();
        Set usedConns = (Set)GridTestUtils.getFieldValue((Object)connMgr, (String[])new String[]{"usedConns"});
        return usedConns.size();
    }
}

