/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.internal.jdbc2.JdbcStreamingSelfTest;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.GridQueryProcessor;
import org.apache.ignite.internal.processors.query.SqlClientContext;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public abstract class JdbcThinStreamingAbstractSelfTest
extends JdbcStreamingSelfTest {
    protected int batchSize = 17;

    @Override
    protected void beforeTestsStarted() throws Exception {
        GridQueryProcessor.idxCls = IndexingWithContext.class;
        super.beforeTestsStarted();
        this.batchSize = 17;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        try (Connection c = this.createOrdinaryConnection();){
            JdbcThinStreamingAbstractSelfTest.execute(c, "SELECT 1");
        }
    }

    @Override
    protected void afterTest() throws Exception {
        try (Connection c = this.createOrdinaryConnection();){
            JdbcThinStreamingAbstractSelfTest.execute(c, "DROP TABLE PUBLIC.T IF EXISTS");
        }
        IndexingWithContext.cliCtx = null;
        super.afterTest();
    }

    @Override
    protected Connection createStreamedConnection(boolean allowOverwrite, long flushFreq) throws Exception {
        Connection c = this.connect(this.grid(0), null);
        JdbcThinStreamingAbstractSelfTest.execute(c, "SET STREAMING 1 BATCH_SIZE " + this.batchSize + " ALLOW_OVERWRITE " + (allowOverwrite ? 1 : 0) + " PER_NODE_BUFFER_SIZE 1000 FLUSH_FREQUENCY " + flushFreq);
        return c;
    }

    @Override
    protected Connection createOrdinaryConnection() throws SQLException {
        return this.connect(this.grid(0), null);
    }

    @Test
    public void testStreamedBatchedInsert() throws Exception {
        for (int i = 10; i <= 100; i += 10) {
            this.put(i, this.nameForId(i * 100));
        }
        try (Connection conn = this.createStreamedConnection(false);){
            this.assertStreamingState(true);
            try (PreparedStatement stmt = conn.prepareStatement("insert into Person(\"id\", \"name\") values (?, ?), (?, ?)");){
                for (int i = 1; i <= 100; i += 2) {
                    stmt.setInt(1, i);
                    stmt.setString(2, this.nameForId(i));
                    stmt.setInt(3, i + 1);
                    stmt.setString(4, this.nameForId(i + 1));
                    stmt.addBatch();
                }
                stmt.executeBatch();
            }
        }
        U.sleep((long)500L);
        for (int i = 1; i <= 100; ++i) {
            if (i % 10 != 0) {
                JdbcThinStreamingAbstractSelfTest.assertEquals((String)this.nameForId(i), (String)this.nameForIdInCache(i));
                continue;
            }
            JdbcThinStreamingAbstractSelfTest.assertEquals((String)this.nameForId(i * 100), (String)this.nameForIdInCache(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimultaneousStreaming() throws Exception {
        int i;
        try (Connection anotherConn = this.createOrdinaryConnection();){
            JdbcThinStreamingAbstractSelfTest.execute(anotherConn, "CREATE TABLE PUBLIC.T(x int primary key, y int) WITH \"cache_name=T,wrap_value=false\"");
        }
        U.sleep((long)500L);
        var2_3 = null;
        try (Connection conn = this.createStreamedConnection(false, 10000L);){
            this.assertStreamingState(true);
            PreparedStatement firstStmt = conn.prepareStatement("insert into Person(\"id\", \"name\") values (?, ?)");
            PreparedStatement secondStmt = conn.prepareStatement("insert into PUBLIC.T(x, y) values (?, ?)");
            try {
                int i2;
                for (i2 = 1; i2 <= 10; ++i2) {
                    firstStmt.setInt(1, i2);
                    firstStmt.setString(2, this.nameForId(i2));
                    firstStmt.executeUpdate();
                }
                for (i2 = 51; i2 <= 67; ++i2) {
                    secondStmt.setInt(1, i2);
                    secondStmt.setInt(2, i2);
                    secondStmt.executeUpdate();
                }
                for (i2 = 11; i2 <= 50; ++i2) {
                    firstStmt.setInt(1, i2);
                    firstStmt.setString(2, this.nameForId(i2));
                    firstStmt.executeUpdate();
                }
                for (i2 = 68; i2 <= 100; ++i2) {
                    secondStmt.setInt(1, i2);
                    secondStmt.setInt(2, i2);
                    secondStmt.executeUpdate();
                }
                this.assertCacheEmpty();
                SqlClientContext cliCtx = this.sqlClientContext();
                HashMap streamers = (HashMap)U.field((Object)cliCtx, (String)"streamers");
                GridTestUtils.waitForCondition(() -> streamers.size() == 2, (long)1000L);
                JdbcThinStreamingAbstractSelfTest.assertEquals((int)2, (int)streamers.size());
                JdbcThinStreamingAbstractSelfTest.assertEqualsCollections(new HashSet<String>(Arrays.asList("person", "T")), streamers.keySet());
            }
            finally {
                U.closeQuiet((AutoCloseable)firstStmt);
                U.closeQuiet((AutoCloseable)secondStmt);
            }
        }
        catch (Throwable throwable) {
            var2_3 = throwable;
            throw throwable;
        }
        U.sleep((long)1000L);
        for (i = 1; i <= 50; ++i) {
            JdbcThinStreamingAbstractSelfTest.assertEquals((String)this.nameForId(i), (String)this.nameForIdInCache(i));
        }
        for (i = 51; i <= 100; ++i) {
            JdbcThinStreamingAbstractSelfTest.assertEquals((Object)i, (Object)this.grid(0).cache("T").get((Object)i));
        }
    }

    @Override
    @Ignore(value="https://ggsystems.atlassian.net/browse/GG-17406")
    @Test
    public void testStreamedInsertFailsOnReadOnlyMode() throws Exception {
        super.testStreamedInsertFailsOnReadOnlyMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStreamingWithMixedStatementTypes() throws Exception {
        String prepStmtStr = "insert into Person(\"id\", \"name\") values (?, ?)";
        String stmtStr = "insert into Person(\"id\", \"name\") values (%d, '%s')";
        try (Connection conn = this.createStreamedConnection(false, 10000L);){
            this.assertStreamingState(true);
            PreparedStatement firstStmt = conn.prepareStatement(prepStmtStr);
            Statement secondStmt = conn.createStatement();
            try {
                for (int i = 1; i <= 100; ++i) {
                    boolean useBatch;
                    boolean usePrep = Math.random() > 0.5;
                    boolean bl = useBatch = Math.random() > 0.5;
                    if (usePrep) {
                        firstStmt.setInt(1, i);
                        firstStmt.setString(2, this.nameForId(i));
                        if (useBatch) {
                            firstStmt.addBatch();
                            continue;
                        }
                        firstStmt.execute();
                        continue;
                    }
                    String sql = String.format(stmtStr, i, this.nameForId(i));
                    if (useBatch) {
                        secondStmt.addBatch(sql);
                        continue;
                    }
                    secondStmt.execute(sql);
                }
            }
            finally {
                U.closeQuiet((AutoCloseable)firstStmt);
                U.closeQuiet((AutoCloseable)secondStmt);
            }
        }
        U.sleep((long)1000L);
        for (int i = 1; i <= 100; ++i) {
            JdbcThinStreamingAbstractSelfTest.assertEquals((String)this.nameForId(i), (String)this.nameForIdInCache(i));
        }
    }

    @Test
    public void testStreamingOffToOn() throws Exception {
        try (Connection conn = this.createOrdinaryConnection();){
            this.assertStreamingState(false);
            JdbcThinStreamingAbstractSelfTest.execute(conn, "SET STREAMING 1");
            this.assertStreamingState(true);
        }
    }

    @Test
    public void testStreamingOffToOff() throws Exception {
        try (Connection conn = this.createOrdinaryConnection();){
            this.assertStreamingState(false);
            JdbcThinStreamingAbstractSelfTest.execute(conn, "SET STREAMING 0");
            this.assertStreamingState(false);
        }
    }

    @Test
    public void testStreamingOnToOff() throws Exception {
        try (Connection conn = this.createStreamedConnection(false);){
            this.assertStreamingState(true);
            JdbcThinStreamingAbstractSelfTest.execute(conn, "SET STREAMING off");
            this.assertStreamingState(false);
        }
    }

    @Test
    public void testFlush() throws Exception {
        try (Connection conn = this.createStreamedConnection(false, 10000L);){
            this.assertStreamingState(true);
            try (PreparedStatement stmt = conn.prepareStatement("insert into Person(\"id\", \"name\") values (?, ?)");){
                for (int i = 1; i <= 100; ++i) {
                    stmt.setInt(1, i);
                    stmt.setString(2, this.nameForId(i));
                    stmt.executeUpdate();
                }
            }
            this.assertCacheEmpty();
            JdbcThinStreamingAbstractSelfTest.execute(conn, "set streaming 0");
            this.assertStreamingState(false);
            U.sleep((long)500L);
            for (int i = 1; i <= 100; ++i) {
                JdbcThinStreamingAbstractSelfTest.assertEquals((String)this.nameForId(i), (String)this.nameForIdInCache(i));
            }
        }
    }

    @Test
    public void testCustomObject() throws Exception {
        try (Connection conn = this.createOrdinaryConnection();){
            JdbcThinStreamingAbstractSelfTest.execute(conn, "CREATE TABLE t2(id INT PRIMARY KEY, val OTHER)");
        }
        conn = this.createStreamedConnection(false, 10000L);
        var2_2 = null;
        try {
            this.assertStreamingState(true);
            int testInd = 1 + new Random().nextInt(1000);
            try (PreparedStatement stmt = conn.prepareStatement("INSERT INTO t2 values (?, ?)");){
                for (int i = 1; i <= 1000; ++i) {
                    stmt.setInt(1, i);
                    stmt.setObject(2, i == testInd ? new Foo(testInd) : null);
                    stmt.executeUpdate();
                }
            }
            this.assertCacheEmpty();
            JdbcThinStreamingAbstractSelfTest.execute(conn, "set streaming 0");
            this.assertStreamingState(false);
            U.sleep((long)500L);
            stmt = conn.prepareStatement("SELECT val FROM t2 WHERE id = ?");
            var5_11 = null;
            try {
                stmt.setInt(1, testInd);
                ResultSet rs = stmt.executeQuery();
                Assert.assertTrue((String)"Result should not be empty", (boolean)rs.next());
                Foo foo = rs.getObject(1, Foo.class);
                Assert.assertEquals((String)"Stored value not equals the expected one", (long)testInd, (long)foo.val);
            }
            catch (Throwable throwable) {
                var5_11 = throwable;
                throw throwable;
            }
            finally {
                if (stmt != null) {
                    if (var5_11 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            var5_11.addSuppressed(throwable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testStreamingReEnabled() throws Exception {
        try (Connection conn = this.createStreamedConnection(false, 10000L);){
            this.assertStreamingState(true);
            try (PreparedStatement stmt = conn.prepareStatement("insert into Person(\"id\", \"name\") values (?, ?)");){
                for (int i = 1; i <= 100; ++i) {
                    stmt.setInt(1, i);
                    stmt.setString(2, this.nameForId(i));
                    stmt.executeUpdate();
                }
            }
            this.assertCacheEmpty();
            JdbcThinStreamingAbstractSelfTest.execute(conn, "set streaming 1 batch_size 111 allow_overwrite 0 per_node_buffer_size 512 per_node_parallel_operations 4 flush_frequency 5000");
            U.sleep((long)500L);
            JdbcThinStreamingAbstractSelfTest.assertEquals((Object)111, (Object)U.field((Object)U.field((Object)conn, (String)"streamState"), (String)"streamBatchSize"));
            SqlClientContext cliCtx = this.sqlClientContext();
            JdbcThinStreamingAbstractSelfTest.assertTrue((boolean)cliCtx.isStream());
            JdbcThinStreamingAbstractSelfTest.assertFalse((boolean)((Boolean)U.field((Object)cliCtx, (String)"streamAllowOverwrite")));
            JdbcThinStreamingAbstractSelfTest.assertEquals((Object)512, (Object)U.field((Object)cliCtx, (String)"streamNodeBufSize"));
            JdbcThinStreamingAbstractSelfTest.assertEquals((Object)5000L, (Object)U.field((Object)cliCtx, (String)"streamFlushTimeout"));
            JdbcThinStreamingAbstractSelfTest.assertEquals((Object)4, (Object)U.field((Object)cliCtx, (String)"streamNodeParOps"));
            for (int i = 1; i <= 100; ++i) {
                JdbcThinStreamingAbstractSelfTest.assertEquals((String)this.nameForId(i), (String)this.nameForIdInCache(i));
            }
        }
    }

    @Test
    public void testNonStreamedBatch() {
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try (Connection conn = JdbcThinStreamingAbstractSelfTest.this.createOrdinaryConnection();
                     Statement s = conn.createStatement();){
                    for (int i = 1; i <= 10; ++i) {
                        s.addBatch(String.format("insert into Person(\"id\", \"name\")values (%d, '%s')", i, JdbcThinStreamingAbstractSelfTest.this.nameForId(i)));
                    }
                    JdbcThinStreamingAbstractSelfTest.execute(conn, "SET STREAMING 1");
                    s.addBatch(String.format("insert into Person(\"id\", \"name\")values (%d, '%s')", 11, JdbcThinStreamingAbstractSelfTest.this.nameForId(11)));
                }
                return null;
            }
        }, SQLException.class, (String)"Statement has non-empty batch (call executeBatch() or clearBatch() before enabling streaming).");
    }

    @Test
    public void testStreamingStatementInTheMiddleOfNonPreparedBatch() {
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try (Connection conn = JdbcThinStreamingAbstractSelfTest.this.createOrdinaryConnection();
                     Statement s = conn.createStatement();){
                    s.addBatch(String.format("insert into Person(\"id\", \"name\")values (%d, '%s')", 1, JdbcThinStreamingAbstractSelfTest.this.nameForId(1)));
                    s.addBatch("SET STREAMING 1 FLUSH_FREQUENCY 10000");
                }
                return null;
            }
        }, SQLException.class, (String)"Streaming control commands must be executed explicitly");
    }

    @Test
    public void testBatchingSetStreamingStatement() {
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try (Connection conn = JdbcThinStreamingAbstractSelfTest.this.createOrdinaryConnection();
                     PreparedStatement s = conn.prepareStatement("SET STREAMING 1 FLUSH_FREQUENCY 10000");){
                    s.addBatch();
                }
                return null;
            }
        }, SQLException.class, (String)"Streaming control commands must be executed explicitly");
    }

    protected void assertCacheEmpty() {
        JdbcThinStreamingAbstractSelfTest.assertEquals((int)0, (int)this.cache().size(new CachePeekMode[]{CachePeekMode.ALL}));
    }

    protected static void execute(Connection conn, String sql) throws SQLException {
        try (Statement s = conn.createStatement();){
            s.execute(sql);
        }
    }

    private SqlClientContext sqlClientContext() {
        JdbcThinStreamingAbstractSelfTest.assertNotNull((Object)IndexingWithContext.cliCtx);
        return IndexingWithContext.cliCtx;
    }

    protected void assertStreamingState(boolean on) throws Exception {
        SqlClientContext cliCtx = this.sqlClientContext();
        GridTestUtils.waitForCondition(() -> cliCtx.isStream() == on, (long)1000L);
        JdbcThinStreamingAbstractSelfTest.assertEquals((boolean)on, (boolean)cliCtx.isStream());
    }

    @Override
    protected void assertStatementForbidden(String sql) {
        this.batchSize = 1;
        super.assertStatementForbidden(sql);
    }

    static class Foo {
        int val;

        public Foo(int val) {
            this.val = val;
        }
    }

    static final class IndexingWithContext
    extends IgniteH2Indexing {
        static SqlClientContext cliCtx;

        IndexingWithContext() {
        }

        public List<Long> streamBatchedUpdateQuery(String schemaName, String qry, List<Object[]> params, SqlClientContext cliCtx, String qryInitiatorId) throws IgniteCheckedException {
            IndexingWithContext.cliCtx = cliCtx;
            return super.streamBatchedUpdateQuery(schemaName, qry, params, cliCtx, qryInitiatorId);
        }

        public List<FieldsQueryCursor<List<?>>> querySqlFields(String schemaName, SqlFieldsQuery qry, @Nullable SqlClientContext cliCtx, boolean keepBinary, boolean failOnMultipleStmts, GridQueryCancel cancel) {
            IndexingWithContext.cliCtx = cliCtx;
            return super.querySqlFields(schemaName, qry, cliCtx, keepBinary, failOnMultipleStmts, cancel);
        }
    }
}

