/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.annotations.QuerySqlFunction;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.odbc.ClientListenerProcessor;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractDmlStatementSelfTest;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JdbcThinStatementCancelSelfTest
extends JdbcThinAbstractSelfTest {
    private static final TcpDiscoveryIpFinder IP_FINDER = new TcpDiscoveryVmIpFinder(true);
    private static final String URL = "jdbc:ignite:thin://127.0.0.1/";
    private static final String BULKLOAD_20_000_LINE_CSV_FILE = Objects.requireNonNull(IgniteUtils.resolveIgnitePath((String)"/modules/clients/src/test/resources/bulkload20_000.csv")).getAbsolutePath();
    private static final int MAX_ROWS = 10000;
    private static final int SERVER_THREAD_POOL_SIZE = 4;
    public static final int TIMEOUT = 5000;
    private static final byte NODES_COUNT = 3;
    public static final int CHECK_RESULT_TIMEOUT = 1000;
    private Connection conn;
    private Statement stmt;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = JdbcThinStatementCancelSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setSqlFunctionClasses(new Class[]{TestSQLFunctions.class});
        cache.setIndexedTypes(new Class[]{Integer.class, Integer.class, Long.class, Long.class, String.class, JdbcThinAbstractDmlStatementSelfTest.Person.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        disco.setIpFinder(IP_FINDER);
        cfg.setDiscoverySpi((DiscoverySpi)disco);
        cfg.setClientConnectorConfiguration(new ClientConnectorConfiguration().setThreadPoolSize(4));
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        int i;
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(3);
        for (i = 0; i < 10000; ++i) {
            this.grid(0).cache("default").put((Object)i, (Object)i);
        }
        for (i = 0; i < 10000; ++i) {
            this.grid(0).cache("default").put((Object)i, (Object)i);
        }
    }

    @Before
    public void before() throws Exception {
        TestSQLFunctions.init();
        this.conn = DriverManager.getConnection(URL);
        this.conn.setSchema("\"default\"");
        this.stmt = this.conn.createStatement();
        assert (this.stmt != null);
        assert (!this.stmt.isClosed());
    }

    @After
    public void after() throws Exception {
        if (this.stmt != null && !this.stmt.isClosed()) {
            this.stmt.close();
            assert (this.stmt.isClosed());
        }
        this.conn.close();
        assert (this.stmt.isClosed());
        assert (this.conn.isClosed());
    }

    @Test
    public void testCancelingStmtWithoutQuery() {
        try {
            this.stmt.cancel();
        }
        catch (Exception e) {
            log.error("Unexpected exception.", (Throwable)e);
            JdbcThinStatementCancelSelfTest.fail((String)"Unexpected exception");
        }
    }

    @Test
    public void testResultSetRetrievalInCanceledStatement() throws Exception {
        this.stmt.execute("SELECT 1; SELECT 2; SELECT 3;");
        JdbcThinStatementCancelSelfTest.assertNotNull((Object)this.stmt.getResultSet());
        this.stmt.cancel();
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.stmt.getResultSet();
            return null;
        }, SQLException.class, (String)"The query was cancelled while executing.");
    }

    @Test
    public void testCancelCanceledQuery() throws Exception {
        this.stmt.execute("SELECT 1;");
        JdbcThinStatementCancelSelfTest.assertNotNull((Object)this.stmt.getResultSet());
        this.stmt.cancel();
        this.stmt.cancel();
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.stmt.getResultSet();
            return null;
        }, SQLException.class, (String)"The query was cancelled while executing.");
    }

    @Test
    public void testCancelClosedStmt() throws Exception {
        this.stmt.close();
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.stmt.cancel();
            return null;
        }, SQLException.class, (String)"Statement is closed.");
    }

    @Test
    public void testResultSetNextAfterCanceling() throws Exception {
        this.stmt.setFetchSize(10);
        ResultSet rs = this.stmt.executeQuery("select * from Integer");
        assert (rs.next());
        this.stmt.cancel();
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            rs.next();
            return null;
        }, SQLException.class, (String)"The query was cancelled while executing.");
    }

    @Test
    public void testCancelAnotherStmt() throws Exception {
        this.stmt.setFetchSize(10);
        ResultSet rs = this.stmt.executeQuery("select * from Integer");
        assert (rs.next());
        this.stmt.cancel();
        ResultSet rs2 = this.stmt.executeQuery("select * from Integer order by _val");
        assert (rs2.next()) : "The other cursor mustn't be closed";
    }

    @Test
    public void testCancelAnotherStmtResultSet() throws Exception {
        try (Statement anotherStmt = this.conn.createStatement();){
            ResultSet rs1 = this.stmt.executeQuery("select * from Integer WHERE _key % 2 = 0");
            ResultSet rs2 = anotherStmt.executeQuery("select * from Integer  WHERE _key % 2 <> 0");
            this.stmt.cancel();
            GridTestUtils.assertThrows((IgniteLogger)log, () -> {
                rs1.next();
                return null;
            }, SQLException.class, (String)"The query was cancelled while executing.");
            assert (rs2.next()) : "The other cursor mustn't be closed";
        }
    }

    @Test
    public void testCancelQuery() throws Exception {
        IgniteInternalFuture cancelRes = this.cancel(this.stmt);
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.stmt.executeQuery("select * from Integer where _key in (select abs(_key) from Integer where awaitLatchCancelled() = 0) and shouldNotBeCalledInCaseOfCancellation()");
            return null;
        }, SQLException.class, (String)"The query was cancelled while executing.");
        cancelRes.get(1000L);
    }

    @Test
    public void testCloseCancelingQuery() throws Exception {
        IgniteInternalFuture res = GridTestUtils.runAsync(() -> {
            try {
                TestSQLFunctions.cancelLatch.await();
                long cancelCntrBeforeCancel = ClientListenerProcessor.CANCEL_COUNTER.get();
                this.stmt.cancel();
                try {
                    GridTestUtils.waitForCondition(() -> ClientListenerProcessor.CANCEL_COUNTER.get() == cancelCntrBeforeCancel + 1L, (long)5000L);
                }
                catch (IgniteInterruptedCheckedException igniteInterruptedCheckedException) {
                    // empty catch block
                }
                JdbcThinStatementCancelSelfTest.assertEquals((long)(cancelCntrBeforeCancel + 1L), (long)ClientListenerProcessor.CANCEL_COUNTER.get());
                this.stmt.close();
                TestSQLFunctions.reqLatch.countDown();
            }
            catch (Exception e) {
                log.error("Unexpected exception.", (Throwable)e);
                JdbcThinStatementCancelSelfTest.fail((String)"Unexpected exception");
            }
        });
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.stmt.executeQuery("select * from Integer where _key in (select abs(_key) from Integer where awaitLatchCancelled() = 0) and shouldNotBeCalledInCaseOfCancellation()");
            return null;
        }, SQLException.class, (String)"The query was cancelled while executing.");
        res.get(1000L);
    }

    @Test
    public void testCancelMultipleStatementsQuery() throws Exception {
        try (Statement anotherStatment = this.conn.createStatement();){
            anotherStatment.setFetchSize(1);
            ResultSet rs = anotherStatment.executeQuery("select * from Integer");
            assert (rs.next());
            IgniteInternalFuture cancelRes = this.cancel(this.stmt);
            GridTestUtils.assertThrows((IgniteLogger)log, () -> {
                this.stmt.execute("select 100 from Integer;select _key from Integer where awaitLatchCancelled() = 0;select 100 from Integer I1 join Integer I2;select * from Integer where shouldNotBeCalledInCaseOfCancellation()");
                return null;
            }, SQLException.class, (String)"The query was cancelled while executing");
            assert (rs.next()) : "The other cursor mustn't be closed";
            cancelRes.get(1000L);
        }
    }

    @Test
    public void testCancelBatchQuery() throws Exception {
        try (Statement stmt2 = this.conn.createStatement();){
            stmt2.setFetchSize(1);
            ResultSet rs = stmt2.executeQuery("SELECT * from Integer");
            assert (rs.next());
            IgniteInternalFuture cancelRes = this.cancel(this.stmt);
            GridTestUtils.assertThrows((IgniteLogger)log, () -> {
                this.stmt.addBatch("update Long set _val = _val + 1 where _key < sleep_func (30) OR _key < 10000");
                this.stmt.addBatch("update Long set _val = _val + 1 where awaitLatchCancelled() = 0");
                this.stmt.addBatch("update Long set _val = _val + 1 where _key < sleep_func (30) OR _key < 10000");
                this.stmt.addBatch("update Long set _val = _val + 1 where shouldNotBeCalledInCaseOfCancellation()");
                this.stmt.executeBatch();
                return null;
            }, SQLException.class, (String)"The query was cancelled while executing");
            assert (rs.next()) : "The other cursor mustn't be closed";
            cancelRes.get(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelAgainstFullServerThreadPool() throws Exception {
        List<Statement> statements = Collections.synchronizedList(new ArrayList());
        List<Connection> connections = Collections.synchronizedList(new ArrayList());
        for (int i = 0; i < 4; ++i) {
            Connection yaConn = DriverManager.getConnection(URL);
            yaConn.setSchema("\"default\"");
            connections.add(yaConn);
            Statement yaStmt = yaConn.createStatement();
            statements.add(yaStmt);
        }
        try {
            IgniteInternalFuture cancelRes = this.cancel((Statement)statements.get(3));
            IgniteInternalFuture<Long> fillPoolRes = this.fillServerThreadPool(statements, 3);
            GridTestUtils.assertThrows((IgniteLogger)log, () -> {
                ((Statement)statements.get(3)).executeQuery("select * from Integer where _key in (select abs(_key) from Integer where awaitLatchCancelled() = 0) and shouldNotBeCalledInCaseOfCancellation()");
                return null;
            }, SQLException.class, (String)"The query was cancelled while executing.");
            TestSQLFunctions.suspendQryLatch.countDown();
            cancelRes.get(1000L);
            fillPoolRes.get(1000L);
        }
        catch (Throwable throwable) {
            for (Statement statement : statements) {
                statement.close();
            }
            for (Connection connection : connections) {
                connection.close();
            }
            throw throwable;
        }
        for (Statement statement : statements) {
            statement.close();
        }
        for (Connection connection : connections) {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCancelFetchAgainstFullServerThreadPool() throws Exception {
        this.stmt.setFetchSize(1);
        ResultSet rs = this.stmt.executeQuery("SELECT * from Integer");
        rs.next();
        List<Statement> statements = Collections.synchronizedList(new ArrayList());
        List<Connection> connections = Collections.synchronizedList(new ArrayList());
        for (int i = 0; i < 4; ++i) {
            Connection yaConn = DriverManager.getConnection(URL);
            yaConn.setSchema("\"default\"");
            connections.add(yaConn);
            Statement yaStmt = yaConn.createStatement();
            statements.add(yaStmt);
        }
        try {
            IgniteInternalFuture<Long> fillPoolRes = this.fillServerThreadPool(statements, 3);
            IgniteInternalFuture fetchRes = GridTestUtils.runAsync(() -> GridTestUtils.assertThrows((IgniteLogger)log, () -> {
                rs.next();
                return null;
            }, SQLException.class, (String)"The query was cancelled while executing."));
            this.stmt.cancel();
            fetchRes.get(1000L);
            TestSQLFunctions.suspendQryLatch.countDown();
            fillPoolRes.get(1000L);
        }
        finally {
            for (Statement statement : statements) {
                statement.close();
            }
            for (Connection connection : connections) {
                connection.close();
            }
        }
    }

    @Test
    public void testCancellingLongRunningFileUpload() throws Exception {
        IgniteInternalFuture cancelRes = GridTestUtils.runAsync(() -> {
            try {
                Thread.sleep(200L);
                this.stmt.cancel();
            }
            catch (Exception e) {
                log.error("Unexpected exception.", (Throwable)e);
                JdbcThinStatementCancelSelfTest.fail((String)"Unexpected exception");
            }
        });
        GridTestUtils.assertThrows((IgniteLogger)log, () -> {
            this.stmt.executeUpdate("copy from '" + BULKLOAD_20_000_LINE_CSV_FILE + "' into Person (_key, age, firstName, lastName) format csv");
            return null;
        }, SQLException.class, (String)"The query was cancelled while executing.");
        cancelRes.get(1000L);
    }

    private IgniteInternalFuture cancel(Statement stmt) {
        return GridTestUtils.runAsync(() -> {
            try {
                TestSQLFunctions.cancelLatch.await();
                long cancelCntrBeforeCancel = ClientListenerProcessor.CANCEL_COUNTER.get();
                stmt.cancel();
                try {
                    GridTestUtils.waitForCondition(() -> ClientListenerProcessor.CANCEL_COUNTER.get() == cancelCntrBeforeCancel + 1L, (long)5000L);
                }
                catch (IgniteInterruptedCheckedException igniteInterruptedCheckedException) {
                    // empty catch block
                }
                JdbcThinStatementCancelSelfTest.assertEquals((long)(cancelCntrBeforeCancel + 1L), (long)ClientListenerProcessor.CANCEL_COUNTER.get());
                TestSQLFunctions.reqLatch.countDown();
            }
            catch (Exception e) {
                log.error("Unexpected exception.", (Throwable)e);
                JdbcThinStatementCancelSelfTest.fail((String)"Unexpected exception");
            }
        });
    }

    private IgniteInternalFuture<Long> fillServerThreadPool(List<Statement> statements, int qryCnt) {
        AtomicInteger idx = new AtomicInteger(0);
        return GridTestUtils.runMultiThreadedAsync(() -> {
            try {
                ((Statement)statements.get(idx.getAndIncrement())).executeQuery("select * from Integer where awaitQuerySuspensionLatch();");
            }
            catch (SQLException e) {
                log.error("Unexpected exception.", (Throwable)e);
                JdbcThinStatementCancelSelfTest.fail((String)"Unexpected exception");
            }
        }, (int)qryCnt, (String)"ThreadName");
    }

    public static class TestSQLFunctions {
        static CountDownLatch reqLatch;
        static CountDownLatch cancelLatch;
        static CountDownLatch suspendQryLatch;

        static void init() {
            reqLatch = new CountDownLatch(1);
            cancelLatch = new CountDownLatch(1);
            suspendQryLatch = new CountDownLatch(1);
        }

        @QuerySqlFunction
        public static long awaitLatchCancelled() {
            try {
                cancelLatch.countDown();
                reqLatch.await();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0L;
        }

        @QuerySqlFunction
        public static long awaitQuerySuspensionLatch() {
            try {
                suspendQryLatch.await();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return 0L;
        }

        @QuerySqlFunction
        public static long shouldNotBeCalledInCaseOfCancellation() {
            JdbcThinStatementCancelSelfTest.fail((String)"Query wasn't actually cancelled.");
            return 0L;
        }

        @QuerySqlFunction
        public static int sleep_func(int v) {
            try {
                Thread.sleep(v);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return v;
        }
    }
}

