/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.junit.Test;

public class JdbcThinLocalQueriesSelfTest
extends JdbcThinAbstractSelfTest {
    protected void beforeTest() throws Exception {
        super.beforeTest();
        this.startGrid(0);
        this.startGrid(1);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    @Test
    public void testLocalThinJdbcQuery() throws SQLException {
        try (Connection c = this.connect(this.grid(0), "replicatedOnly=true");){
            this.execute(c, "CREATE TABLE Company(id int primary key, name varchar) WITH \"template=replicated,cache_name=Company\"", new Object[0]);
            this.execute(c, "CREATE TABLE Person(id int primary key, name varchar, companyid int) WITH \"template=replicated,cache_name=Person\"", new Object[0]);
            this.execute(c, "insert into Company(id, name) values (1, 'Apple')", new Object[0]);
            this.execute(c, "insert into Person(id, name, companyid) values (2, 'John', 1)", new Object[0]);
            List<List<?>> res = this.execute(c, "SELECT p.id, p.name, c.name from Person p left join Company c on p.companyid = c.id", new Object[0]);
            JdbcThinLocalQueriesSelfTest.assertEqualsCollections((Collection)F.asList((Object[])new Serializable[]{Integer.valueOf(2), "John", "Apple"}), (Collection)res.get(0));
        }
    }
}

