/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class JdbcThinDistributedJoinsSelfTest
extends GridCommonAbstractTest {
    private static final String BASE_URL = "jdbc:ignite:thin://127.0.0.1/default?distributedJoins=true";

    protected void beforeTest() throws Exception {
        this.startGridsMultiThreaded(3);
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        super.afterTest();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = JdbcThinDistributedJoinsSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setSqlSchema("default");
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        return cfg;
    }

    @Test
    public void testNonCollocatedDistributedJoin() throws Exception {
        try (Statement stmt = DriverManager.getConnection(BASE_URL).createStatement();){
            stmt.executeUpdate("CREATE TABLE person (id LONG, name VARCHAR(64), age LONG, city_id DOUBLE, PRIMARY KEY (name)) WITH \"backups=1\";");
            stmt.executeUpdate("CREATE TABLE medical_info (id LONG, name VARCHAR(64), age LONG, blood_group VARCHAR(64), PRIMARY KEY (id)) WITH \"backups=1\";");
            stmt.executeUpdate("CREATE TABLE blood_group_info_PJ (id LONG, blood_group VARCHAR(64), universal_donor VARCHAR(64), PRIMARY KEY (id)) WITH \"backups=1\";");
            stmt.executeUpdate("CREATE TABLE blood_group_info_P (id LONG, blood_group VARCHAR(64), universal_donor VARCHAR(64), PRIMARY KEY (blood_group)) WITH \"backups=1\";");
            stmt.executeUpdate("CREATE INDEX medical_info_name_ASC_IDX ON medical_info (name);");
            stmt.executeUpdate("CREATE INDEX medical_info_blood_group_ASC_IDX ON medical_info (blood_group);");
            stmt.executeUpdate("CREATE INDEX blood_group_info_PJ_blood_group_ASC_IDX ON blood_group_info_PJ (blood_group);");
        }
        this.populateData();
        this.checkQueries();
    }

    private void checkQueries() throws SQLException {
        String res2;
        String res1;
        ResultSet resultSet;
        try (Statement stmt = DriverManager.getConnection(BASE_URL).createStatement();){
            resultSet = stmt.executeQuery("SELECT person.id, person.name, medical_info.blood_group, blood_group_info_PJ.universal_donor FROM person LEFT JOIN medical_info ON medical_info.name = person.name LEFT JOIN blood_group_info_PJ ON blood_group_info_PJ.blood_group = medical_info.blood_group;");
            res1 = this.queryResultAsString(resultSet);
            resultSet.close();
        }
        stmt = DriverManager.getConnection(BASE_URL).createStatement();
        var4_2 = null;
        try {
            resultSet = stmt.executeQuery("SELECT person.id, person.name, medical_info.blood_group, blood_group_info_P.universal_donor FROM person LEFT JOIN medical_info ON medical_info.name = person.name LEFT JOIN blood_group_info_P ON blood_group_info_P.blood_group = medical_info.blood_group;");
            res2 = this.queryResultAsString(resultSet);
            resultSet.close();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
        finally {
            if (stmt != null) {
                if (var4_2 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {
                        var4_2.addSuppressed(throwable);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        log.info("Query1 result: \n" + res1);
        log.info("Query2 result: \n" + res2);
        String expOut = "2001,Shravya,null,null\n2002,Kiran,O+,O+A+B+AB+\n2003,Harika,AB+,AB+\n2004,Srinivas,null,null\n2005,Madhavi,A+,A+AB+\n2006,Deeps,null,null\n2007,Hope,null,null\n";
        JdbcThinDistributedJoinsSelfTest.assertEquals((String)"Wrong result", (String)expOut, (String)res1);
        JdbcThinDistributedJoinsSelfTest.assertEquals((String)"Wrong result", (String)expOut, (String)res2);
    }

    private String queryResultAsString(ResultSet res) throws SQLException {
        ArrayList<String> results = new ArrayList<String>();
        while (res.next()) {
            String row = String.valueOf(res.getLong(1)) + ',' + res.getString(2) + ',' + res.getString(3) + ',' + res.getString(4);
            results.add(row);
        }
        results.sort(String::compareTo);
        StringBuilder sb = new StringBuilder();
        for (String result : results) {
            sb.append(result).append('\n');
        }
        return sb.toString();
    }

    private void populateData() throws SQLException {
        try (Statement stmt = DriverManager.getConnection(BASE_URL).createStatement();){
            stmt.executeUpdate(" INSERT INTO person (id,name,age,city_id) VALUES (2001,'Shravya',25,1.1), (2002,'Kiran',26,1.1), (2003,'Harika',26,2.4), (2004,'Srinivas',24,3.2), (2005,'Madhavi',23,3.2), (2006,'Deeps',28,1.2), (2007,'Hope',27,1.2);");
            stmt.executeUpdate("INSERT INTO medical_info (id,name,age,blood_group) VALUES (2001,'Madhavi',23,'A+'), (2002,'Diggi',27,'B+'), (2003,'Kiran',26,'O+'), (2004,'Harika',26,'AB+');");
            stmt.executeUpdate("INSERT INTO blood_group_info_PJ (id,blood_group,universal_donor) VALUES (2001,'A+','A+AB+'), (2002,'O+','O+A+B+AB+'), (2003,'B+','B+AB+'), (2004,'AB+','AB+'), (2005,'O-','EveryOne');");
            stmt.executeUpdate("INSERT INTO blood_group_info_P (id,blood_group,universal_donor) VALUES (2001,'A+','A+AB+'), (2002,'O+','O+A+B+AB+'), (2003,'B+','B+AB+'), (2004,'AB+','AB+'), (2005,'O-','EveryOne');");
        }
    }
}

