/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.ignite.IgniteJdbcThinDataSource;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.jdbc.thin.JdbcThinConnection;
import org.apache.ignite.internal.jdbc.thin.JdbcThinTcpIo;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class JdbcThinDataSourceSelfTest
extends JdbcThinAbstractSelfTest {
    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("default")});
        cfg.setMarshaller((Marshaller)new BinaryMarshaller());
        return cfg;
    }

    private CacheConfiguration cacheConfiguration(String name) throws Exception {
        CacheConfiguration cfg = JdbcThinDataSourceSelfTest.defaultCacheConfiguration();
        cfg.setName(name);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(2);
    }

    @Test
    public void testJndi() throws Exception {
        IgniteJdbcThinDataSource ids = new IgniteJdbcThinDataSource();
        ids.setUrl("jdbc:ignite:thin://127.0.0.1");
        InitialContext ic = this.getInitialContext();
        ic.bind("ds/test", (Object)ids);
        IgniteJdbcThinDataSource ds = (IgniteJdbcThinDataSource)ic.lookup("ds/test");
        JdbcThinDataSourceSelfTest.assertTrue((String)"Cannot looking up DataSource from JNDI", (ds != null ? 1 : 0) != 0);
        JdbcThinDataSourceSelfTest.assertEquals((String)ids.getUrl(), (String)ds.getUrl());
    }

    @Test
    public void testUrlCompose() throws Exception {
        IgniteJdbcThinDataSource ids = new IgniteJdbcThinDataSource();
        ids.setAddresses(new String[]{"127.0.0.1:10800"});
        JdbcThinDataSourceSelfTest.assertEquals((String)"jdbc:ignite:thin://127.0.0.1:10800/PUBLIC", (String)ids.getUrl());
        ids.setSchema("test");
        JdbcThinDataSourceSelfTest.assertEquals((String)"jdbc:ignite:thin://127.0.0.1:10800/test", (String)ids.getUrl());
        JdbcThinDataSourceSelfTest.assertEquals((String)"jdbc:ignite:thin://127.0.0.1:10800/test", (String)ids.getURL());
        ids.setAddresses(new String[]{"127.0.0.1:10800..10810", "myhost:10801..10802"});
        ids.setSchema("test2");
        JdbcThinDataSourceSelfTest.assertEquals((String)"jdbc:ignite:thin://127.0.0.1:10800..10810,myhost:10801..10802/test2", (String)ids.getURL());
    }

    @Test
    public void testResetUrl() throws Exception {
        IgniteJdbcThinDataSource ids = new IgniteJdbcThinDataSource();
        ids.setUrl("jdbc:ignite:thin://127.0.0.1:10800/test?lazy=" + !SqlFieldsQuery.DFLT_LAZY);
        JdbcThinDataSourceSelfTest.assertEquals((String)"test", (String)ids.getSchema());
        JdbcThinDataSourceSelfTest.assertEquals((!SqlFieldsQuery.DFLT_LAZY ? 1 : 0) != 0, (boolean)ids.isLazy());
        ids.setUrl("jdbc:ignite:thin://mydomain.org,localhost?collocated=true");
        JdbcThinDataSourceSelfTest.assertNull((Object)ids.getSchema());
        JdbcThinDataSourceSelfTest.assertEquals((boolean)SqlFieldsQuery.DFLT_LAZY, (boolean)ids.isLazy());
        JdbcThinDataSourceSelfTest.assertTrue((boolean)ids.isCollocated());
    }

    @Test
    public void testSqlHints() throws Exception {
        IgniteJdbcThinDataSource ids = new IgniteJdbcThinDataSource();
        ids.setUrl("jdbc:ignite:thin://127.0.0.1");
        try (Connection conn = ids.getConnection();){
            for (JdbcThinTcpIo io : JdbcThinDataSourceSelfTest.ios(conn)) {
                JdbcThinDataSourceSelfTest.assertFalse((boolean)io.connectionProperties().isAutoCloseServerCursor());
                JdbcThinDataSourceSelfTest.assertFalse((boolean)io.connectionProperties().isCollocated());
                JdbcThinDataSourceSelfTest.assertFalse((boolean)io.connectionProperties().isEnforceJoinOrder());
                JdbcThinDataSourceSelfTest.assertEquals((boolean)SqlFieldsQuery.DFLT_LAZY, (boolean)io.connectionProperties().isLazy());
                JdbcThinDataSourceSelfTest.assertFalse((boolean)io.connectionProperties().isDistributedJoins());
                JdbcThinDataSourceSelfTest.assertFalse((boolean)io.connectionProperties().isReplicatedOnly());
            }
        }
        ids.setAutoCloseServerCursor(true);
        ids.setCollocated(true);
        ids.setEnforceJoinOrder(true);
        ids.setLazy(!SqlFieldsQuery.DFLT_LAZY);
        ids.setDistributedJoins(true);
        ids.setReplicatedOnly(true);
        conn = ids.getConnection();
        var3_3 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinDataSourceSelfTest.ios(conn)) {
                JdbcThinDataSourceSelfTest.assertTrue((boolean)io.connectionProperties().isAutoCloseServerCursor());
                JdbcThinDataSourceSelfTest.assertTrue((boolean)io.connectionProperties().isCollocated());
                JdbcThinDataSourceSelfTest.assertTrue((boolean)io.connectionProperties().isEnforceJoinOrder());
                JdbcThinDataSourceSelfTest.assertEquals((!SqlFieldsQuery.DFLT_LAZY ? 1 : 0) != 0, (boolean)io.connectionProperties().isLazy());
                JdbcThinDataSourceSelfTest.assertTrue((boolean)io.connectionProperties().isDistributedJoins());
                JdbcThinDataSourceSelfTest.assertTrue((boolean)io.connectionProperties().isReplicatedOnly());
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var3_3 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testTcpNoDelay() throws Exception {
        IgniteJdbcThinDataSource ids = new IgniteJdbcThinDataSource();
        ids.setUrl("jdbc:ignite:thin://127.0.0.1");
        try (Connection conn = ids.getConnection();){
            for (JdbcThinTcpIo io : JdbcThinDataSourceSelfTest.ios(conn)) {
                JdbcThinDataSourceSelfTest.assertTrue((boolean)io.connectionProperties().isTcpNoDelay());
            }
        }
        ids.setTcpNoDelay(false);
        conn = ids.getConnection();
        var3_3 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinDataSourceSelfTest.ios(conn)) {
                JdbcThinDataSourceSelfTest.assertFalse((boolean)io.connectionProperties().isTcpNoDelay());
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var3_3 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testSocketBuffers() throws Exception {
        final IgniteJdbcThinDataSource ids = new IgniteJdbcThinDataSource();
        ids.setUrl("jdbc:ignite:thin://127.0.0.1");
        ids.setSocketReceiveBuffer(111);
        ids.setSocketSendBuffer(111);
        try (Connection conn = ids.getConnection();){
            for (JdbcThinTcpIo io : JdbcThinDataSourceSelfTest.ios(conn)) {
                JdbcThinDataSourceSelfTest.assertEquals((int)111, (int)io.connectionProperties().getSocketReceiveBuffer());
                JdbcThinDataSourceSelfTest.assertEquals((int)111, (int)io.connectionProperties().getSocketSendBuffer());
            }
        }
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ids.setSocketReceiveBuffer(-1);
                ids.getConnection();
                return null;
            }
        }, SQLException.class, (String)"Property cannot be lower than 0 [name=socketReceiveBuffer, value=-1]");
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ids.setSocketReceiveBuffer(1024);
                ids.setSocketSendBuffer(-1);
                ids.getConnection();
                return null;
            }
        }, SQLException.class, (String)"Property cannot be lower than 0 [name=socketSendBuffer, value=-1]");
    }

    private InitialContext getInitialContext() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", JndiContextMockFactory.class.getName());
        return new InitialContext(env);
    }

    private static Collection<JdbcThinTcpIo> ios(Connection conn) throws Exception {
        Collection<Object> ios;
        JdbcThinConnection conn0 = conn.unwrap(JdbcThinConnection.class);
        Collection<Object> collection = ios = partitionAwareness ? ((Map)GridTestUtils.getFieldValue((Object)conn0, JdbcThinConnection.class, (String)"ios")).values() : Collections.singleton(GridTestUtils.getFieldValue((Object)conn0, JdbcThinConnection.class, (String)"singleIo"));
        assert (!ios.isEmpty());
        return ios;
    }

    public static class JndiMockContext
    implements Context {
        private Map<String, Object> map = new HashMap<String, Object>();

        @Override
        public Object lookup(Name name) throws NamingException {
            return this.lookup(name.get(0));
        }

        @Override
        public Object lookup(String name) throws NamingException {
            return this.map.get(name);
        }

        @Override
        public void bind(Name name, Object obj) throws NamingException {
            this.rebind(name.get(0), obj);
        }

        @Override
        public void bind(String name, Object obj) throws NamingException {
            this.rebind(name, obj);
        }

        @Override
        public void rebind(Name name, Object obj) throws NamingException {
            this.rebind(name.get(0), obj);
        }

        @Override
        public void rebind(String name, Object obj) throws NamingException {
            this.map.put(name, obj);
        }

        @Override
        public void unbind(Name name) throws NamingException {
            this.unbind(name.get(0));
        }

        @Override
        public void unbind(String name) throws NamingException {
            this.map.remove(name);
        }

        @Override
        public void rename(Name oldName, Name newName) throws NamingException {
            this.rename(oldName.get(0), newName.get(0));
        }

        @Override
        public void rename(String oldName, String newName) throws NamingException {
            this.map.put(newName, this.map.remove(oldName));
        }

        @Override
        public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
            return null;
        }

        @Override
        public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
            return null;
        }

        @Override
        public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
            return null;
        }

        @Override
        public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
            return null;
        }

        @Override
        public void destroySubcontext(Name name) throws NamingException {
        }

        @Override
        public void destroySubcontext(String name) throws NamingException {
        }

        @Override
        public Context createSubcontext(Name name) throws NamingException {
            return null;
        }

        @Override
        public Context createSubcontext(String name) throws NamingException {
            return null;
        }

        @Override
        public Object lookupLink(Name name) throws NamingException {
            return null;
        }

        @Override
        public Object lookupLink(String name) throws NamingException {
            return null;
        }

        @Override
        public NameParser getNameParser(Name name) throws NamingException {
            return null;
        }

        @Override
        public NameParser getNameParser(String name) throws NamingException {
            return null;
        }

        @Override
        public Name composeName(Name name, Name prefix) throws NamingException {
            return null;
        }

        @Override
        public String composeName(String name, String prefix) throws NamingException {
            return null;
        }

        @Override
        public Object addToEnvironment(String propName, Object propVal) throws NamingException {
            return null;
        }

        @Override
        public Object removeFromEnvironment(String propName) throws NamingException {
            return null;
        }

        @Override
        public Hashtable<?, ?> getEnvironment() throws NamingException {
            return null;
        }

        @Override
        public void close() throws NamingException {
        }

        @Override
        public String getNameInNamespace() throws NamingException {
            return null;
        }
    }

    public static class JndiContextMockFactory
    implements InitialContextFactory {
        @Override
        public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
            return new JndiMockContext();
        }
    }
}

