/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.net.InetSocketAddress;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinaryContext;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.binary.BinaryMetadataHandler;
import org.apache.ignite.internal.binary.BinaryNoopMetadataHandler;
import org.apache.ignite.internal.jdbc.thin.ConnectionProperties;
import org.apache.ignite.internal.jdbc.thin.ConnectionPropertiesImpl;
import org.apache.ignite.internal.jdbc.thin.JdbcThinConnection;
import org.apache.ignite.internal.jdbc.thin.JdbcThinTcpIo;
import org.apache.ignite.internal.util.HostAndPortRange;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.logger.NullLogger;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.marshaller.MarshallerContext;
import org.apache.ignite.marshaller.jdk.JdkMarshaller;
import org.apache.ignite.testframework.GridStringLogger;
import org.apache.ignite.testframework.GridTestUtils;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

public class JdbcThinConnectionSelfTest
extends JdbcThinAbstractSelfTest {
    private static final String CLI_KEY_STORE_PATH = U.getIgniteHome() + "/modules/clients/src/test/keystore/client.jks";
    private static final String SRV_KEY_STORE_PATH = U.getIgniteHome() + "/modules/clients/src/test/keystore/server.jks";
    private static final String LOCALHOST = "127.0.0.1";
    private String url = partitionAwareness ? "jdbc:ignite:thin://127.0.0.1:10800..10802" : "jdbc:ignite:thin://127.0.0.1";
    private String urlWithPartitionAwarenessProp = this.url + "?partitionAwareness=" + partitionAwareness;
    private String urlWithPartitionAwarenessPropSemicolon = this.url + ";partitionAwareness=" + partitionAwareness;
    private int nodesCnt = partitionAwareness ? 4 : 2;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("default")});
        cfg.setMarshaller((Marshaller)new BinaryMarshaller());
        cfg.setGridLogger((IgniteLogger)new GridStringLogger());
        return cfg;
    }

    private CacheConfiguration cacheConfiguration(@NotNull String name) throws Exception {
        CacheConfiguration cfg = JdbcThinConnectionSelfTest.defaultCacheConfiguration();
        cfg.setName(name);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(this.nodesCnt);
    }

    @Test
    public void testDefaults() throws Exception {
        Connection conn = DriverManager.getConnection(this.url);
        Throwable throwable = null;
        if (conn != null) {
            if (throwable != null) {
                try {
                    conn.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                conn.close();
            }
        }
        conn = DriverManager.getConnection(this.url + "/");
        throwable = null;
        if (conn != null) {
            if (throwable != null) {
                try {
                    conn.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
            } else {
                conn.close();
            }
        }
    }

    @Test
    public void testInvalidEndpoint() {
        this.assertInvalid("jdbc:ignite:thin://", "Address is empty");
        this.assertInvalid("jdbc:ignite:thin://:10000", "Host name is empty");
        this.assertInvalid("jdbc:ignite:thin://     :10000", "Host name is empty");
        this.assertInvalid("jdbc:ignite:thin://127.0.0.1:-1", "port range contains invalid port -1");
        this.assertInvalid("jdbc:ignite:thin://127.0.0.1:0", "port range contains invalid port 0");
        this.assertInvalid("jdbc:ignite:thin://127.0.0.1:100000", "port range contains invalid port 100000");
    }

    @Test
    public void testSocketBuffers() throws Exception {
        int dfltDufSize = 65536;
        this.assertInvalid(this.urlWithPartitionAwarenessProp + "&socketSendBuffer=-1", "Property cannot be lower than 0 [name=socketSendBuffer, value=-1]");
        this.assertInvalid(this.urlWithPartitionAwarenessProp + "&socketReceiveBuffer=-1", "Property cannot be lower than 0 [name=socketReceiveBuffer, value=-1]");
        try (Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertEquals((int)65536, (int)io.connectionProperties().getSocketSendBuffer());
                JdbcThinConnectionSelfTest.assertEquals((int)65536, (int)io.connectionProperties().getSocketReceiveBuffer());
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp + "&socketSendBuffer=1024");
        var3_3 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertEquals((int)1024, (int)io.connectionProperties().getSocketSendBuffer());
                JdbcThinConnectionSelfTest.assertEquals((int)65536, (int)io.connectionProperties().getSocketReceiveBuffer());
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var3_3 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp + "&socketReceiveBuffer=1024");
        var3_3 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertEquals((int)65536, (int)io.connectionProperties().getSocketSendBuffer());
                JdbcThinConnectionSelfTest.assertEquals((int)1024, (int)io.connectionProperties().getSocketReceiveBuffer());
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var3_3 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp + "&socketSendBuffer=1024&socketReceiveBuffer=2048");
        var3_3 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertEquals((int)1024, (int)io.connectionProperties().getSocketSendBuffer());
                JdbcThinConnectionSelfTest.assertEquals((int)2048, (int)io.connectionProperties().getSocketReceiveBuffer());
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var3_3 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testSocketBuffersSemicolon() throws Exception {
        int dfltDufSize = 65536;
        this.assertInvalid(this.urlWithPartitionAwarenessPropSemicolon + ";socketSendBuffer=-1", "Property cannot be lower than 0 [name=socketSendBuffer, value=-1]");
        this.assertInvalid(this.urlWithPartitionAwarenessPropSemicolon + ";socketReceiveBuffer=-1", "Property cannot be lower than 0 [name=socketReceiveBuffer, value=-1]");
        try (Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon + ";socketSendBuffer=1024");){
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertEquals((int)1024, (int)io.connectionProperties().getSocketSendBuffer());
                JdbcThinConnectionSelfTest.assertEquals((int)65536, (int)io.connectionProperties().getSocketReceiveBuffer());
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon + ";socketReceiveBuffer=1024");
        var3_3 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertEquals((int)65536, (int)io.connectionProperties().getSocketSendBuffer());
                JdbcThinConnectionSelfTest.assertEquals((int)1024, (int)io.connectionProperties().getSocketReceiveBuffer());
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var3_3 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon + ";socketSendBuffer=1024;socketReceiveBuffer=2048");
        var3_3 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertEquals((int)1024, (int)io.connectionProperties().getSocketSendBuffer());
                JdbcThinConnectionSelfTest.assertEquals((int)2048, (int)io.connectionProperties().getSocketReceiveBuffer());
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var3_3 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testUpdateBatchSize() throws Exception {
        this.assertInvalid(this.urlWithPartitionAwarenessPropSemicolon + ";updateBatchSize=-1", "Property cannot be lower than 1 [name=updateBatchSize, value=-1]");
        try (Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon);){
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertNull((Object)io.connectionProperties().getUpdateBatchSize());
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon + ";updateBatchSize=1024");
        var2_2 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertEquals((int)1024, (int)io.connectionProperties().getUpdateBatchSize());
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp + "&updateBatchSize=1024");
        var2_2 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertEquals((int)1024, (int)io.connectionProperties().getUpdateBatchSize());
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testPartitionAwarenessSqlCacheSizeProperty() throws Exception {
        this.assertInvalid(this.urlWithPartitionAwarenessProp + "&partitionAwarenessSQLCacheSize=0", "Property cannot be lower than 1 [name=partitionAwarenessSQLCacheSize, value=0]");
        try (Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertEquals((int)1000, (int)io.connectionProperties().getPartitionAwarenessSqlCacheSize());
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp + "&partitionAwarenessSQLCacheSize=100");
        var2_2 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertEquals((int)100, (int)io.connectionProperties().getPartitionAwarenessSqlCacheSize());
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testPartitionAwarenessSqlCacheSizePropertySemicolon() throws Exception {
        this.assertInvalid(this.urlWithPartitionAwarenessPropSemicolon + ";partitionAwarenessSQLCacheSize=0", "Property cannot be lower than 1 [name=partitionAwarenessSQLCacheSize, value=0]");
        try (Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon);){
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertEquals((int)1000, (int)io.connectionProperties().getPartitionAwarenessSqlCacheSize());
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon + ";partitionAwarenessSQLCacheSize=100");
        var2_2 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertEquals((int)100, (int)io.connectionProperties().getPartitionAwarenessSqlCacheSize());
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testPartitionAwarenessPartitionDistributionsCacheSizeProperty() throws Exception {
        this.assertInvalid(this.urlWithPartitionAwarenessProp + "&partitionAwarenessPartitionDistributionsCacheSize=0", "Property cannot be lower than 1 [name=partitionAwarenessPartitionDistributionsCacheSize, value=0]");
        try (Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertEquals((int)1000, (int)io.connectionProperties().getPartitionAwarenessPartitionDistributionsCacheSize());
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp + "&partitionAwarenessPartitionDistributionsCacheSize=100");
        var2_2 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertEquals((int)100, (int)io.connectionProperties().getPartitionAwarenessPartitionDistributionsCacheSize());
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testPartitionAwarenessPartitionDistributionsCacheSizePropertySemicolon() throws Exception {
        this.assertInvalid(this.urlWithPartitionAwarenessPropSemicolon + ";partitionAwarenessPartitionDistributionsCacheSize=0", "Property cannot be lower than 1 [name=partitionAwarenessPartitionDistributionsCacheSize, value=0]");
        try (Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon);){
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertEquals((int)1000, (int)io.connectionProperties().getPartitionAwarenessPartitionDistributionsCacheSize());
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon + ";partitionAwarenessPartitionDistributionsCacheSize=100");
        var2_2 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertEquals((int)100, (int)io.connectionProperties().getPartitionAwarenessPartitionDistributionsCacheSize());
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testSqlHints() throws Exception {
        try (Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            this.assertHints(conn, false, false, false, false, SqlFieldsQuery.DFLT_LAZY, false, partitionAwareness);
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp + "&distributedJoins=true");
        var2_2 = null;
        try {
            this.assertHints(conn, true, false, false, false, SqlFieldsQuery.DFLT_LAZY, false, partitionAwareness);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp + "&enforceJoinOrder=true");
        var2_2 = null;
        try {
            this.assertHints(conn, false, true, false, false, SqlFieldsQuery.DFLT_LAZY, false, partitionAwareness);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp + "&collocated=true");
        var2_2 = null;
        try {
            this.assertHints(conn, false, false, true, false, SqlFieldsQuery.DFLT_LAZY, false, partitionAwareness);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp + "&replicatedOnly=true");
        var2_2 = null;
        try {
            this.assertHints(conn, false, false, false, true, SqlFieldsQuery.DFLT_LAZY, false, partitionAwareness);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp + "&lazy=" + !SqlFieldsQuery.DFLT_LAZY);
        var2_2 = null;
        try {
            this.assertHints(conn, false, false, false, false, !SqlFieldsQuery.DFLT_LAZY, false, partitionAwareness);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp + "&skipReducerOnUpdate=true");
        var2_2 = null;
        try {
            this.assertHints(conn, false, false, false, false, SqlFieldsQuery.DFLT_LAZY, true, partitionAwareness);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp + "&distributedJoins=true&enforceJoinOrder=true&collocated=true&replicatedOnly=true&lazy=" + !SqlFieldsQuery.DFLT_LAZY + "&skipReducerOnUpdate=true");
        var2_2 = null;
        try {
            this.assertHints(conn, true, true, true, true, !SqlFieldsQuery.DFLT_LAZY, true, partitionAwareness);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testSqlHintsSemicolon() throws Exception {
        try (Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon + ";distributedJoins=true");){
            this.assertHints(conn, true, false, false, false, SqlFieldsQuery.DFLT_LAZY, false, partitionAwareness);
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon + ";enforceJoinOrder=true");
        var2_2 = null;
        try {
            this.assertHints(conn, false, true, false, false, SqlFieldsQuery.DFLT_LAZY, false, partitionAwareness);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon + ";collocated=true");
        var2_2 = null;
        try {
            this.assertHints(conn, false, false, true, false, SqlFieldsQuery.DFLT_LAZY, false, partitionAwareness);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon + ";replicatedOnly=true");
        var2_2 = null;
        try {
            this.assertHints(conn, false, false, false, true, SqlFieldsQuery.DFLT_LAZY, false, partitionAwareness);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon + ";lazy=" + !SqlFieldsQuery.DFLT_LAZY);
        var2_2 = null;
        try {
            this.assertHints(conn, false, false, false, false, !SqlFieldsQuery.DFLT_LAZY, false, partitionAwareness);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon + ";skipReducerOnUpdate=true");
        var2_2 = null;
        try {
            this.assertHints(conn, false, false, false, false, SqlFieldsQuery.DFLT_LAZY, true, partitionAwareness);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon + ";distributedJoins=true;enforceJoinOrder=true;collocated=true;replicatedOnly=true;lazy=" + !SqlFieldsQuery.DFLT_LAZY + ";skipReducerOnUpdate=true");
        var2_2 = null;
        try {
            this.assertHints(conn, true, true, true, true, !SqlFieldsQuery.DFLT_LAZY, true, partitionAwareness);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    private void assertHints(Connection conn, boolean distributedJoins, boolean enforceJoinOrder, boolean collocated, boolean replicatedOnly, boolean lazy, boolean skipReducerOnUpdate, boolean partitionAwarenessEnabled) throws Exception {
        for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
            JdbcThinConnectionSelfTest.assertEquals((boolean)distributedJoins, (boolean)io.connectionProperties().isDistributedJoins());
            JdbcThinConnectionSelfTest.assertEquals((boolean)enforceJoinOrder, (boolean)io.connectionProperties().isEnforceJoinOrder());
            JdbcThinConnectionSelfTest.assertEquals((boolean)collocated, (boolean)io.connectionProperties().isCollocated());
            JdbcThinConnectionSelfTest.assertEquals((boolean)replicatedOnly, (boolean)io.connectionProperties().isReplicatedOnly());
            JdbcThinConnectionSelfTest.assertEquals((boolean)lazy, (boolean)io.connectionProperties().isLazy());
            JdbcThinConnectionSelfTest.assertEquals((boolean)skipReducerOnUpdate, (boolean)io.connectionProperties().isSkipReducerOnUpdate());
            JdbcThinConnectionSelfTest.assertEquals((boolean)partitionAwarenessEnabled, (boolean)io.connectionProperties().isPartitionAwareness());
        }
    }

    @Test
    public void testTcpNoDelay() throws Exception {
        this.assertInvalid(this.urlWithPartitionAwarenessProp + "&tcpNoDelay=0", "Invalid property value. [name=tcpNoDelay, val=0, choices=[true, false]]");
        this.assertInvalid(this.urlWithPartitionAwarenessProp + "&tcpNoDelay=1", "Invalid property value. [name=tcpNoDelay, val=1, choices=[true, false]]");
        this.assertInvalid(this.urlWithPartitionAwarenessProp + "&tcpNoDelay=false1", "Invalid property value. [name=tcpNoDelay, val=false1, choices=[true, false]]");
        this.assertInvalid(this.urlWithPartitionAwarenessProp + "&tcpNoDelay=true1", "Invalid property value. [name=tcpNoDelay, val=true1, choices=[true, false]]");
        try (Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertTrue((boolean)io.connectionProperties().isTcpNoDelay());
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp + "&tcpNoDelay=true");
        var2_2 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertTrue((boolean)io.connectionProperties().isTcpNoDelay());
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp + "&tcpNoDelay=True");
        var2_2 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertTrue((boolean)io.connectionProperties().isTcpNoDelay());
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp + "&tcpNoDelay=false");
        var2_2 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertFalse((boolean)io.connectionProperties().isTcpNoDelay());
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp + "&tcpNoDelay=False");
        var2_2 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertFalse((boolean)io.connectionProperties().isTcpNoDelay());
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testTcpNoDelaySemicolon() throws Exception {
        this.assertInvalid(this.urlWithPartitionAwarenessPropSemicolon + ";tcpNoDelay=0", "Invalid property value. [name=tcpNoDelay, val=0, choices=[true, false]]");
        this.assertInvalid(this.urlWithPartitionAwarenessPropSemicolon + ";tcpNoDelay=1", "Invalid property value. [name=tcpNoDelay, val=1, choices=[true, false]]");
        this.assertInvalid(this.urlWithPartitionAwarenessPropSemicolon + ";tcpNoDelay=false1", "Invalid property value. [name=tcpNoDelay, val=false1, choices=[true, false]]");
        this.assertInvalid(this.urlWithPartitionAwarenessPropSemicolon + ";tcpNoDelay=true1", "Invalid property value. [name=tcpNoDelay, val=true1, choices=[true, false]]");
        try (Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon + ";tcpNoDelay=true");){
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertTrue((boolean)io.connectionProperties().isTcpNoDelay());
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon + ";tcpNoDelay=True");
        var2_2 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertTrue((boolean)io.connectionProperties().isTcpNoDelay());
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon + ";tcpNoDelay=false");
        var2_2 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertFalse((boolean)io.connectionProperties().isTcpNoDelay());
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon + ";tcpNoDelay=False");
        var2_2 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertFalse((boolean)io.connectionProperties().isTcpNoDelay());
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testAutoCloseServerCursorProperty() throws Exception {
        String url = this.urlWithPartitionAwarenessProp + "&autoCloseServerCursor";
        String err = "Invalid property value. [name=autoCloseServerCursor";
        this.assertInvalid(url + "=0", err);
        this.assertInvalid(url + "=1", err);
        this.assertInvalid(url + "=false1", err);
        this.assertInvalid(url + "=true1", err);
        try (Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertFalse((boolean)io.connectionProperties().isAutoCloseServerCursor());
            }
        }
        conn = DriverManager.getConnection(url + "=true");
        var4_4 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertTrue((boolean)io.connectionProperties().isAutoCloseServerCursor());
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var4_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(url + "=True");
        var4_4 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertTrue((boolean)io.connectionProperties().isAutoCloseServerCursor());
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var4_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(url + "=false");
        var4_4 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertFalse((boolean)io.connectionProperties().isAutoCloseServerCursor());
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var4_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(url + "=False");
        var4_4 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertFalse((boolean)io.connectionProperties().isAutoCloseServerCursor());
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var4_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testAutoCloseServerCursorPropertySemicolon() throws Exception {
        String url = this.urlWithPartitionAwarenessPropSemicolon + ";autoCloseServerCursor";
        String err = "Invalid property value. [name=autoCloseServerCursor";
        this.assertInvalid(url + "=0", err);
        this.assertInvalid(url + "=1", err);
        this.assertInvalid(url + "=false1", err);
        this.assertInvalid(url + "=true1", err);
        try (Connection conn = DriverManager.getConnection(url + "=true");){
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertTrue((boolean)io.connectionProperties().isAutoCloseServerCursor());
            }
        }
        conn = DriverManager.getConnection(url + "=True");
        var4_4 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertTrue((boolean)io.connectionProperties().isAutoCloseServerCursor());
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var4_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(url + "=false");
        var4_4 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertFalse((boolean)io.connectionProperties().isAutoCloseServerCursor());
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var4_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(url + "=False");
        var4_4 = null;
        try {
            for (JdbcThinTcpIo io : JdbcThinConnectionSelfTest.ios(conn)) {
                JdbcThinConnectionSelfTest.assertFalse((boolean)io.connectionProperties().isAutoCloseServerCursor());
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var4_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testSchema() throws Exception {
        this.assertInvalid(this.url + "/qwe/qwe", "Invalid URL format (only schema name is allowed in URL path parameter 'host:port[/schemaName]')");
        try (Connection conn = DriverManager.getConnection(this.url + "/public");){
            JdbcThinConnectionSelfTest.assertEquals((String)"Invalid schema", (String)"PUBLIC", (String)conn.getSchema());
        }
        conn = DriverManager.getConnection(this.url + "/\"" + "default" + '\"');
        var2_2 = null;
        try {
            JdbcThinConnectionSelfTest.assertEquals((String)"Invalid schema", (String)"default", (String)conn.getSchema());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.url + "/_not_exist_schema_");
        var2_2 = null;
        try {
            JdbcThinConnectionSelfTest.assertEquals((String)"Invalid schema", (String)"_NOT_EXIST_SCHEMA_", (String)conn.getSchema());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testSchemaSemicolon() throws Exception {
        try (Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon + ";schema=public");){
            JdbcThinConnectionSelfTest.assertEquals((String)"Invalid schema", (String)"PUBLIC", (String)conn.getSchema());
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon + ";schema=\"" + "default" + '\"');
        var2_2 = null;
        try {
            JdbcThinConnectionSelfTest.assertEquals((String)"Invalid schema", (String)"default", (String)conn.getSchema());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(this.urlWithPartitionAwarenessPropSemicolon + ";schema=_not_exist_schema_");
        var2_2 = null;
        try {
            JdbcThinConnectionSelfTest.assertEquals((String)"Invalid schema", (String)"_NOT_EXIST_SCHEMA_", (String)conn.getSchema());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var2_2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    private static Collection<JdbcThinTcpIo> ios(Connection conn) throws Exception {
        Collection<Object> ios;
        JdbcThinConnection conn0 = conn.unwrap(JdbcThinConnection.class);
        Collection<Object> collection = ios = partitionAwareness ? ((Map)GridTestUtils.getFieldValue((Object)conn0, JdbcThinConnection.class, (String)"ios")).values() : Collections.singleton(GridTestUtils.getFieldValue((Object)conn0, JdbcThinConnection.class, (String)"singleIo"));
        assert (!ios.isEmpty());
        return ios;
    }

    private void assertInvalid(final String url, String errMsg) {
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DriverManager.getConnection(url);
                return null;
            }
        }, SQLException.class, (String)errMsg);
    }

    @Test
    public void testClose() throws Exception {
        Connection conn;
        try (Connection conn0 = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            conn = conn0;
            assert (conn != null);
            assert (!conn.isClosed());
        }
        assert (conn.isClosed());
        assert (!conn.isValid(2)) : "Connection must be closed";
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                conn.isValid(-2);
                return null;
            }
        }, SQLException.class, (String)"Invalid timeout");
    }

    @Test
    public void testCreateStatement() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);
             Statement stmt = conn.createStatement();){
            JdbcThinConnectionSelfTest.assertNotNull((Object)stmt);
            stmt.close();
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.createStatement();
                }
            });
        }
    }

    @Test
    public void testCreateStatement2() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            int[] rsTypes = new int[]{1003, 1004, 1005};
            int[] rsConcurs = new int[]{1007, 1008};
            DatabaseMetaData meta = conn.getMetaData();
            for (final int type : rsTypes) {
                for (final int concur : rsConcurs) {
                    if (meta.supportsResultSetConcurrency(type, concur)) {
                        assert (type == 1003);
                        assert (concur == 1007);
                        try (Statement stmt = conn.createStatement(type, concur);){
                            JdbcThinConnectionSelfTest.assertNotNull((Object)stmt);
                            JdbcThinConnectionSelfTest.assertEquals((int)type, (int)stmt.getResultSetType());
                            JdbcThinConnectionSelfTest.assertEquals((int)concur, (int)stmt.getResultSetConcurrency());
                            continue;
                        }
                    }
                    GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            return conn.createStatement(type, concur);
                        }
                    }, SQLFeatureNotSupportedException.class, null);
                }
            }
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.createStatement(1003, 1007);
                }
            });
        }
    }

    @Test
    public void testCreateStatement3() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            int[] rsTypes = new int[]{1003, 1004, 1005};
            int[] rsConcurs = new int[]{1007, 1008};
            int[] rsHoldabilities = new int[]{1, 2};
            DatabaseMetaData meta = conn.getMetaData();
            for (final int type : rsTypes) {
                for (final int concur : rsConcurs) {
                    for (final int holdabililty : rsHoldabilities) {
                        if (meta.supportsResultSetConcurrency(type, concur)) {
                            assert (type == 1003);
                            assert (concur == 1007);
                            try (Statement stmt = conn.createStatement(type, concur, holdabililty);){
                                JdbcThinConnectionSelfTest.assertNotNull((Object)stmt);
                                JdbcThinConnectionSelfTest.assertEquals((int)type, (int)stmt.getResultSetType());
                                JdbcThinConnectionSelfTest.assertEquals((int)concur, (int)stmt.getResultSetConcurrency());
                                JdbcThinConnectionSelfTest.assertEquals((int)holdabililty, (int)stmt.getResultSetHoldability());
                                continue;
                            }
                        }
                        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                return conn.createStatement(type, concur, holdabililty);
                            }
                        }, SQLFeatureNotSupportedException.class, null);
                    }
                }
            }
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.createStatement(1003, 1007, 1);
                }
            });
        }
    }

    @Test
    public void testPrepareStatement() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.prepareStatement(null);
                }
            }, SQLException.class, (String)"SQL string cannot be null");
            String sqlText = "select * from test where param = ?";
            try (PreparedStatement prepared = conn.prepareStatement("select * from test where param = ?");){
                JdbcThinConnectionSelfTest.assertNotNull((Object)prepared);
            }
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.prepareStatement("select * from test where param = ?");
                }
            });
        }
    }

    @Test
    public void testPrepareStatement3() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            String sqlText = "select * from test where param = ?";
            int[] rsTypes = new int[]{1003, 1004, 1005};
            int[] rsConcurs = new int[]{1007, 1008};
            DatabaseMetaData meta = conn.getMetaData();
            for (final int type : rsTypes) {
                for (final int concur : rsConcurs) {
                    if (meta.supportsResultSetConcurrency(type, concur)) {
                        assert (type == 1003);
                        assert (concur == 1007);
                        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                return conn.prepareStatement(null, type, concur);
                            }
                        }, SQLException.class, (String)"SQL string cannot be null");
                        continue;
                    }
                    GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            return conn.prepareStatement("select * from test where param = ?", type, concur);
                        }
                    }, SQLFeatureNotSupportedException.class, null);
                }
            }
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.prepareStatement("select * from test where param = ?", 1003, 1007);
                }
            });
            conn.close();
        }
    }

    @Test
    public void testPrepareStatement4() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            String sqlText = "select * from test where param = ?";
            int[] rsTypes = new int[]{1003, 1004, 1005};
            int[] rsConcurs = new int[]{1007, 1008};
            int[] rsHoldabilities = new int[]{1, 2};
            DatabaseMetaData meta = conn.getMetaData();
            for (final int type : rsTypes) {
                for (final int concur : rsConcurs) {
                    for (final int holdabililty : rsHoldabilities) {
                        if (meta.supportsResultSetConcurrency(type, concur)) {
                            assert (type == 1003);
                            assert (concur == 1007);
                            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                                @Override
                                public Object call() throws Exception {
                                    return conn.prepareStatement(null, type, concur, holdabililty);
                                }
                            }, SQLException.class, (String)"SQL string cannot be null");
                            continue;
                        }
                        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                return conn.prepareStatement("select * from test where param = ?", type, concur, holdabililty);
                            }
                        }, SQLFeatureNotSupportedException.class, null);
                    }
                }
            }
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.prepareStatement("select * from test where param = ?", 1003, 1007, 1);
                }
            });
            conn.close();
        }
    }

    @Test
    public void testPrepareStatementAutoGeneratedKeysUnsupported() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            String sqlText = "insert into test (val) values (?)";
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.prepareStatement("insert into test (val) values (?)", 1);
                }
            }, SQLFeatureNotSupportedException.class, (String)"Auto generated keys are not supported.");
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.prepareStatement("insert into test (val) values (?)", 2);
                }
            }, SQLFeatureNotSupportedException.class, (String)"Auto generated keys are not supported.");
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.prepareStatement("insert into test (val) values (?)", new int[]{1});
                }
            }, SQLFeatureNotSupportedException.class, (String)"Auto generated keys are not supported.");
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.prepareStatement("insert into test (val) values (?)", new String[]{"ID"});
                }
            }, SQLFeatureNotSupportedException.class, (String)"Auto generated keys are not supported.");
        }
    }

    @Test
    public void testPrepareCallUnsupported() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            String sqlText = "exec test()";
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.prepareCall("exec test()");
                }
            }, SQLFeatureNotSupportedException.class, (String)"Callable functions are not supported.");
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.prepareCall("exec test()", 1003, 1007);
                }
            }, SQLFeatureNotSupportedException.class, (String)"Callable functions are not supported.");
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.prepareCall("exec test()", 1003, 1007, 1);
                }
            }, SQLFeatureNotSupportedException.class, (String)"Callable functions are not supported.");
        }
    }

    @Test
    public void testNativeSql() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.nativeSQL(null);
                }
            }, SQLException.class, (String)"SQL string cannot be null");
            String sqlText = "select * from test";
            JdbcThinConnectionSelfTest.assertEquals((String)"select * from test", (String)conn.nativeSQL("select * from test"));
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.nativeSQL("select * from test");
                }
            });
        }
    }

    @Test
    public void testGetSetAutoCommit() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            final boolean ac0 = conn.getAutoCommit();
            conn.setAutoCommit(!ac0);
            conn.setAutoCommit(ac0);
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.setAutoCommit(ac0);
                }
            });
        }
    }

    @Test
    public void testCommit() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.commit();
                    return null;
                }
            }, SQLException.class, (String)"Transaction cannot be committed explicitly in auto-commit mode");
            JdbcThinConnectionSelfTest.assertTrue((boolean)conn.getAutoCommit());
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.commit();
                    return null;
                }
            }, SQLException.class, (String)"Transaction cannot be committed explicitly in auto-commit mode.");
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.commit();
                }
            });
        }
    }

    @Test
    public void testRollback() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.rollback();
                    return null;
                }
            }, SQLException.class, (String)"Transaction cannot be rolled back explicitly in auto-commit mode.");
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.rollback();
                }
            });
        }
    }

    @Test
    public void testBeginFailsWhenMvccIsDisabled() throws Exception {
        try (Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            conn.createStatement().execute("BEGIN");
            JdbcThinConnectionSelfTest.fail((String)"Exception is expected");
        }
        catch (SQLException e) {
            JdbcThinConnectionSelfTest.assertEquals((String)"25000", (String)e.getSQLState());
        }
    }

    @Test
    public void testCommitIgnoredWhenMvccIsDisabled() throws Exception {
        try (Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            conn.setAutoCommit(false);
            conn.createStatement().execute("COMMIT");
            conn.commit();
        }
    }

    @Test
    public void testRollbackIgnoredWhenMvccIsDisabled() throws Exception {
        try (Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            conn.setAutoCommit(false);
            conn.createStatement().execute("ROLLBACK");
            conn.rollback();
        }
    }

    @Test
    public void testGetMetaData() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            DatabaseMetaData meta = conn.getMetaData();
            JdbcThinConnectionSelfTest.assertNotNull((Object)meta);
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.getMetaData();
                }
            });
        }
    }

    @Test
    public void testGetSetReadOnly() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.setReadOnly(true);
                }
            });
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.isReadOnly();
                }
            });
        }
    }

    @Test
    public void testGetSetCatalog() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            assert (!conn.getMetaData().supportsCatalogsInDataManipulation());
            JdbcThinConnectionSelfTest.assertNull((Object)conn.getCatalog());
            conn.setCatalog("catalog");
            JdbcThinConnectionSelfTest.assertEquals(null, (String)conn.getCatalog());
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.setCatalog("");
                }
            });
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.getCatalog();
                }
            });
        }
    }

    @Test
    public void testGetSetTransactionIsolation() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            int[] levels;
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.setTransactionIsolation(-1);
                    return null;
                }
            }, SQLException.class, (String)"Invalid transaction isolation level");
            JdbcThinConnectionSelfTest.assertEquals((int)0, (int)conn.getTransactionIsolation());
            for (int level : levels = new int[]{1, 2, 4, 8}) {
                conn.setTransactionIsolation(level);
                JdbcThinConnectionSelfTest.assertEquals((int)level, (int)conn.getTransactionIsolation());
            }
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.getTransactionIsolation();
                }
            });
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.setTransactionIsolation(8);
                }
            });
        }
    }

    @Test
    public void testClearGetWarnings() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            SQLWarning warn = conn.getWarnings();
            JdbcThinConnectionSelfTest.assertNull((Object)warn);
            conn.clearWarnings();
            warn = conn.getWarnings();
            JdbcThinConnectionSelfTest.assertNull((Object)warn);
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.getWarnings();
                }
            });
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.clearWarnings();
                }
            });
        }
    }

    @Test
    public void testGetSetTypeMap() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.getTypeMap();
                }
            }, SQLFeatureNotSupportedException.class, (String)"Types mapping is not supported");
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.setTypeMap(new HashMap());
                    return null;
                }
            }, SQLFeatureNotSupportedException.class, (String)"Types mapping is not supported");
            conn.close();
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.getTypeMap();
                }
            }, SQLException.class, (String)"Connection is closed");
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.setTypeMap(new HashMap());
                    return null;
                }
            }, SQLException.class, (String)"Connection is closed");
        }
    }

    @Test
    public void testGetSetHoldability() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            JdbcThinConnectionSelfTest.assertEquals((int)conn.getMetaData().getResultSetHoldability(), (int)conn.getHoldability());
            JdbcThinConnectionSelfTest.assertEquals((int)1, (int)conn.getHoldability());
            conn.setHoldability(2);
            JdbcThinConnectionSelfTest.assertEquals((int)2, (int)conn.getHoldability());
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.setHoldability(-1);
                    return null;
                }
            }, SQLException.class, (String)"Invalid result set holdability value");
            conn.close();
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.getHoldability();
                }
            }, SQLException.class, (String)"Connection is closed");
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.setHoldability(1);
                    return null;
                }
            }, SQLException.class, (String)"Connection is closed");
        }
    }

    @Test
    public void testSetSavepoint() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            assert (!conn.getMetaData().supportsSavepoints());
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.setSavepoint();
                    return null;
                }
            }, SQLException.class, (String)"Savepoint cannot be set in auto-commit mode");
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.setSavepoint();
                }
            });
        }
    }

    @Test
    public void testSetSavepointName() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            assert (!conn.getMetaData().supportsSavepoints());
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.setSavepoint(null);
                    return null;
                }
            }, SQLException.class, (String)"Savepoint name cannot be null");
            String name = "savepoint";
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.setSavepoint("savepoint");
                    return null;
                }
            }, SQLException.class, (String)"Savepoint cannot be set in auto-commit mode");
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.setSavepoint("savepoint");
                }
            });
        }
    }

    @Test
    public void testRollbackSavePoint() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            assert (!conn.getMetaData().supportsSavepoints());
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.rollback(null);
                    return null;
                }
            }, SQLException.class, (String)"Invalid savepoint");
            final Savepoint savepoint = this.getFakeSavepoint();
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.rollback(savepoint);
                    return null;
                }
            }, SQLException.class, (String)"Auto-commit mode");
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.rollback(savepoint);
                }
            });
        }
    }

    @Test
    public void testReleaseSavepoint() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            assert (!conn.getMetaData().supportsSavepoints());
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.releaseSavepoint(null);
                    return null;
                }
            }, SQLException.class, (String)"Savepoint cannot be null");
            final Savepoint savepoint = this.getFakeSavepoint();
            this.checkNotSupported(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.releaseSavepoint(savepoint);
                }
            });
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.releaseSavepoint(savepoint);
                }
            });
        }
    }

    @Test
    public void testCreateClob() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.createClob();
                }
            }, SQLFeatureNotSupportedException.class, (String)"SQL-specific types are not supported");
            conn.close();
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.createClob();
                }
            }, SQLException.class, (String)"Connection is closed");
        }
    }

    @Test
    public void testCreateBlob() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.createBlob();
                }
            }, SQLFeatureNotSupportedException.class, (String)"SQL-specific types are not supported");
            conn.close();
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.createBlob();
                }
            }, SQLException.class, (String)"Connection is closed");
        }
    }

    @Test
    public void testCreateNClob() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.createNClob();
                }
            }, SQLFeatureNotSupportedException.class, (String)"SQL-specific types are not supported");
            conn.close();
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.createNClob();
                }
            }, SQLException.class, (String)"Connection is closed");
        }
    }

    @Test
    public void testCreateSQLXML() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.createSQLXML();
                }
            }, SQLFeatureNotSupportedException.class, (String)"SQL-specific types are not supported");
            conn.close();
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.createSQLXML();
                }
            }, SQLException.class, (String)"Connection is closed");
        }
    }

    @Test
    public void testGetSetClientInfoPair() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            String name = "ApplicationName";
            String val = "SelfTest";
            JdbcThinConnectionSelfTest.assertNull((Object)conn.getWarnings());
            conn.setClientInfo("ApplicationName", "SelfTest");
            JdbcThinConnectionSelfTest.assertNull((Object)conn.getClientInfo("SelfTest"));
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.getClientInfo("ApplicationName");
                }
            });
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.setClientInfo("ApplicationName", "SelfTest");
                    return null;
                }
            }, SQLClientInfoException.class, (String)"Connection is closed");
        }
    }

    @Test
    public void testGetSetClientInfoProperties() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            String name = "ApplicationName";
            String val = "SelfTest";
            final Properties props = new Properties();
            props.setProperty("ApplicationName", "SelfTest");
            conn.setClientInfo(props);
            Properties propsResult = conn.getClientInfo();
            JdbcThinConnectionSelfTest.assertNotNull((Object)propsResult);
            JdbcThinConnectionSelfTest.assertTrue((boolean)propsResult.isEmpty());
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.getClientInfo();
                }
            });
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.setClientInfo(props);
                    return null;
                }
            }, SQLClientInfoException.class, (String)"Connection is closed");
        }
    }

    @Test
    public void testCreateArrayOf() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            String typeName = "varchar";
            final String[] elements = new String[]{"apple", "pear"};
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.createArrayOf(null, null);
                    return null;
                }
            }, SQLException.class, (String)"Type name cannot be null");
            this.checkNotSupported(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.createArrayOf("varchar", elements);
                }
            });
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.createArrayOf("varchar", elements);
                }
            });
        }
    }

    @Test
    public void testCreateStruct() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return conn.createStruct(null, null);
                }
            }, SQLException.class, (String)"Type name cannot be null");
            String typeName = "employee";
            final Object[] attrs = new Object[]{100, "Tom"};
            this.checkNotSupported(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.createStruct("employee", attrs);
                }
            });
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.createStruct("employee", attrs);
                }
            });
        }
    }

    @Test
    public void testGetSetSchema() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            JdbcThinConnectionSelfTest.assertEquals((String)"PUBLIC", (String)conn.getSchema());
            String schema = "test";
            conn.setSchema("test");
            JdbcThinConnectionSelfTest.assertEquals((String)"test".toUpperCase(), (String)conn.getSchema());
            conn.setSchema("\"test\"");
            JdbcThinConnectionSelfTest.assertEquals((String)"test", (String)conn.getSchema());
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.setSchema("test");
                }
            });
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.getSchema();
                }
            });
        }
    }

    @Test
    public void testAbort() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.abort(null);
                    return null;
                }
            }, SQLException.class, (String)"Executor cannot be null");
            ExecutorService executor = Executors.newFixedThreadPool(1);
            conn.abort(executor);
            JdbcThinConnectionSelfTest.assertTrue((boolean)conn.isClosed());
        }
    }

    @Test
    public void testGetSetNetworkTimeout() throws Exception {
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            JdbcThinConnectionSelfTest.assertEquals((int)0, (int)conn.getNetworkTimeout());
            final ExecutorService executor = Executors.newFixedThreadPool(1);
            int timeout = 1000;
            GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    conn.setNetworkTimeout(executor, -1);
                    return null;
                }
            }, SQLException.class, (String)"Network timeout cannot be negative");
            conn.setNetworkTimeout(executor, 1000);
            JdbcThinConnectionSelfTest.assertEquals((int)1000, (int)conn.getNetworkTimeout());
            conn.close();
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.getNetworkTimeout();
                }
            });
            this.checkConnectionClosed(new GridTestUtils.RunnableX(){

                public void runx() throws Exception {
                    conn.setNetworkTimeout(executor, 1000);
                }
            });
        }
    }

    @Test
    public void testInvalidNestedTxMode() {
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                DriverManager.getConnection(JdbcThinConnectionSelfTest.this.urlWithPartitionAwarenessProp + "&nestedTransactionsMode=invalid");
                return null;
            }
        }, SQLException.class, (String)"Invalid nested transactions handling mode");
    }

    @Test
    public void testInvalidNestedTxModeOnServerSide() {
        final ConnectionPropertiesImpl connProps = new ConnectionPropertiesImpl();
        connProps.setAddresses(new HostAndPortRange[]{new HostAndPortRange(LOCALHOST, 10800, 10800)});
        connProps.nestedTxMode("invalid");
        connProps.setPartitionAwareness(partitionAwareness);
        GridTestUtils.assertThrows(null, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                new JdbcThinTcpIo((ConnectionProperties)connProps, new InetSocketAddress(JdbcThinConnectionSelfTest.LOCALHOST, 10800), JdbcThinConnectionSelfTest.this.getBinaryContext(), 0);
                return null;
            }
        }, SQLException.class, (String)"err=Invalid nested transactions handling mode: invalid");
    }

    @Test
    public void testSslClientAndPlainServer() {
        Throwable e = GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                DriverManager.getConnection(JdbcThinConnectionSelfTest.this.urlWithPartitionAwarenessProp + "&sslMode=require&sslClientCertificateKeyStoreUrl=" + CLI_KEY_STORE_PATH + "&sslClientCertificateKeyStorePassword=123456&sslTrustCertificateKeyStoreUrl=" + SRV_KEY_STORE_PATH + "&sslTrustCertificateKeyStorePassword=123456");
                return null;
            }
        }, SQLException.class, (String)(partitionAwareness ? "Failed to connect to server" : "Failed to SSL connect to server"));
        if (partitionAwareness) {
            for (Throwable t : e.getSuppressed()) {
                JdbcThinConnectionSelfTest.assertEquals(SQLException.class, t.getClass());
                JdbcThinConnectionSelfTest.assertTrue((boolean)t.getMessage().contains("Failed to SSL connect to server"));
            }
        }
    }

    @Test
    public void testMultithreadingException() throws Exception {
        int threadCnt = 10;
        final boolean[] end = new boolean[]{false};
        final SQLException[] exs = new SQLException[threadCnt];
        final AtomicInteger exCnt = new AtomicInteger(0);
        try (final Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp);){
            IgniteInternalFuture f = GridTestUtils.runMultiThreadedAsync((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        conn.createStatement();
                        while (!end[0]) {
                            conn.createStatement().execute("SELECT 1");
                        }
                        conn.createStatement().execute("SELECT 1");
                    }
                    catch (SQLException e) {
                        end[0] = true;
                        exs[exCnt.getAndIncrement()] = e;
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                        JdbcThinConnectionSelfTest.fail((String)("Unexpected exception (see details above): " + e.getMessage()));
                    }
                }
            }, (int)threadCnt, (String)"run-query");
            f.get();
            boolean exceptionFound = false;
            for (SQLException e : exs) {
                if (e == null || !e.getMessage().contains("Concurrent access to JDBC connection is not allowed")) continue;
                exceptionFound = true;
            }
            JdbcThinConnectionSelfTest.assertTrue((String)"Concurrent access to JDBC connection is not allowed", (boolean)exceptionFound);
        }
    }

    @Test
    public void testDisabledFeatures() throws Exception {
        this.assertInvalid(this.urlWithPartitionAwarenessProp + "&disabledFeatures=unknownFeature", "Unknown feature: unknownFeature");
        try (Connection conn = DriverManager.getConnection(this.urlWithPartitionAwarenessProp + "&disabledFeatures=time_zone");){
            JdbcThinConnectionSelfTest.assertFalse((boolean)conn.isClosed());
        }
    }

    private Savepoint getFakeSavepoint() {
        return new Savepoint(){

            @Override
            public int getSavepointId() throws SQLException {
                return 100;
            }

            @Override
            public String getSavepointName() {
                return "savepoint";
            }
        };
    }

    private MarshallerContext getFakeMarshallerCtx() {
        return new MarshallerContext(){

            public boolean registerClassName(byte platformId, int typeId, String clsName) throws IgniteCheckedException {
                return false;
            }

            public boolean registerClassNameLocally(byte platformId, int typeId, String clsName) throws IgniteCheckedException {
                return false;
            }

            public Class getClass(int typeId, ClassLoader ldr) throws ClassNotFoundException, IgniteCheckedException {
                return null;
            }

            public String getClassName(byte platformId, int typeId) throws ClassNotFoundException, IgniteCheckedException {
                return null;
            }

            public boolean isSystemType(String typeName) {
                return false;
            }

            public IgnitePredicate<String> classNameFilter() {
                return null;
            }

            public JdkMarshaller jdkMarshaller() {
                return null;
            }
        };
    }

    private BinaryContext getBinaryContext() {
        BinaryMarshaller marsh = new BinaryMarshaller();
        marsh.setContext(this.getFakeMarshallerCtx());
        BinaryContext ctx = new BinaryContext((BinaryMetadataHandler)BinaryNoopMetadataHandler.instance(), new IgniteConfiguration(), (IgniteLogger)new NullLogger());
        ctx.configure(marsh);
        ctx.registerUserTypesSchema();
        return ctx;
    }
}

