/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.AffinityFunctionContext;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cache.query.annotations.QuerySqlField;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.jdbc.thin.AffinityCache;
import org.apache.ignite.internal.jdbc.thin.QualifiedSQLQuery;
import org.apache.ignite.internal.processors.query.QueryHistory;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.sql.optimizer.affinity.PartitionResult;
import org.apache.ignite.internal.util.GridBoundedLinkedHashMap;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.jdbc.thin.JdbcThinAbstractSelfTest;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public class JdbcThinAffinityAwarenessSelfTest
extends JdbcThinAbstractSelfTest {
    private static final String URL = "jdbc:ignite:thin://127.0.0.1:10800..10802?affinityAwareness=true";
    private static final int NODES_CNT = 3;
    private static final int QUERY_EXECUTION_MULTIPLIER = 5;
    private static final int ROWS_COUNT = 100;
    private Connection conn;
    private Statement stmt;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        CacheConfiguration cache = JdbcThinAffinityAwarenessSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setIndexedTypes(new Class[]{Integer.class, Person.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        super.beforeTestsStarted();
        this.startGridsMultiThreaded(3);
        this.fillCache("default");
    }

    protected void beforeTest() throws Exception {
        this.conn = DriverManager.getConnection(URL);
        this.conn.setSchema("\"default\"");
        this.stmt = this.conn.createStatement();
        assert (this.stmt != null);
        assert (!this.stmt.isClosed());
    }

    protected void afterTest() throws Exception {
        U.closeQuiet((AutoCloseable)this.stmt);
        this.conn.close();
        assert (this.stmt.isClosed());
        assert (this.conn.isClosed());
    }

    @Test
    public void testExecuteQueries() throws Exception {
        this.checkNodesUsage(null, "select * from Person where _key = 1", 1, 1, false);
        this.checkNodesUsage(null, "select * from Person where _key = 1 or _key = 2", 2, 2, false);
        this.checkNodesUsage(null, "select * from Person where _key in (1, 2)", 2, 2, false);
    }

    @Test
    public void testExecuteParametrizedQueries() throws Exception {
        PreparedStatement ps = this.conn.prepareStatement("select * from Person where _key = ?");
        ps.setInt(1, 2);
        this.checkNodesUsage(ps, null, 1, 1, false);
        ps = this.conn.prepareStatement("select * from Person where _key = ? or _key = ?");
        ps.setInt(1, 1);
        ps.setInt(2, 2);
        this.checkNodesUsage(ps, null, 2, 2, false);
        ps = this.conn.prepareStatement("select * from Person where _key in (?, ?)");
        ps.setInt(1, 1);
        ps.setInt(2, 2);
        this.checkNodesUsage(ps, null, 2, 2, false);
    }

    @Test
    public void testUpdateQueries() throws Exception {
        this.checkNodesUsage(null, "update Person set firstName = 'TestFirstName' where _key = 1", 1, 1, true);
        this.checkNodesUsage(null, "update Person set firstName = 'TestFirstName' where _key = 1 or _key = 2", 2, 2, true);
        this.checkNodesUsage(null, "update Person set firstName = 'TestFirstName' where _key in (1, 2)", 2, 2, true);
    }

    @Test
    public void testUpdateParametrizedQueries() throws Exception {
        PreparedStatement ps = this.conn.prepareStatement("update Person set firstName = 'TestFirstName' where _key = ?");
        ps.setInt(1, 2);
        this.checkNodesUsage(ps, null, 1, 1, true);
        ps = this.conn.prepareStatement("update Person set firstName = 'TestFirstName' where _key = ? or _key = ?");
        ps.setInt(1, 1);
        ps.setInt(2, 2);
        this.checkNodesUsage(ps, null, 2, 2, true);
        ps = this.conn.prepareStatement("update Person set firstName = 'TestFirstName' where _key in (?, ?)");
        ps.setInt(1, 1);
        ps.setInt(2, 2);
        this.checkNodesUsage(ps, null, 2, 2, true);
    }

    @Test
    public void testDeleteQueries() throws Exception {
        this.checkNodesUsage(null, "delete from Person where _key = 10000 or _key = 20000", 2, 0, true);
        this.checkNodesUsage(null, "delete from Person where _key in (10000, 20000)", 2, 0, true);
    }

    @Test
    public void testDeleteParametrizedQueries() throws Exception {
        PreparedStatement ps = this.conn.prepareStatement("delete from Person where _key = ? or _key = ?");
        ps.setInt(1, 1000);
        ps.setInt(2, 2000);
        this.checkNodesUsage(ps, null, 2, 0, true);
        ps = this.conn.prepareStatement("delete from Person where _key in (?, ?)");
        ps.setInt(1, 1000);
        ps.setInt(2, 2000);
        this.checkNodesUsage(ps, null, 2, 0, true);
    }

    @Test
    public void testQueryWithNullPartitionResponseBasedOnAllNode() throws Exception {
        this.verifyPartitionResultIsNull("select * from Person where age > 15", 85);
    }

    @Test
    public void testQueryWithNullPartitionResponseBasedOnNoneNode() throws Exception {
        this.verifyPartitionResultIsNull("select * from Person where _key = 1 and _key = 2", 0);
    }

    @Test
    public void testCacheWithNonRendezvousAffinityFunction() throws Exception {
        String cacheName = "cacheWithCustomAffinityFunction";
        CacheConfiguration<Object, Object> cache = this.prepareCacheConfig("cacheWithCustomAffinityFunction");
        cache.setAffinity((AffinityFunction)new DummyAffinity());
        this.ignite(0).createCache(cache);
        this.fillCache("cacheWithCustomAffinityFunction");
        this.verifyPartitionResultIsNull("select * from \"cacheWithCustomAffinityFunction\".Person where _key = 1", 1);
    }

    @Test
    public void testCacheWithCustomNodeFilter() throws Exception {
        String cacheName = "cacheWithCustomNodeFilter";
        CacheConfiguration<Object, Object> cache = this.prepareCacheConfig("cacheWithCustomNodeFilter");
        cache.setNodeFilter((IgnitePredicate)new CustomNodeFilter());
        this.ignite(0).createCache(cache);
        this.fillCache("cacheWithCustomNodeFilter");
        this.verifyPartitionResultIsNull("select * from \"cacheWithCustomNodeFilter\".Person where _key = 1", 1);
    }

    @Test
    public void testCacheWithRendezvousCustomPartitionsCount() throws Exception {
        String cacheName = "cacheWithRendezvousCustomPartitionsCount";
        CacheConfiguration<Object, Object> cache = this.prepareCacheConfig("cacheWithRendezvousCustomPartitionsCount");
        cache.setAffinity((AffinityFunction)new RendezvousAffinityFunction(false, 10));
        this.ignite(0).createCache(cache);
        this.fillCache("cacheWithRendezvousCustomPartitionsCount");
        this.checkNodesUsage(null, "select * from \"cacheWithRendezvousCustomPartitionsCount\".Person where _key = 1", 1, 1, false);
    }

    @Test
    public void testChangeTopologyDetectionWithinPartitionDistributionResponse() throws Exception {
        String sqlQry = "select * from Person where _key = 1";
        this.stmt.executeQuery("select * from Person where _key = 1");
        AffinityCache affinityCache = (AffinityCache)GridTestUtils.getFieldValue((Object)this.conn, (String[])new String[]{"affinityCache"});
        this.startGrid(3);
        this.stmt.executeQuery("select * from Person where _key = 1");
        AffinityCache recreatedAffinityCache = (AffinityCache)GridTestUtils.getFieldValue((Object)this.conn, (String[])new String[]{"affinityCache"});
        JdbcThinAffinityAwarenessSelfTest.assertTrue((recreatedAffinityCache.version().compareTo(affinityCache.version()) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testChangeTopologyDetectionWithinQueryExecutionResponse() throws Exception {
        String sqlQry = "select * from Person where _key = 1";
        this.stmt.executeQuery("select * from Person where _key = 1");
        this.stmt.executeQuery("select * from Person where _key = 1");
        AffinityCache affinityCache = (AffinityCache)GridTestUtils.getFieldValue((Object)this.conn, (String[])new String[]{"affinityCache"});
        this.startGrid(4);
        this.stmt.executeQuery("select * from Person where _key = 2");
        AffinityCache recreatedAffinityCache = (AffinityCache)GridTestUtils.getFieldValue((Object)this.conn, (String[])new String[]{"affinityCache"});
        JdbcThinAffinityAwarenessSelfTest.assertTrue((recreatedAffinityCache.version().compareTo(affinityCache.version()) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testChangeTopologyDetectionWithinAffinityAwarenessUnrelatedQuery() throws Exception {
        String sqlQry = "select * from Person where _key = 1";
        ResultSet rs = this.stmt.executeQuery("select * from Person where _key = 1");
        AffinityCache affinityCache = (AffinityCache)GridTestUtils.getFieldValue((Object)this.conn, (String[])new String[]{"affinityCache"});
        this.startGrid(5);
        rs.getMetaData();
        AffinityCache recreatedAffinityCache = (AffinityCache)GridTestUtils.getFieldValue((Object)this.conn, (String[])new String[]{"affinityCache"});
        JdbcThinAffinityAwarenessSelfTest.assertTrue((recreatedAffinityCache.version().compareTo(affinityCache.version()) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAffinityAwarenessIsSkippedIfItIsSwitchedOff() throws Exception {
        Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10800..10802?affinityAwareness=false");
        Statement stmt = conn.createStatement();
        String cacheName = "yac";
        CacheConfiguration<Object, Object> cache = this.prepareCacheConfig("yac");
        this.ignite(0).createCache(cache);
        stmt.executeQuery("select * from \"yac\".Person where _key = 1");
        AffinityCache affinityCache = (AffinityCache)GridTestUtils.getFieldValue((Object)conn, (String[])new String[]{"affinityCache"});
        JdbcThinAffinityAwarenessSelfTest.assertNull((String)"Affinity cache is not null.", (Object)affinityCache);
    }

    @Test
    public void testAffinityAwarenessIsSkippedByDefault() throws Exception {
        Connection conn = DriverManager.getConnection("jdbc:ignite:thin://127.0.0.1:10800..10802");
        Statement stmt = conn.createStatement();
        String cacheName = "yacccc";
        CacheConfiguration<Object, Object> cache = this.prepareCacheConfig("yacccc");
        this.ignite(0).createCache(cache);
        stmt.executeQuery("select * from \"yacccc\".Person where _key = 1");
        AffinityCache affinityCache = (AffinityCache)GridTestUtils.getFieldValue((Object)conn, (String[])new String[]{"affinityCache"});
        JdbcThinAffinityAwarenessSelfTest.assertNull((String)"Affinity cache is not null.", (Object)affinityCache);
    }

    @Test
    public void testAffinityCacheStoresSchemaBindedQuries() throws Exception {
        String cacheName = "yacc";
        CacheConfiguration<Object, Object> cache = this.prepareCacheConfig("yacc");
        cache.setSqlSchema("yacc");
        this.ignite(0).createCache(cache);
        this.fillCache("yacc");
        this.stmt.execute("select * from \"" + "yacc".toUpperCase() + "\".Person where _key = 1");
        this.conn.setSchema("yacc".toUpperCase());
        this.stmt = this.conn.createStatement();
        this.stmt.execute("select * from \"" + "yacc".toUpperCase() + "\".Person where _key = 1");
        AffinityCache affinityCache = (AffinityCache)GridTestUtils.getFieldValue((Object)this.conn, (String[])new String[]{"affinityCache"});
        GridBoundedLinkedHashMap sqlCache = (GridBoundedLinkedHashMap)GridTestUtils.getFieldValue((Object)affinityCache, (String[])new String[]{"sqlCache"});
        Set schemas = sqlCache.keySet().stream().map(QualifiedSQLQuery::schemaName).collect(Collectors.toSet());
        JdbcThinAffinityAwarenessSelfTest.assertTrue((String)"Affinity cache doesn't contain query  sent to 'default' schema.", (boolean)schemas.contains("default"));
        JdbcThinAffinityAwarenessSelfTest.assertTrue((String)("Affinity cache doesn't contain query  sent to '" + "yacc".toUpperCase() + "' schema."), (boolean)schemas.contains("yacc".toUpperCase()));
    }

    @Test
    public void testAffinityCacheCompactsPartitonDestributions() throws Exception {
        String cacheName = "yaccc";
        CacheConfiguration<Object, Object> cache = this.prepareCacheConfig("yaccc");
        this.ignite(0).createCache(cache);
        this.fillCache("yaccc");
        this.stmt.execute("select * from Person where _key = 2");
        this.stmt.execute("select * from Person where _key = 2");
        this.stmt.execute("select * from \"yaccc\".Person where _key = 2");
        this.stmt.execute("select * from \"yaccc\".Person where _key = 2");
        AffinityCache affinityCache = (AffinityCache)GridTestUtils.getFieldValue((Object)this.conn, (String[])new String[]{"affinityCache"});
        GridBoundedLinkedHashMap sqlCache = (GridBoundedLinkedHashMap)GridTestUtils.getFieldValue((Object)affinityCache, (String[])new String[]{"sqlCache"});
        GridBoundedLinkedHashMap cachePartitionsDistribution = (GridBoundedLinkedHashMap)GridTestUtils.getFieldValue((Object)affinityCache, (String[])new String[]{"cachePartitionsDistribution"});
        JdbcThinAffinityAwarenessSelfTest.assertEquals((String)"Sql sub-cache of affinity cache has unexpected number of elements.", (int)2, (int)sqlCache.size());
        JdbcThinAffinityAwarenessSelfTest.assertEquals((String)"Partitions destribution sub-cache of affinity cache has unexpected number of elements.", (int)2, (int)cachePartitionsDistribution.size());
        JdbcThinAffinityAwarenessSelfTest.assertTrue((String)"Partitions distributions are not the same.", (cachePartitionsDistribution.get((Object)0) == cachePartitionsDistribution.get((Object)1) ? 1 : 0) != 0);
    }

    @Test
    public void testReconnect() throws Exception {
        int i;
        this.checkNodesUsage(null, "select * from Person where _key = 3", 1, 1, false);
        this.startGrid(7);
        for (i = 0; i < 3; ++i) {
            this.stopGrid(i);
        }
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JdbcThinAffinityAwarenessSelfTest.this.stmt.execute("select * from Person where _key = 3");
                return null;
            }
        }, SQLException.class, (String)"Failed to communicate with Ignite cluster.");
        for (i = 0; i < 3; ++i) {
            this.startGrid(i);
        }
        this.stopGrid(4);
        this.stopGrid(5);
        this.stopGrid(6);
        this.stopGrid(7);
        this.stmt = this.conn.createStatement();
        this.stmt.execute("select * from Person where _key = 3");
        this.checkNodesUsage(null, "select * from Person where _key = 3", 1, 1, false);
    }

    protected CacheConfiguration<Object, Object> prepareCacheConfig(String cacheName) {
        CacheConfiguration cache = JdbcThinAffinityAwarenessSelfTest.defaultCacheConfiguration();
        cache.setName(cacheName);
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setIndexedTypes(new Class[]{Integer.class, Person.class});
        return cache;
    }

    protected void verifyPartitionResultIsNull(String sqlQry, int expRowsCnt) throws SQLException {
        ResultSet rs = this.stmt.executeQuery(sqlQry);
        assert (rs != null);
        int rowCntr = 0;
        while (rs.next()) {
            ++rowCntr;
        }
        JdbcThinAffinityAwarenessSelfTest.assertEquals((String)"Rows counter doesn't match expected value.", (int)expRowsCnt, (int)rowCntr);
        AffinityCache affinityCache = (AffinityCache)GridTestUtils.getFieldValue((Object)this.conn, (String[])new String[]{"affinityCache"});
        PartitionResult gotPartRes = affinityCache.partitionResult(new QualifiedSQLQuery("default", sqlQry)).partitionResult();
        JdbcThinAffinityAwarenessSelfTest.assertNull((String)"Partition result descriptor is not null.", (Object)gotPartRes);
    }

    private void checkNodesUsage(PreparedStatement ps, String sql, int maxNodesUsedCnt, int expRowsCnt, boolean dml) throws Exception {
        int i;
        if (ps != null) {
            if (dml) {
                ps.executeUpdate();
            } else {
                ps.executeQuery();
            }
        } else if (dml) {
            this.stmt.executeUpdate(sql);
        } else {
            this.stmt.executeQuery(sql);
        }
        for (i = 0; i < 3; ++i) {
            ((IgniteH2Indexing)this.grid(i).context().query().getIndexing()).runningQueryManager().resetQueryHistoryMetrics();
        }
        for (i = 0; i < 15; ++i) {
            ResultSet rs = null;
            int updatedRowsCnt = 0;
            if (ps != null) {
                if (dml) {
                    updatedRowsCnt = ps.executeUpdate();
                } else {
                    rs = ps.executeQuery();
                }
            } else if (dml) {
                updatedRowsCnt = this.stmt.executeUpdate(sql);
            } else {
                rs = this.stmt.executeQuery(sql);
            }
            if (dml) {
                JdbcThinAffinityAwarenessSelfTest.assertEquals((String)("Unexpected updated rows count: expected [" + expRowsCnt + "], got [" + updatedRowsCnt + "]"), (int)expRowsCnt, (int)updatedRowsCnt);
                continue;
            }
            assert (rs != null);
            int gotRowsCnt = 0;
            while (rs.next()) {
                ++gotRowsCnt;
            }
            JdbcThinAffinityAwarenessSelfTest.assertEquals((String)("Unexpected rows count: expected [" + expRowsCnt + "], got [" + gotRowsCnt + "]"), (int)expRowsCnt, (int)gotRowsCnt);
        }
        int nonEmptyMetricsCntr = 0;
        int qryExecutionsCntr = 0;
        for (int i2 = 0; i2 < 3; ++i2) {
            Collection metrics = ((IgniteH2Indexing)this.grid(i2).context().query().getIndexing()).runningQueryManager().queryHistoryMetrics().values();
            if (metrics.isEmpty()) continue;
            ++nonEmptyMetricsCntr;
            qryExecutionsCntr = (int)((long)qryExecutionsCntr + ((QueryHistory)new ArrayList(metrics).get(0)).executions());
        }
        JdbcThinAffinityAwarenessSelfTest.assertTrue((String)("Unexpected amount of used nodes: expected [0 < nodesCnt <= " + maxNodesUsedCnt + "], got [" + nonEmptyMetricsCntr + "]"), (nonEmptyMetricsCntr > 0 && nonEmptyMetricsCntr <= maxNodesUsedCnt ? 1 : 0) != 0);
        JdbcThinAffinityAwarenessSelfTest.assertEquals((String)("Executions count doesn't match expeted value: expected [15], got [" + qryExecutionsCntr + "]"), (int)15, (int)qryExecutionsCntr);
    }

    private void fillCache(String cacheName) {
        IgniteCache cachePerson = this.grid(0).cache(cacheName);
        assert (cachePerson != null);
        for (int i = 0; i < 100; ++i) {
            cachePerson.put((Object)i, (Object)new Person(i, "John" + i, "White" + i, i + 1));
        }
    }

    public static class CustomNodeFilter
    implements IgnitePredicate<ClusterNode> {
        private static final long serialVersionUID = 0L;

        public boolean apply(ClusterNode node) {
            return true;
        }

        public boolean equals(Object obj) {
            return false;
        }

        public String toString() {
            return "CustomNodeFilter";
        }
    }

    private static class DummyAffinity
    implements AffinityFunction {
        public void reset() {
        }

        public int partitions() {
            return 1;
        }

        public int partition(Object key) {
            return 0;
        }

        public List<List<ClusterNode>> assignPartitions(AffinityFunctionContext affCtx) {
            List nodes = affCtx.currentTopologySnapshot();
            ArrayList<List<ClusterNode>> assign = new ArrayList<List<ClusterNode>>(this.partitions());
            for (int i = 0; i < this.partitions(); ++i) {
                assign.add(Collections.singletonList(nodes.get(0)));
            }
            return assign;
        }

        public void removeNode(UUID nodeId) {
        }
    }

    private static class Person
    implements Serializable {
        @QuerySqlField
        private final int id;
        @QuerySqlField
        private final String firstName;
        @QuerySqlField
        private final String lastName;
        @QuerySqlField
        private final int age;

        private Person(int id, String firstName, String lastName, int age) {
            assert (!F.isEmpty((String)firstName));
            assert (!F.isEmpty((String)lastName));
            assert (age > 0);
            this.id = id;
            this.firstName = firstName;
            this.lastName = lastName;
            this.age = age;
        }
    }
}

