/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.index.AbstractIndexingCommonTest;
import org.apache.ignite.internal.processors.odbc.ClientListenerProcessor;
import org.apache.ignite.internal.processors.port.GridPortRecord;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.GridTestUtils;

public class JdbcThinAbstractSelfTest
extends AbstractIndexingCommonTest {
    public static boolean partitionAwareness;

    protected void checkNotSupported(GridTestUtils.RunnableX r) {
        GridTestUtils.assertThrowsWithCause((Runnable)r, SQLFeatureNotSupportedException.class);
    }

    protected void checkConnectionClosed(GridTestUtils.RunnableX r) {
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> {
            r.run();
            return null;
        }, SQLException.class, (String)"Connection is closed");
    }

    protected void checkStatementClosed(GridTestUtils.RunnableX r) {
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> {
            r.run();
            return null;
        }, SQLException.class, (String)"Statement is closed");
    }

    protected void checkResultSetClosed(GridTestUtils.RunnableX r) {
        GridTestUtils.assertThrowsAnyCause((IgniteLogger)log, () -> {
            r.run();
            return null;
        }, SQLException.class, (String)"Result set is closed");
    }

    protected Connection connect(IgniteEx node, String params) throws SQLException {
        Collection recs = node.context().ports().records();
        GridPortRecord cliLsnrRec = null;
        for (GridPortRecord rec : recs) {
            if (rec.clazz() != ClientListenerProcessor.class) continue;
            cliLsnrRec = rec;
            break;
        }
        JdbcThinAbstractSelfTest.assertNotNull(cliLsnrRec);
        String connStr = "jdbc:ignite:thin://127.0.0.1:" + cliLsnrRec.port();
        if (!F.isEmpty((String)params)) {
            connStr = connStr + "/?" + params;
        }
        return DriverManager.getConnection(connStr);
    }

    protected List<List<?>> execute(Connection conn, String sql, Object ... args) throws SQLException {
        try (PreparedStatement s = conn.prepareStatement(sql);){
            for (int i = 0; i < args.length; ++i) {
                s.setObject(i + 1, args[i]);
            }
            if (s.execute()) {
                ArrayList res = new ArrayList();
                try (ResultSet rs = s.getResultSet();){
                    ResultSetMetaData meta = rs.getMetaData();
                    int cnt = meta.getColumnCount();
                    while (rs.next()) {
                        ArrayList<Object> row = new ArrayList<Object>(cnt);
                        for (int i = 1; i <= cnt; ++i) {
                            row.add(rs.getObject(i));
                        }
                        res.add(row);
                    }
                }
                ArrayList arrayList = res;
                return arrayList;
            }
            List<List<?>> list = Collections.emptyList();
            return list;
        }
    }

    protected boolean keepSerializedObjects() {
        return true;
    }
}

