/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc;

import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.binary.BinaryObjectBuilder;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.QueryEntity;
import org.apache.ignite.cache.QueryIndex;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;

public abstract class AbstractJdbcPojoQuerySelfTest
extends GridCommonAbstractTest {
    protected static final String TEST_OBJECT = "org.apache.ignite.internal.JdbcTestObject";
    protected static final String TEST_OBJECT_2 = "org.apache.ignite.internal.JdbcTestObject2";
    protected Statement stmt;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        CacheConfiguration cache = AbstractJdbcPojoQuerySelfTest.defaultCacheConfiguration();
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        QueryEntity queryEntity = new QueryEntity();
        queryEntity.setKeyType("java.lang.String");
        queryEntity.setValueType(TEST_OBJECT);
        queryEntity.addQueryField("id", "java.lang.Integer", null);
        queryEntity.addQueryField("testObject", TEST_OBJECT_2, null);
        queryEntity.setIndexes(Collections.singletonList(new QueryIndex("id")));
        cache.setQueryEntities(Collections.singletonList(queryEntity));
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        IgniteEx ignite = this.startGrid(0);
        BinaryObjectBuilder builder = ignite.binary().builder(TEST_OBJECT);
        BinaryObjectBuilder builder2 = ignite.binary().builder(TEST_OBJECT_2);
        builder2.setField("id", (Object)1);
        builder2.setField("boolVal", (Object)true);
        BinaryObject testObject = builder2.build();
        builder.setField("id", (Object)1);
        builder.setField("testObject", (Object)testObject);
        BinaryObject binObj = builder.build();
        IgniteCache cache = this.grid(0).cache("default");
        cache.put((Object)"0", (Object)binObj);
    }

    protected void beforeTest() throws Exception {
        this.stmt = DriverManager.getConnection(this.getURL()).createStatement();
        AbstractJdbcPojoQuerySelfTest.assertNotNull((Object)this.stmt);
        AbstractJdbcPojoQuerySelfTest.assertFalse((boolean)this.stmt.isClosed());
    }

    protected void afterTest() throws Exception {
        if (this.stmt != null) {
            this.stmt.getConnection().close();
            this.stmt.close();
            AbstractJdbcPojoQuerySelfTest.assertTrue((boolean)this.stmt.isClosed());
        }
    }

    protected void assertResultSet(ResultSet rs) throws Exception {
        AbstractJdbcPojoQuerySelfTest.assertNotNull((Object)rs);
        int cnt = 0;
        while (rs.next()) {
            AbstractJdbcPojoQuerySelfTest.assertNotNull((Object)rs.getString("id"));
            AbstractJdbcPojoQuerySelfTest.assertNotNull((Object)rs.getString("testObject"));
            AbstractJdbcPojoQuerySelfTest.assertTrue((boolean)rs.getObject("testObject").toString().contains("id=1"));
            AbstractJdbcPojoQuerySelfTest.assertTrue((boolean)rs.getObject("testObject").toString().contains("boolVal=true"));
            ++cnt;
        }
        AbstractJdbcPojoQuerySelfTest.assertEquals((int)1, (int)cnt);
    }

    protected abstract String getURL();
}

