/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest.protocols.tcp.redis;

import org.apache.ignite.internal.processors.rest.protocols.tcp.redis.RedisCommonAbstractTest;
import org.junit.Assert;
import org.junit.Test;
import redis.clients.jedis.Jedis;

public class RedisProtocolConnectSelfTest
extends RedisCommonAbstractTest {
    @Test
    public void testPing() throws Exception {
        try (Jedis jedis = pool.getResource();){
            Assert.assertEquals((Object)"PONG", (Object)jedis.ping());
        }
    }

    @Test
    public void testEcho() throws Exception {
        try (Jedis jedis = pool.getResource();){
            Assert.assertEquals((Object)"Hello, grid!", (Object)jedis.echo("Hello, grid!"));
        }
    }

    @Test
    public void testSelect() throws Exception {
        try (Jedis jedis = pool.getResource();){
            jedis.set("k0", "v0");
            Assert.assertEquals((Object)"v0", (Object)jedis.get("k0"));
            jedis.select(1);
            jedis.set("k1", "v1");
            Assert.assertEquals((Object)"v1", (Object)jedis.get("k1"));
            Assert.assertNull((Object)jedis.get("k0"));
            try (Jedis jedis2 = pool.getResource();){
                Assert.assertEquals((Object)"v0", (Object)jedis2.get("k0"));
                Assert.assertNull((Object)jedis2.get("k1"));
            }
            Assert.assertEquals((Object)"v1", (Object)jedis.get("k1"));
            Assert.assertNull((Object)jedis.get("k0"));
            jedis.select(0);
            Assert.assertEquals((Object)"v0", (Object)jedis.get("k0"));
        }
    }
}

