/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import junit.framework.TestCase;
import org.apache.ignite.internal.processors.rest.GridRestCommand;
import org.apache.ignite.internal.processors.rest.protocols.http.jetty.GridJettyObjectMapper;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.junit.Assert;

public class TestRestClient {
    public static final int DFLT_REST_PORT = 8091;
    private static final String LOC_HOST = "127.0.0.1";
    private static final ObjectMapper JSON_MAPPER = new GridJettyObjectMapper();
    private final Callable<String> signatureProvider;

    public TestRestClient() {
        this.signatureProvider = () -> null;
    }

    public TestRestClient(Callable<String> provider) {
        this.signatureProvider = provider;
    }

    public int restPort() {
        return 8091;
    }

    public String restUrl() {
        return "http://127.0.0.1:" + this.restPort() + "/ignite?";
    }

    public String content(Map<String, String> params) throws Exception {
        SB sb = new SB(this.restUrl());
        for (Map.Entry<String, String> e : params.entrySet()) {
            sb.a(e.getKey()).a('=').a(e.getValue()).a('&');
        }
        URL url = new URL(sb.toString());
        URLConnection conn = this.openConnection(url);
        InputStream in = conn.getInputStream();
        StringBuilder buf = new StringBuilder(256);
        try (LineNumberReader rdr = new LineNumberReader(new InputStreamReader(in, "UTF-8"));){
            String line = rdr.readLine();
            while (line != null) {
                buf.append(line);
                line = rdr.readLine();
            }
        }
        return buf.toString();
    }

    public URLConnection openConnection(URL url) throws Exception {
        URLConnection conn = url.openConnection();
        String signature = this.signature();
        if (signature != null) {
            conn.setRequestProperty("X-Signature", signature);
        }
        return conn;
    }

    public String content(String cacheName, GridRestCommand cmd, String ... params) throws Exception {
        LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
        if (cacheName != null) {
            paramsMap.put("cacheName", cacheName);
        }
        paramsMap.put("cmd", cmd.key());
        if (params != null) {
            TestCase.assertEquals((int)0, (int)(params.length % 2));
            for (int i = 0; i < params.length; i += 2) {
                paramsMap.put(params[i], params[i + 1]);
            }
        }
        return this.content(paramsMap);
    }

    public String jsonField(String json, String field) throws IOException {
        Assert.assertNotNull((Object)json);
        Assert.assertFalse((boolean)json.isEmpty());
        JsonNode node = JSON_MAPPER.readTree(json);
        JsonNode fld = node.get(field);
        Assert.assertNotNull((Object)fld);
        return fld.asText();
    }

    private String signature() throws Exception {
        return this.signatureProvider.call();
    }
}

