/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import java.util.Map;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.processors.rest.GridRestProcessor;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class RestProcessorMultiStartSelfTest
extends GridCommonAbstractTest {
    private static final int GRID_CNT = 3;
    private static boolean client = false;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        cfg.setClientMode(client);
        return cfg;
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        client = false;
    }

    @Test
    public void testMultiStart() throws Exception {
        try {
            for (int i = 0; i < 3; ++i) {
                this.startGrid(i);
            }
            this.stopGrid(0);
        }
        finally {
            this.stopAllGrids();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiStartWithClient() throws Exception {
        try {
            int clnIdx = 2;
            for (int i = 0; i < clnIdx; ++i) {
                this.startGrid(i);
                GridRestProcessor rest = this.grid(i).context().rest();
                RestProcessorMultiStartSelfTest.assertNotNull((Object)rest);
                RestProcessorMultiStartSelfTest.assertFalse((boolean)((Map)GridTestUtils.getFieldValue((Object)rest, (String[])new String[]{"handlers"})).isEmpty());
            }
            client = true;
            this.startGrid(clnIdx);
            GridRestProcessor rest = this.grid(2).context().rest();
            RestProcessorMultiStartSelfTest.assertNotNull((Object)rest);
            RestProcessorMultiStartSelfTest.assertTrue((boolean)((Map)GridTestUtils.getFieldValue((Object)rest, (String[])new String[]{"handlers"})).isEmpty());
        }
        finally {
            this.stopAllGrids();
        }
    }
}

