/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.cache.configuration.Factory;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.testframework.junits.WithSystemProperty;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.junit.Test;
import org.xml.sax.SAXException;

public class JettyRestProcessorCustomInitializationTest
extends GridCommonAbstractTest {
    private static final String JETTY_CFG_PATH = "modules/clients/src/test/resources/jetty/rest-jetty.xml";
    private static final int IGNITE_CUSTOM_JETTY_PORT = 8095;
    protected static final String LOC_HOST = "127.0.0.1";

    protected void beforeTest() throws Exception {
        this.cleanPersistenceDir();
        super.beforeTest();
    }

    protected void afterTest() throws Exception {
        this.stopAllGrids();
        this.cleanPersistenceDir();
        super.afterTest();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setLocalHost(LOC_HOST);
        assert (cfg.getConnectorConfiguration() == null);
        ConnectorConfiguration clientCfg = new ConnectorConfiguration();
        clientCfg.setJettyServerFactory((Factory)new JettyServerFactory());
        cfg.setConnectorConfiguration(clientCfg);
        cfg.setCacheConfiguration(new CacheConfiguration[]{JettyRestProcessorCustomInitializationTest.defaultCacheConfiguration()});
        return cfg;
    }

    @Test
    @WithSystemProperty(key="IGNITE_JETTY_PORT", value="8095")
    public void testCustomFactory() throws Exception {
        this.startGrid(0);
        String addr = "http://127.0.0.1:8095/ignite?cacheName=default&cmd=top";
        URL url = new URL(addr);
        URLConnection conn = url.openConnection();
        conn.connect();
        JettyRestProcessorCustomInitializationTest.assertEquals((int)200, (int)((HttpURLConnection)conn).getResponseCode());
    }

    private static class JettyServerFactory
    implements Factory<Server> {
        private static final long serialVersionUID = 0L;

        private JettyServerFactory() {
        }

        public Server create() {
            XmlConfiguration cfg;
            log.info(">>>>> Using custom Jetty server initialization.");
            URL cfgUrl = U.resolveIgniteUrl((String)JettyRestProcessorCustomInitializationTest.JETTY_CFG_PATH);
            try {
                cfg = new XmlConfiguration(Resource.newResource((URL)cfgUrl));
            }
            catch (FileNotFoundException e) {
                throw new IgniteSpiException("Failed to find configuration file: " + cfgUrl, (Throwable)e);
            }
            catch (SAXException e) {
                throw new IgniteSpiException("Failed to parse configuration file: " + cfgUrl, (Throwable)e);
            }
            catch (IOException e) {
                throw new IgniteSpiException("Failed to load configuration file: " + cfgUrl, (Throwable)e);
            }
            catch (Exception e) {
                throw new IgniteSpiException("Failed to start HTTP server with configuration file: " + cfgUrl, (Throwable)e);
            }
            try {
                return (Server)cfg.configure();
            }
            catch (Exception e) {
                throw new IgniteException("Failed to start Jetty HTTP server.", (Throwable)e);
            }
        }
    }
}

