/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.rest;

import java.util.Collections;
import java.util.UUID;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientClusterState;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class ChangeStateCommandHandlerTest
extends GridCommonAbstractTest {
    public static final String HOST = "127.0.0.1";
    public static final int BINARY_PORT = 11212;
    private GridClient client;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        cfg.setLocalHost(HOST);
        ConnectorConfiguration clientCfg = new ConnectorConfiguration();
        clientCfg.setPort(11212);
        cfg.setConnectorConfiguration(clientCfg);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrid(0);
        this.startGrid(1);
    }

    protected void beforeTest() throws Exception {
        GridClientConfiguration cfg = new GridClientConfiguration();
        cfg.setProtocol(GridClientProtocol.TCP);
        cfg.setServers(Collections.singletonList("localhost:11212"));
        this.client = GridClientFactory.start((GridClientConfiguration)cfg);
    }

    protected void afterTest() throws Exception {
        GridClientFactory.stop((UUID)this.client.id());
    }

    @Test
    public void testActivateDeActivate() throws GridClientException {
        GridClientClusterState state = this.client.state();
        boolean active = state.active();
        ChangeStateCommandHandlerTest.assertTrue((boolean)active);
        state.active(false);
        IgniteEx ig1 = this.grid(0);
        IgniteEx ig2 = this.grid(1);
        ChangeStateCommandHandlerTest.assertFalse((boolean)ig1.active());
        ChangeStateCommandHandlerTest.assertFalse((boolean)ig2.active());
        ChangeStateCommandHandlerTest.assertFalse((boolean)state.active());
        state.active(true);
        ChangeStateCommandHandlerTest.assertTrue((boolean)ig1.active());
        ChangeStateCommandHandlerTest.assertTrue((boolean)ig2.active());
        ChangeStateCommandHandlerTest.assertTrue((boolean)state.active());
    }
}

