/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.util.Collections;
import java.util.Properties;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.vm.TcpDiscoveryVmIpFinder;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class JdbcNoCacheStreamingSelfTest
extends GridCommonAbstractTest {
    private static final String BASE_URL = "jdbc:ignite:cfg://cache=default@modules/clients/src/test/config/jdbc-config.xml";
    protected Connection conn;
    protected transient IgniteLogger log;

    protected IgniteConfiguration getConfiguration(String gridName) throws Exception {
        return this.getConfiguration0(gridName);
    }

    private IgniteConfiguration getConfiguration0(String gridName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(gridName);
        CacheConfiguration cache = JdbcNoCacheStreamingSelfTest.defaultCacheConfiguration();
        cache.setCacheMode(CacheMode.PARTITIONED);
        cache.setBackups(1);
        cache.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        cache.setIndexedTypes(new Class[]{Integer.class, Integer.class});
        cfg.setCacheConfiguration(new CacheConfiguration[]{cache});
        cfg.setLocalHost("127.0.0.1");
        TcpDiscoverySpi disco = new TcpDiscoverySpi();
        TcpDiscoveryVmIpFinder ipFinder = new TcpDiscoveryVmIpFinder(true);
        ipFinder.setAddresses(Collections.singleton("127.0.0.1:47500..47501"));
        disco.setIpFinder((TcpDiscoveryIpFinder)ipFinder);
        cfg.setDiscoverySpi((DiscoverySpi)disco);
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGrids(2);
    }

    protected Connection createConnection(boolean allowOverwrite) throws Exception {
        Properties props = new Properties();
        props.setProperty("ignite.jdbc.streaming", "true");
        props.setProperty("ignite.jdbc.streamingFlushFrequency", "500");
        if (allowOverwrite) {
            props.setProperty("ignite.jdbc.streamingAllowOverwrite", "true");
        }
        return DriverManager.getConnection(BASE_URL, props);
    }

    protected void afterTest() throws Exception {
        U.closeQuiet((AutoCloseable)this.conn);
        this.ignite(0).cache("default").clear();
        super.afterTest();
    }

    @Test
    public void testStreamedInsert() throws Exception {
        for (int i = 10; i <= 100; i += 10) {
            this.ignite(0).cache("default").put((Object)i, (Object)(i * 100));
        }
        try (Connection conn = this.createConnection(false);
             PreparedStatement stmt = conn.prepareStatement("insert into Integer(_key, _val) values (?, ?)");){
            for (int i = 1; i <= 100; ++i) {
                stmt.setInt(1, i);
                stmt.setInt(2, i);
                stmt.executeUpdate();
            }
        }
        U.sleep((long)500L);
        for (int i = 1; i <= 100; ++i) {
            if (i % 10 != 0) {
                JdbcNoCacheStreamingSelfTest.assertEquals((Object)i, (Object)this.grid(0).cache("default").get((Object)i));
                continue;
            }
            JdbcNoCacheStreamingSelfTest.assertEquals((Object)(i * 100), (Object)this.grid(0).cache("default").get((Object)i));
        }
    }

    @Test
    public void testStreamedInsertWithOverwritesAllowed() throws Exception {
        for (int i = 10; i <= 100; i += 10) {
            this.ignite(0).cache("default").put((Object)i, (Object)(i * 100));
        }
        try (Connection conn = this.createConnection(true);
             PreparedStatement stmt = conn.prepareStatement("insert into Integer(_key, _val) values (?, ?)");){
            for (int i = 1; i <= 100; ++i) {
                stmt.setInt(1, i);
                stmt.setInt(2, i);
                stmt.executeUpdate();
            }
        }
        U.sleep((long)500L);
        for (int i = 1; i <= 100; ++i) {
            JdbcNoCacheStreamingSelfTest.assertEquals((Object)i, (Object)this.grid(0).cache("default").get((Object)i));
        }
    }
}

