/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.query.SqlFieldsQuery;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.EntryCompressionConfiguration;
import org.apache.ignite.configuration.NearCacheConfiguration;
import org.apache.ignite.internal.jdbc2.JdbcAbstractDmlStatementSelfTest;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.testframework.GridTestUtils;
import org.junit.Test;

public abstract class JdbcDynamicIndexAbstractSelfTest
extends JdbcAbstractDmlStatementSelfTest {
    private static final String CREATE_INDEX = "create index idx on Person (id desc)";
    private static final String DROP_INDEX = "drop index idx";
    private static final String CREATE_INDEX_IF_NOT_EXISTS = "create index if not exists idx on Person (id desc)";
    private static final String DROP_INDEX_IF_EXISTS = "drop index idx if exists";

    @Override
    protected void beforeTest() throws Exception {
        super.beforeTest();
        try (PreparedStatement ps = this.conn.prepareStatement("INSERT INTO Person (_key, id, age, firstName, lastName) values (?, ?, ?, ?, ?)");){
            ps.setString(1, "j");
            ps.setInt(2, 1);
            ps.setInt(3, 10);
            ps.setString(4, "John");
            ps.setString(5, "Smith");
            ps.executeUpdate();
            ps.setString(1, "m");
            ps.setInt(2, 2);
            ps.setInt(3, 20);
            ps.setString(4, "Mark");
            ps.setString(5, "Stone");
            ps.executeUpdate();
            ps.setString(1, "s");
            ps.setInt(2, 3);
            ps.setInt(3, 30);
            ps.setString(4, "Sarah");
            ps.setString(5, "Pazzi");
            ps.executeUpdate();
        }
    }

    @Override
    CacheConfiguration cacheConfig() {
        CacheConfiguration ccfg = super.cacheConfig();
        ccfg.setWriteSynchronizationMode(CacheWriteSynchronizationMode.FULL_SYNC);
        ccfg.setCacheMode(this.cacheMode());
        ccfg.setAtomicityMode(this.atomicityMode());
        ccfg.setEntryCompressionConfiguration(this.entryCompressionConfiguration());
        if (this.nearCache()) {
            ccfg.setNearConfiguration(new NearCacheConfiguration());
        }
        return ccfg;
    }

    protected abstract CacheMode cacheMode();

    protected abstract CacheAtomicityMode atomicityMode();

    protected abstract boolean nearCache();

    protected EntryCompressionConfiguration entryCompressionConfiguration() {
        return null;
    }

    private void jdbcRun(String sql) throws SQLException {
        try (Statement stmt = this.conn.createStatement();){
            stmt.execute(sql);
        }
    }

    private Object getSingleValue(ResultSet rs) throws SQLException {
        JdbcDynamicIndexAbstractSelfTest.assertEquals((int)1, (int)rs.getMetaData().getColumnCount());
        JdbcDynamicIndexAbstractSelfTest.assertTrue((boolean)rs.next());
        Object res = rs.getObject(1);
        JdbcDynamicIndexAbstractSelfTest.assertTrue((boolean)rs.isLast());
        return res;
    }

    @Test
    public void testCreateIndex() throws SQLException {
        this.assertSize(3L);
        this.assertColumnValues(30, 20, 10);
        this.jdbcRun(CREATE_INDEX);
        for (int i = 0; i < 3; ++i) {
            List locRes = this.ignite(i).cache("default").query(new SqlFieldsQuery("explain select id from Person where id = 5").setLocal(true)).getAll();
            JdbcDynamicIndexAbstractSelfTest.assertEquals((Object)F.asList(Collections.singletonList("SELECT\n    \"ID\"\nFROM \"default\".\"PERSON\"\n    /* default.IDX: ID = 5 */\nWHERE \"ID\" = 5")), (Object)locRes);
        }
        this.assertSize(3L);
        this.assertColumnValues(30, 20, 10);
    }

    @Test
    public void testCreateIndexWithDuplicateName() throws SQLException {
        this.jdbcRun(CREATE_INDEX);
        JdbcDynamicIndexAbstractSelfTest.assertSqlException(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcDynamicIndexAbstractSelfTest.this.jdbcRun(JdbcDynamicIndexAbstractSelfTest.CREATE_INDEX);
            }
        });
    }

    @Test
    public void testCreateIndexIfNotExists() throws SQLException {
        this.jdbcRun(CREATE_INDEX);
        this.jdbcRun(CREATE_INDEX_IF_NOT_EXISTS);
    }

    @Test
    public void testDropIndex() throws SQLException {
        this.assertSize(3L);
        this.jdbcRun(CREATE_INDEX);
        this.assertSize(3L);
        this.jdbcRun(DROP_INDEX);
        for (int i = 0; i < 3; ++i) {
            List locRes = this.ignite(i).cache("default").query(new SqlFieldsQuery("explain select id from Person where id = 5").setLocal(true)).getAll();
            JdbcDynamicIndexAbstractSelfTest.assertEquals((Object)F.asList(Collections.singletonList("SELECT\n    \"ID\"\nFROM \"default\".\"PERSON\"\n    /* default.PERSON.__SCAN_ */\nWHERE \"ID\" = 5")), (Object)locRes);
        }
        this.assertSize(3L);
    }

    @Test
    public void testDropMissingIndex() {
        JdbcDynamicIndexAbstractSelfTest.assertSqlException(new GridTestUtils.RunnableX(){

            public void runx() throws Exception {
                JdbcDynamicIndexAbstractSelfTest.this.jdbcRun(JdbcDynamicIndexAbstractSelfTest.DROP_INDEX);
            }
        });
    }

    @Test
    public void testDropMissingIndexIfExists() throws SQLException {
        this.jdbcRun(DROP_INDEX_IF_EXISTS);
    }

    @Test
    public void testIndexState() throws SQLException {
        IgniteCache<String, JdbcAbstractDmlStatementSelfTest.Person> cache = this.cache();
        this.assertSize(3L);
        this.assertColumnValues(30, 20, 10);
        this.jdbcRun(CREATE_INDEX);
        this.assertSize(3L);
        this.assertColumnValues(30, 20, 10);
        cache.remove((Object)"m");
        this.assertColumnValues(30, 10);
        cache.put((Object)"a", (Object)new JdbcAbstractDmlStatementSelfTest.Person(4, "someVal", "a", 5));
        this.assertColumnValues(5, 30, 10);
        this.jdbcRun(DROP_INDEX);
        this.assertColumnValues(5, 30, 10);
    }

    private void assertColumnValues(int ... vals) throws SQLException {
        try (Statement stmt = this.conn.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT age FROM Person ORDER BY id desc");){
            JdbcDynamicIndexAbstractSelfTest.assertEquals((int)1, (int)rs.getMetaData().getColumnCount());
            for (int i = 0; i < vals.length; ++i) {
                JdbcDynamicIndexAbstractSelfTest.assertTrue((String)("Result set must have " + vals.length + " rows, got " + i), (boolean)rs.next());
                JdbcDynamicIndexAbstractSelfTest.assertEquals((int)vals[i], (int)rs.getInt(1));
            }
            JdbcDynamicIndexAbstractSelfTest.assertFalse((String)("Result set must have exactly " + vals.length + " rows"), (boolean)rs.next());
        }
    }

    private void assertSize(long expSize) throws SQLException {
        JdbcDynamicIndexAbstractSelfTest.assertEquals((long)expSize, (long)this.cache().size(new CachePeekMode[0]));
        try (Statement stmt = this.conn.createStatement();
             ResultSet rs = stmt.executeQuery("SELECT COUNT(*) from Person");){
            JdbcDynamicIndexAbstractSelfTest.assertEquals((Object)expSize, (Object)this.getSingleValue(rs));
        }
    }

    private IgniteCache<String, JdbcAbstractDmlStatementSelfTest.Person> cache() {
        return this.grid(0).cache("default");
    }

    private static void assertSqlException(GridTestUtils.RunnableX r) {
        try {
            r.runx();
        }
        catch (SQLException e) {
            return;
        }
        catch (Exception e) {
            JdbcDynamicIndexAbstractSelfTest.fail((String)("Unexpected exception: " + e));
        }
        JdbcDynamicIndexAbstractSelfTest.fail((String)(SQLException.class.getSimpleName() + " is not thrown."));
    }
}

