/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.router;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTaskSplitAdapter;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.apache.ignite.internal.client.GridServerUnreachableException;
import org.apache.ignite.internal.client.impl.connection.GridClientConnectionResetException;
import org.apache.ignite.internal.client.router.GridRouterFactory;
import org.apache.ignite.internal.client.router.GridTcpRouterConfiguration;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class ClientFailedInitSelfTest
extends GridCommonAbstractTest {
    private static final int RECONN_CNT = 3;
    private static final long TOP_REFRESH_PERIOD = 5000L;
    private static final int ROUTER_BINARY_PORT = 11213;
    private static final int ROUTER_JETTY_PORT = 8081;

    protected void afterTest() throws Exception {
        GridClientFactory.stopAll();
        GridRouterFactory.stopAllRouters();
        this.stopAllGrids();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        assert (cfg.getConnectorConfiguration() == null);
        cfg.setLocalHost("127.0.0.1");
        ConnectorConfiguration clientCfg = new ConnectorConfiguration();
        clientCfg.setPort(11212);
        clientCfg.setJettyPath("modules/clients/src/test/resources/jetty/rest-jetty.xml");
        cfg.setConnectorConfiguration(clientCfg);
        return cfg;
    }

    @Test
    public void testEmptyAddresses() {
        try {
            GridClientFactory.start((GridClientConfiguration)new GridClientConfiguration());
            assert (false);
        }
        catch (GridClientException e) {
            this.info("Caught expected exception: " + (Object)((Object)e));
        }
    }

    @Test
    public void testRoutersAndServersAddressesProvided() {
        try {
            GridClientConfiguration c = new GridClientConfiguration();
            c.setRouters(Collections.singleton("127.0.0.1:10000"));
            c.setServers(Collections.singleton("127.0.0.1:10000"));
            GridClientFactory.start((GridClientConfiguration)c);
            assert (false);
        }
        catch (GridClientException e) {
            this.info("Caught expected exception: " + (Object)((Object)e));
        }
    }

    @Test
    public void testTcpClient() throws Exception {
        this.doTestClient(GridClientProtocol.TCP);
    }

    @Test
    public void testTcpRouter() throws Exception {
        this.doTestRouter(GridClientProtocol.TCP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestClient(GridClientProtocol p) throws Exception {
        GridClient c = this.client(p, false);
        for (int i = 0; i < 3; ++i) {
            try {
                c.compute().nodes();
            }
            catch (GridClientDisconnectedException e) {
                ClientFailedInitSelfTest.assertTrue((boolean)X.hasCause((Throwable)e, (Class[])new Class[]{GridServerUnreachableException.class, GridClientConnectionResetException.class}));
            }
            this.startGrid();
            try {
                Thread.sleep(10000L);
                c.compute().nodes();
                ClientFailedInitSelfTest.assertEquals((String)"arg", (String)((String)c.compute().execute(TestTask.class.getName(), (Object)"arg")));
            }
            finally {
                this.stopGrid();
            }
            Thread.sleep(10000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTestRouter(GridClientProtocol p) throws Exception {
        this.startRouters();
        GridClient c = this.client(p, true);
        for (int i = 0; i < 3; ++i) {
            try {
                c.compute().nodes();
                ClientFailedInitSelfTest.fail((String)"Nodes list should fail while grid is stopped.");
            }
            catch (GridClientDisconnectedException e) {
                ClientFailedInitSelfTest.assertTrue((boolean)X.hasCause((Throwable)e, (Class[])new Class[]{GridClientException.class}));
            }
            this.startGrid();
            try {
                Thread.sleep(10000L);
                c.compute().nodes();
                ClientFailedInitSelfTest.assertEquals((String)"arg", (String)((String)c.compute().execute(TestTask.class.getName(), (Object)"arg")));
            }
            finally {
                this.stopGrid();
            }
            Thread.sleep(10000L);
        }
    }

    protected IgniteEx startGrid() throws Exception {
        System.setProperty("IGNITE_JETTY_PORT", Integer.toString(8080));
        try {
            IgniteEx igniteEx = super.startGrid();
            return igniteEx;
        }
        finally {
            System.clearProperty("IGNITE_JETTY_PORT");
        }
    }

    private void startRouters() throws IgniteCheckedException {
        GridTcpRouterConfiguration tcpCfg = new GridTcpRouterConfiguration();
        tcpCfg.setHost("127.0.0.1");
        tcpCfg.setPort(11213);
        tcpCfg.setPortRange(0);
        tcpCfg.setServers(Collections.singleton("127.0.0.1:11212"));
        GridRouterFactory.startTcpRouter((GridTcpRouterConfiguration)tcpCfg);
    }

    private GridClient client(GridClientProtocol p, boolean useRouter) throws GridClientException {
        GridClientConfiguration cfg = new GridClientConfiguration();
        int port = p == GridClientProtocol.TCP ? (useRouter ? 11213 : 11212) : (useRouter ? 8081 : 8080);
        cfg.setProtocol(p);
        cfg.setServers(Arrays.asList("127.0.0.1:" + port));
        cfg.setTopologyRefreshFrequency(5000L);
        return GridClientFactory.start((GridClientConfiguration)cfg);
    }

    private static class TestTask
    extends ComputeTaskSplitAdapter<String, String> {
        private TestTask() {
        }

        protected Collection<? extends ComputeJob> split(int gridSize, final String arg) {
            return Collections.singleton(new ComputeJobAdapter(){

                public String execute() {
                    return arg;
                }
            });
        }

        public String reduce(List<ComputeJobResult> results) {
            ClientFailedInitSelfTest.assertEquals((int)1, (int)results.size());
            return (String)results.get(0).getData();
        }
    }
}

