/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.integration;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.client.GridClientCacheMode;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientNodeMetrics;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.apache.ignite.internal.client.GridClientTopologyListener;
import org.apache.ignite.internal.client.balancer.GridClientLoadBalancer;
import org.apache.ignite.internal.client.integration.ClientTcpMultiNodeSelfTest;
import org.apache.ignite.internal.util.typedef.F;

public class ClientTcpUnreachableMultiNodeSelfTest
extends ClientTcpMultiNodeSelfTest {
    @Override
    protected GridClientLoadBalancer getBalancer() {
        GridClientLoadBalancer b = super.getBalancer();
        return new TestGridClientLoadBalancer(b);
    }

    @Override
    protected GridClientConfiguration clientConfiguration() throws GridClientException {
        GridClientConfiguration cfg = super.clientConfiguration();
        cfg.setConnectTimeout(100);
        return cfg;
    }

    private class TestGridClientLoadBalancer
    implements GridClientLoadBalancer,
    GridClientTopologyListener {
        private final GridClientLoadBalancer b;

        TestGridClientLoadBalancer(GridClientLoadBalancer b) {
            this.b = b;
        }

        public GridClientNode balancedNode(Collection<? extends GridClientNode> nodes) throws GridClientException {
            final GridClientNode node = this.b.balancedNode(nodes);
            return new GridClientNode(){

                public <T> T attribute(String name) {
                    return (T)node.attribute(name);
                }

                public Map<String, Object> attributes() {
                    return node.attributes();
                }

                public Collection<InetSocketAddress> availableAddresses(GridClientProtocol proto, boolean filterResolved) {
                    return F.asList((Object[])new InetSocketAddress[]{new InetSocketAddress("172.22.13.13", 65432), (InetSocketAddress)F.first((Iterable)node.availableAddresses(proto, filterResolved))});
                }

                public Map<String, GridClientCacheMode> caches() {
                    return node.caches();
                }

                public List<String> tcpAddresses() {
                    return node.tcpAddresses();
                }

                public List<String> tcpHostNames() {
                    return node.tcpHostNames();
                }

                public GridClientNodeMetrics metrics() {
                    return node.metrics();
                }

                public UUID nodeId() {
                    return node.nodeId();
                }

                public Object consistentId() {
                    return node.consistentId();
                }

                public int tcpPort() {
                    return node.tcpPort();
                }

                public boolean connectable() {
                    return node.connectable();
                }

                public long order() {
                    return node.order();
                }

                public boolean isClient() {
                    return node.isClient();
                }

                public boolean isDaemon() {
                    return node.isDaemon();
                }

                public boolean supports(IgniteFeatures feature) {
                    return node.supports(feature);
                }
            };
        }

        public void onNodeAdded(GridClientNode node) {
            if (this.b instanceof GridClientTopologyListener) {
                ((GridClientTopologyListener)this.b).onNodeAdded(node);
            }
        }

        public void onNodeRemoved(GridClientNode node) {
            if (this.b instanceof GridClientTopologyListener) {
                ((GridClientTopologyListener)this.b).onNodeRemoved(node);
            }
        }
    }
}

