/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client.integration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.CacheAtomicityMode;
import org.apache.ignite.cache.CacheMode;
import org.apache.ignite.cache.CacheWriteSynchronizationMode;
import org.apache.ignite.cache.affinity.AffinityFunction;
import org.apache.ignite.cache.affinity.rendezvous.RendezvousAffinityFunction;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTaskSplitAdapter;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientCompute;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDataAffinity;
import org.apache.ignite.internal.client.GridClientDataConfiguration;
import org.apache.ignite.internal.client.GridClientException;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.client.GridClientPartitionAffinity;
import org.apache.ignite.internal.client.GridClientPredicate;
import org.apache.ignite.internal.client.GridClientProtocol;
import org.apache.ignite.internal.client.GridClientTopologyListener;
import org.apache.ignite.internal.client.balancer.GridClientLoadBalancer;
import org.apache.ignite.internal.client.balancer.GridClientRoundRobinBalancer;
import org.apache.ignite.internal.client.ssl.GridSslContextFactory;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedLockRequest;
import org.apache.ignite.internal.processors.cache.transactions.IgniteInternalTx;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxLocalAdapter;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxManager;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersionable;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public abstract class ClientAbstractMultiNodeSelfTest
extends GridCommonAbstractTest {
    private static final String PARTITIONED_CACHE_NAME = "partitioned";
    private static final String REPLICATED_CACHE_NAME = "replicated";
    private static final String REPLICATED_ASYNC_CACHE_NAME = "replicated_async";
    public static final int NODES_CNT = 5;
    static final int TOP_REFRESH_FREQ = 2500;
    public static final String HOST = "127.0.0.1";
    public static final int REST_TCP_PORT_BASE = 12345;
    private static volatile boolean commSpiEnabled;
    private boolean restEnabled = true;
    private GridClient client;

    protected abstract GridClientProtocol protocol();

    protected abstract String serverAddress();

    @Nullable
    protected GridSslContextFactory sslContextFactory() {
        return null;
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(igniteInstanceName);
        c.setLocalHost(HOST);
        assert (c.getConnectorConfiguration() == null);
        if (this.restEnabled) {
            ConnectorConfiguration clientCfg = new ConnectorConfiguration();
            clientCfg.setPort(12345);
            GridSslContextFactory sslCtxFactory = this.sslContextFactory();
            if (sslCtxFactory != null) {
                clientCfg.setSslEnabled(true);
                clientCfg.setSslContextFactory(sslCtxFactory);
            }
            c.setConnectorConfiguration(clientCfg);
        }
        TestCommunicationSpi spi = new TestCommunicationSpi();
        spi.setLocalPort(GridTestUtils.getNextCommPort(((Object)((Object)this)).getClass()));
        c.setCommunicationSpi((CommunicationSpi)spi);
        c.setCacheConfiguration(new CacheConfiguration[]{this.cacheConfiguration("default"), this.cacheConfiguration(PARTITIONED_CACHE_NAME), this.cacheConfiguration(REPLICATED_CACHE_NAME), this.cacheConfiguration(REPLICATED_ASYNC_CACHE_NAME)});
        c.setPublicThreadPoolSize(40);
        c.setSystemThreadPoolSize(40);
        return c;
    }

    private CacheConfiguration cacheConfiguration(@NotNull String cacheName) throws Exception {
        CacheConfiguration cfg = ClientAbstractMultiNodeSelfTest.defaultCacheConfiguration();
        cfg.setAtomicityMode(CacheAtomicityMode.TRANSACTIONAL);
        switch (cacheName) {
            case "default": {
                cfg.setCacheMode(CacheMode.LOCAL);
                break;
            }
            case "partitioned": {
                cfg.setCacheMode(CacheMode.PARTITIONED);
                cfg.setBackups(0);
                break;
            }
            default: {
                cfg.setCacheMode(CacheMode.REPLICATED);
            }
        }
        cfg.setName(cacheName);
        cfg.setWriteSynchronizationMode(REPLICATED_ASYNC_CACHE_NAME.equals(cacheName) ? CacheWriteSynchronizationMode.FULL_ASYNC : CacheWriteSynchronizationMode.FULL_SYNC);
        cfg.setAffinity((AffinityFunction)new RendezvousAffinityFunction());
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        this.startGridsMultiThreaded(5);
    }

    protected void beforeTest() throws Exception {
        this.client = GridClientFactory.start((GridClientConfiguration)this.clientConfiguration());
    }

    protected void afterTest() throws Exception {
        if (this.client != null) {
            GridClientFactory.stop((UUID)this.client.id(), (boolean)false);
            this.client = null;
        }
    }

    @Test
    public void testEmptyProjections() throws Exception {
        GridClientCompute dflt = this.client.compute();
        Collection nodes = dflt.nodes();
        ClientAbstractMultiNodeSelfTest.assertEquals((int)5, (int)nodes.size());
        Iterator iter = nodes.iterator();
        final GridClientCompute singleNodePrj = dflt.projection(Collections.singletonList(iter.next()));
        final GridClientNode second = (GridClientNode)iter.next();
        GridClientPredicate<GridClientNode> targetFilter = new GridClientPredicate<GridClientNode>(){

            public boolean apply(GridClientNode node) {
                return node.nodeId().equals(second.nodeId());
            }
        };
        GridTestUtils.assertThrows((IgniteLogger)this.log(), (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return singleNodePrj.projection(second);
            }
        }, GridClientException.class, null);
        GridTestUtils.assertThrows((IgniteLogger)this.log(), (Callable)new Callable<Object>((GridClientPredicate)targetFilter){
            final /* synthetic */ GridClientPredicate val$targetFilter;
            {
                this.val$targetFilter = gridClientPredicate;
            }

            @Override
            public Object call() throws Exception {
                return singleNodePrj.projection(this.val$targetFilter);
            }
        }, GridClientException.class, null);
    }

    @Test
    public void testProjectionRun() throws Exception {
        GridClientCompute dflt = this.client.compute();
        Collection nodes = dflt.nodes();
        ClientAbstractMultiNodeSelfTest.assertEquals((int)5, (int)nodes.size());
        for (int i = 0; i < 5; ++i) {
            IgniteEx g = this.grid(i);
            assert (g != null);
            GridClientNode clientNode = dflt.node(g.cluster().localNode().id());
            ClientAbstractMultiNodeSelfTest.assertNotNull((String)("Client node for " + g.cluster().localNode().id() + " was not found"), (Object)clientNode);
            GridClientCompute prj = dflt.projection(clientNode);
            String res = (String)prj.execute(TestTask.class.getName(), null);
            ClientAbstractMultiNodeSelfTest.assertNotNull((Object)res);
            ClientAbstractMultiNodeSelfTest.assertEquals((String)g.cluster().localNode().id().toString(), (String)res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTopologyListener() throws Exception {
        final ArrayList added = new ArrayList(1);
        final ArrayList rmvd = new ArrayList(1);
        final CountDownLatch addedLatch = new CountDownLatch(1);
        final CountDownLatch rmvLatch = new CountDownLatch(1);
        ClientAbstractMultiNodeSelfTest.assertEquals((int)5, (int)this.client.compute().refreshTopology(false, false).size());
        GridClientTopologyListener lsnr = new GridClientTopologyListener(){

            public void onNodeAdded(GridClientNode node) {
                added.add(node.nodeId());
                addedLatch.countDown();
            }

            public void onNodeRemoved(GridClientNode node) {
                rmvd.add(node.nodeId());
                rmvLatch.countDown();
            }
        };
        this.client.addTopologyListener(lsnr);
        try {
            IgniteEx g = this.startGrid(6);
            UUID id = g.cluster().localNode().id();
            ClientAbstractMultiNodeSelfTest.assertTrue((boolean)addedLatch.await(5000L, TimeUnit.MILLISECONDS));
            ClientAbstractMultiNodeSelfTest.assertEquals((int)1, (int)added.size());
            ClientAbstractMultiNodeSelfTest.assertEquals((Object)id, (Object)F.first(added));
            this.stopGrid(6);
            ClientAbstractMultiNodeSelfTest.assertTrue((boolean)rmvLatch.await(5000L, TimeUnit.MILLISECONDS));
            ClientAbstractMultiNodeSelfTest.assertEquals((int)1, (int)rmvd.size());
            ClientAbstractMultiNodeSelfTest.assertEquals((Object)id, (Object)F.first(rmvd));
        }
        finally {
            this.client.removeTopologyListener(lsnr);
            this.stopGrid(6);
        }
    }

    protected GridClientConfiguration clientConfiguration() throws GridClientException {
        GridClientConfiguration cfg = new GridClientConfiguration();
        cfg.setBalancer(this.getBalancer());
        cfg.setTopologyRefreshFrequency(2500L);
        cfg.setProtocol(this.protocol());
        cfg.setServers(Arrays.asList(this.serverAddress()));
        cfg.setSslContextFactory(this.sslContextFactory());
        GridClientDataConfiguration loc = new GridClientDataConfiguration();
        GridClientDataConfiguration partitioned = new GridClientDataConfiguration();
        partitioned.setName(PARTITIONED_CACHE_NAME);
        partitioned.setAffinity((GridClientDataAffinity)new GridClientPartitionAffinity());
        GridClientDataConfiguration replicated = new GridClientDataConfiguration();
        replicated.setName(REPLICATED_CACHE_NAME);
        GridClientDataConfiguration replicatedAsync = new GridClientDataConfiguration();
        replicatedAsync.setName(REPLICATED_ASYNC_CACHE_NAME);
        cfg.setDataConfigurations(Arrays.asList(loc, partitioned, replicated, replicatedAsync));
        return cfg;
    }

    protected GridClientLoadBalancer getBalancer() {
        return new GridClientRoundRobinBalancer();
    }

    private static class TestCommunicationSpi
    extends TcpCommunicationSpi {
        private TestCommunicationSpi() {
        }

        public void sendMessage(ClusterNode node, Message msg, IgniteInClosure<IgniteException> ackC) throws IgniteSpiException {
            this.checkSyncFlags((GridIoMessage)msg);
            super.sendMessage(node, msg, ackC);
        }

        private void checkSyncFlags(GridIoMessage msg) {
            GridCacheVersion v;
            if (!commSpiEnabled) {
                return;
            }
            Message o = msg.message();
            if (!(o instanceof GridDistributedLockRequest)) {
                return;
            }
            IgniteKernal g = (IgniteKernal)G.ignite((UUID)this.ignite.configuration().getNodeId());
            GridCacheContext cacheCtx = g.internalCache(ClientAbstractMultiNodeSelfTest.REPLICATED_ASYNC_CACHE_NAME).context();
            IgniteTxManager tm = cacheCtx.tm();
            IgniteInternalTx t = tm.tx(v = ((GridCacheVersionable)o).version());
            if (t.hasWriteKey(cacheCtx.txKey(cacheCtx.toCacheKeyObject((Object)"x1")))) {
                ClientAbstractMultiNodeSelfTest.assertEquals((String)("Invalid tx flags: " + t), (Object)CacheWriteSynchronizationMode.FULL_ASYNC, (Object)((IgniteTxLocalAdapter)t).syncMode());
            } else if (t.hasWriteKey(cacheCtx.txKey(cacheCtx.toCacheKeyObject((Object)"x2")))) {
                ClientAbstractMultiNodeSelfTest.assertEquals((String)("Invalid tx flags: " + t), (Object)CacheWriteSynchronizationMode.FULL_SYNC, (Object)((IgniteTxLocalAdapter)t).syncMode());
            } else if (t.hasWriteKey(cacheCtx.txKey(cacheCtx.toCacheKeyObject((Object)"x3")))) {
                ClientAbstractMultiNodeSelfTest.assertEquals((String)("Invalid tx flags: " + t), (Object)CacheWriteSynchronizationMode.FULL_ASYNC, (Object)((IgniteTxLocalAdapter)t).syncMode());
            } else if (t.hasWriteKey(cacheCtx.txKey(cacheCtx.toCacheKeyObject((Object)"x4")))) {
                ClientAbstractMultiNodeSelfTest.assertEquals((String)("Invalid tx flags: " + t), (Object)CacheWriteSynchronizationMode.FULL_SYNC, (Object)((IgniteTxLocalAdapter)t).syncMode());
            }
        }
    }

    private static class TestTask
    extends ComputeTaskSplitAdapter<Object, String> {
        @IgniteInstanceResource
        private Ignite ignite;
        private int gridSize;

        private TestTask() {
        }

        protected Collection<? extends ComputeJob> split(int gridSize, Object arg) {
            ArrayList<1> jobs = new ArrayList<1>(gridSize);
            this.gridSize = gridSize;
            final String locNodeId = this.ignite.cluster().localNode().id().toString();
            for (int i = 0; i < gridSize; ++i) {
                jobs.add(new ComputeJobAdapter(){

                    public Object execute() {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ignored) {
                            Thread.currentThread().interrupt();
                        }
                        return new IgniteBiTuple((Object)locNodeId, (Object)1);
                    }
                });
            }
            return jobs;
        }

        public String reduce(List<ComputeJobResult> results) {
            int sum = 0;
            String locNodeId = null;
            for (ComputeJobResult res : results) {
                Integer i;
                IgniteBiTuple part = (IgniteBiTuple)res.getData();
                if (locNodeId == null) {
                    locNodeId = (String)part.get1();
                }
                if ((i = (Integer)part.get2()) == null) continue;
                sum += i.intValue();
            }
            assert (this.gridSize == sum);
            return locNodeId;
        }
    }
}

