/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.client;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientDisconnectedException;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.internal.client.GridServerUnreachableException;
import org.apache.ignite.internal.client.balancer.GridClientLoadBalancer;
import org.apache.ignite.internal.client.balancer.GridClientRoundRobinBalancer;
import org.apache.ignite.internal.client.impl.GridClientImpl;
import org.apache.ignite.internal.client.ssl.GridSslBasicContextFactory;
import org.apache.ignite.internal.client.ssl.GridSslContextFactory;
import org.apache.ignite.internal.util.typedef.G;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class ClientTcpSslAuthenticationSelfTest
extends GridCommonAbstractTest {
    private static final int REST_TCP_PORT = 12121;
    private MockX509TrustManager srvTrustMgr = new MockX509TrustManager();
    private MockX509TrustManager clientTrustMgr = new MockX509TrustManager();
    private volatile boolean checkClient;

    protected void afterTest() throws Exception {
        ClientTcpSslAuthenticationSelfTest.assertEquals((int)0, (int)this.srvTrustMgr.serverCheckCallCount());
        ClientTcpSslAuthenticationSelfTest.assertEquals((int)0, (int)this.clientTrustMgr.clientCheckCallCount());
    }

    protected void beforeTest() throws Exception {
        this.srvTrustMgr.reset();
        this.clientTrustMgr.reset();
    }

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration c = super.getConfiguration(igniteInstanceName);
        c.setLocalHost(this.getTestResources().getLocalHost());
        assert (c.getConnectorConfiguration() == null);
        ConnectorConfiguration clientCfg = new ConnectorConfiguration();
        clientCfg.setPort(12121);
        clientCfg.setSslEnabled(true);
        clientCfg.setSslClientAuth(this.checkClient);
        clientCfg.setSslClientAuth(this.checkClient);
        GridSslBasicContextFactory factory = (GridSslBasicContextFactory)GridTestUtils.sslContextFactory();
        factory.setTrustManagers(new TrustManager[]{this.srvTrustMgr});
        clientCfg.setSslContextFactory((GridSslContextFactory)factory);
        c.setConnectorConfiguration(clientCfg);
        return c;
    }

    private GridClientImpl createClient() throws Exception {
        GridClientConfiguration cfg = new GridClientConfiguration();
        cfg.setServers(Arrays.asList(U.getLocalHost().getHostAddress() + ":" + 12121));
        cfg.setBalancer((GridClientLoadBalancer)new GridClientRoundRobinBalancer());
        GridSslBasicContextFactory factory = (GridSslBasicContextFactory)GridTestUtils.sslContextFactory();
        factory.setTrustManagers(new TrustManager[]{this.clientTrustMgr});
        cfg.setSslContextFactory((GridSslContextFactory)factory);
        return (GridClientImpl)GridClientFactory.start((GridClientConfiguration)cfg);
    }

    @Test
    public void testServerAuthenticated() throws Exception {
        this.checkServerAuthenticatedByClient(false);
    }

    @Test
    public void testServerNotAuthenticatedByClient() throws Exception {
        try {
            this.checkServerAuthenticatedByClient(true);
        }
        catch (GridClientDisconnectedException e) {
            ClientTcpSslAuthenticationSelfTest.assertTrue((boolean)X.hasCause((Throwable)e, (Class[])new Class[]{GridServerUnreachableException.class}));
        }
    }

    @Test
    public void testClientAuthenticated() throws Exception {
        this.checkClientAuthenticatedByServer(false);
    }

    @Test
    public void testClientNotAuthenticated() throws Exception {
        try {
            this.checkServerAuthenticatedByClient(true);
        }
        catch (GridClientDisconnectedException e) {
            ClientTcpSslAuthenticationSelfTest.assertTrue((boolean)X.hasCause((Throwable)e, (Class[])new Class[]{GridServerUnreachableException.class}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkServerAuthenticatedByClient(boolean fail) throws Exception {
        this.checkClient = false;
        this.srvTrustMgr.shouldFail(false);
        this.clientTrustMgr.shouldFail(fail);
        this.startGrid();
        try (GridClientImpl c = this.createClient();){
            c.compute().refreshTopology(false, false);
        }
        finally {
            G.stopAll((boolean)false);
        }
        ClientTcpSslAuthenticationSelfTest.assertEquals((int)0, (int)this.srvTrustMgr.clientCheckCallCount());
        ClientTcpSslAuthenticationSelfTest.assertEquals((int)1, (int)this.clientTrustMgr.serverCheckCallCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkClientAuthenticatedByServer(boolean fail) throws Exception {
        this.checkClient = true;
        this.srvTrustMgr.shouldFail(fail);
        this.clientTrustMgr.shouldFail(false);
        this.startGrid();
        try (GridClientImpl c = this.createClient();){
            c.compute().refreshTopology(false, false);
        }
        finally {
            G.stopAll((boolean)false);
        }
        ClientTcpSslAuthenticationSelfTest.assertEquals((int)1, (int)this.srvTrustMgr.clientCheckCallCount());
        ClientTcpSslAuthenticationSelfTest.assertEquals((int)1, (int)this.clientTrustMgr.serverCheckCallCount());
    }

    private static class MockX509TrustManager
    implements X509TrustManager {
        private static final X509Certificate[] EMPTY = new X509Certificate[0];
        private volatile boolean shouldFail;
        private AtomicInteger clientCheckCallCnt = new AtomicInteger();
        private AtomicInteger srvCheckCallCnt = new AtomicInteger();

        private MockX509TrustManager() {
        }

        private void shouldFail(boolean shouldFail) {
            this.shouldFail = shouldFail;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            this.clientCheckCallCnt.incrementAndGet();
            if (this.shouldFail) {
                throw new CertificateException("Client check failed.");
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            this.srvCheckCallCnt.incrementAndGet();
            if (this.shouldFail) {
                throw new CertificateException("Server check failed.");
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return EMPTY;
        }

        public int clientCheckCallCount() {
            return this.clientCheckCallCnt.get();
        }

        public int serverCheckCallCount() {
            return this.srvCheckCallCnt.get();
        }

        public void reset() {
            this.shouldFail = false;
            this.clientCheckCallCnt.set(0);
            this.srvCheckCallCnt.set(0);
        }
    }
}

