/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.compute.ComputeJob;
import org.apache.ignite.compute.ComputeJobAdapter;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.compute.ComputeTask;
import org.apache.ignite.compute.ComputeTaskSplitAdapter;
import org.apache.ignite.compute.ComputeTaskTimeoutException;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.Event;
import org.apache.ignite.events.EventType;
import org.apache.ignite.events.TaskEvent;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientConfiguration;
import org.apache.ignite.internal.client.GridClientFactory;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.lang.IgniteRunnable;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

public class TaskEventSubjectIdSelfTest
extends GridCommonAbstractTest {
    private static final Collection<TaskEvent> evts = new ArrayList<TaskEvent>();
    private static CountDownLatch latch;
    private static UUID nodeId;
    private static GridClient client;

    protected IgniteConfiguration getConfiguration(String igniteInstanceName) throws Exception {
        IgniteConfiguration cfg = super.getConfiguration(igniteInstanceName);
        cfg.setConnectorConfiguration(new ConnectorConfiguration());
        cfg.setIncludeEventTypes(EventType.EVTS_ALL);
        return cfg;
    }

    protected void beforeTestsStarted() throws Exception {
        IgniteEx g = this.startGrid();
        g.events().localListen((IgnitePredicate)new IgnitePredicate<Event>(){

            public boolean apply(Event evt) {
                assert (evt instanceof TaskEvent);
                evts.add((TaskEvent)evt);
                latch.countDown();
                return true;
            }
        }, EventType.EVTS_TASK_EXECUTION);
        nodeId = g.cluster().localNode().id();
        GridClientConfiguration cfg = new GridClientConfiguration();
        cfg.setServers(Collections.singleton("127.0.0.1:11211"));
        client = GridClientFactory.start((GridClientConfiguration)cfg);
    }

    protected void afterTestsStopped() throws Exception {
        GridClientFactory.stop((UUID)client.id());
    }

    protected void beforeTest() throws Exception {
        evts.clear();
    }

    @Test
    public void testSimpleTask() throws Exception {
        latch = new CountDownLatch(3);
        this.grid().compute().execute((ComputeTask)new SimpleTask(), null);
        assert (latch.await(1000L, TimeUnit.MILLISECONDS));
        TaskEventSubjectIdSelfTest.assertEquals((int)3, (int)evts.size());
        Iterator<TaskEvent> it = evts.iterator();
        assert (it.hasNext());
        TaskEvent evt = it.next();
        assert (evt != null);
        TaskEventSubjectIdSelfTest.assertEquals((int)20, (int)evt.type());
        TaskEventSubjectIdSelfTest.assertEquals((Object)nodeId, (Object)evt.subjectId());
        assert (it.hasNext());
        evt = it.next();
        assert (evt != null);
        TaskEventSubjectIdSelfTest.assertEquals((int)25, (int)evt.type());
        TaskEventSubjectIdSelfTest.assertEquals((Object)nodeId, (Object)evt.subjectId());
        assert (it.hasNext());
        evt = it.next();
        assert (evt != null);
        TaskEventSubjectIdSelfTest.assertEquals((int)21, (int)evt.type());
        TaskEventSubjectIdSelfTest.assertEquals((Object)nodeId, (Object)evt.subjectId());
        assert (!it.hasNext());
    }

    @Test
    public void testFailedTask() throws Exception {
        latch = new CountDownLatch(2);
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                TaskEventSubjectIdSelfTest.this.grid().compute().execute((ComputeTask)new FailedTask(), null);
                return null;
            }
        }, IgniteException.class, null);
        assert (latch.await(1000L, TimeUnit.MILLISECONDS));
        TaskEventSubjectIdSelfTest.assertEquals((int)2, (int)evts.size());
        Iterator<TaskEvent> it = evts.iterator();
        assert (it.hasNext());
        TaskEvent evt = it.next();
        assert (evt != null);
        TaskEventSubjectIdSelfTest.assertEquals((int)20, (int)evt.type());
        TaskEventSubjectIdSelfTest.assertEquals((Object)nodeId, (Object)evt.subjectId());
        assert (it.hasNext());
        evt = it.next();
        assert (evt != null);
        TaskEventSubjectIdSelfTest.assertEquals((int)22, (int)evt.type());
        TaskEventSubjectIdSelfTest.assertEquals((Object)nodeId, (Object)evt.subjectId());
        assert (!it.hasNext());
    }

    @Test
    public void testTimedOutTask() throws Exception {
        latch = new CountDownLatch(2);
        GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                TaskEventSubjectIdSelfTest.this.grid().compute().withTimeout(100L).execute((ComputeTask)new TimedOutTask(), null);
                return null;
            }
        }, ComputeTaskTimeoutException.class, null);
        assert (latch.await(1000L, TimeUnit.MILLISECONDS));
        TaskEventSubjectIdSelfTest.assertEquals((int)3, (int)evts.size());
        Iterator<TaskEvent> it = evts.iterator();
        assert (it.hasNext());
        TaskEvent evt = it.next();
        assert (evt != null);
        TaskEventSubjectIdSelfTest.assertEquals((int)20, (int)evt.type());
        TaskEventSubjectIdSelfTest.assertEquals((Object)nodeId, (Object)evt.subjectId());
        assert (it.hasNext());
        evt = it.next();
        assert (evt != null);
        TaskEventSubjectIdSelfTest.assertEquals((int)23, (int)evt.type());
        TaskEventSubjectIdSelfTest.assertEquals((Object)nodeId, (Object)evt.subjectId());
        assert (it.hasNext());
        evt = it.next();
        assert (evt != null);
        TaskEventSubjectIdSelfTest.assertEquals((int)22, (int)evt.type());
        TaskEventSubjectIdSelfTest.assertEquals((Object)nodeId, (Object)evt.subjectId());
        assert (!it.hasNext());
    }

    @Test
    public void testClosure() throws Exception {
        latch = new CountDownLatch(3);
        this.grid().compute().run(new IgniteRunnable(){

            public void run() {
            }
        });
        assert (latch.await(1000L, TimeUnit.MILLISECONDS));
        TaskEventSubjectIdSelfTest.assertEquals((int)3, (int)evts.size());
        Iterator<TaskEvent> it = evts.iterator();
        assert (it.hasNext());
        TaskEvent evt = it.next();
        assert (evt != null);
        TaskEventSubjectIdSelfTest.assertEquals((int)20, (int)evt.type());
        TaskEventSubjectIdSelfTest.assertEquals((Object)nodeId, (Object)evt.subjectId());
        assert (it.hasNext());
        evt = it.next();
        assert (evt != null);
        TaskEventSubjectIdSelfTest.assertEquals((int)25, (int)evt.type());
        TaskEventSubjectIdSelfTest.assertEquals((Object)nodeId, (Object)evt.subjectId());
        assert (it.hasNext());
        evt = it.next();
        assert (evt != null);
        TaskEventSubjectIdSelfTest.assertEquals((int)21, (int)evt.type());
        TaskEventSubjectIdSelfTest.assertEquals((Object)nodeId, (Object)evt.subjectId());
        assert (!it.hasNext());
    }

    @Test
    public void testClient() throws Exception {
        latch = new CountDownLatch(3);
        client.compute().execute(SimpleTask.class.getName(), null);
        assert (latch.await(1000L, TimeUnit.MILLISECONDS));
        TaskEventSubjectIdSelfTest.assertEquals((int)3, (int)evts.size());
        Iterator<TaskEvent> it = evts.iterator();
        assert (it.hasNext());
        TaskEvent evt = it.next();
        assert (evt != null);
        TaskEventSubjectIdSelfTest.assertEquals((int)20, (int)evt.type());
        TaskEventSubjectIdSelfTest.assertEquals((Object)client.id(), (Object)evt.subjectId());
        assert (it.hasNext());
        evt = it.next();
        assert (evt != null);
        TaskEventSubjectIdSelfTest.assertEquals((int)25, (int)evt.type());
        TaskEventSubjectIdSelfTest.assertEquals((Object)client.id(), (Object)evt.subjectId());
        assert (it.hasNext());
        evt = it.next();
        assert (evt != null);
        TaskEventSubjectIdSelfTest.assertEquals((int)21, (int)evt.type());
        TaskEventSubjectIdSelfTest.assertEquals((Object)client.id(), (Object)evt.subjectId());
        assert (!it.hasNext());
    }

    private static class TimedOutTask
    extends ComputeTaskSplitAdapter<Object, Object> {
        private TimedOutTask() {
        }

        protected Collection<? extends ComputeJob> split(int gridSize, Object arg) {
            return Collections.singleton(new ComputeJobAdapter(){

                @Nullable
                public Object execute() {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }

        @Nullable
        public Object reduce(List<ComputeJobResult> results) {
            return null;
        }
    }

    private static class FailedTask
    extends ComputeTaskSplitAdapter<Object, Object> {
        private FailedTask() {
        }

        protected Collection<? extends ComputeJob> split(int gridSize, Object arg) {
            return Collections.singleton(new ComputeJobAdapter(){

                @Nullable
                public Object execute() {
                    return null;
                }
            });
        }

        @Nullable
        public Object reduce(List<ComputeJobResult> results) {
            throw new IgniteException("Task failed.");
        }
    }

    private static class SimpleTask
    extends ComputeTaskSplitAdapter<Object, Object> {
        private SimpleTask() {
        }

        protected Collection<? extends ComputeJob> split(int gridSize, Object arg) {
            return Collections.singleton(new ComputeJobAdapter(){

                @Nullable
                public Object execute() {
                    return null;
                }
            });
        }

        @Nullable
        public Object reduce(List<ComputeJobResult> results) {
            return null;
        }
    }
}

