/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.qa.query;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.Ignite;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.query.UseOneTimeZoneForClusterTest;
import org.apache.ignite.jdbc.JdbcTestUtils;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.junit.Test;

public class JdbcThinUseOneTimeZoneForClusterTest
extends UseOneTimeZoneForClusterTest {
    private static final String URL = "jdbc:ignite:thin://127.0.0.1";
    private static String url = "jdbc:ignite:thin://127.0.0.1";

    protected List<List<?>> sql(String sql, List<Object> params) throws Exception {
        return JdbcTestUtils.sql(url, sql, params);
    }

    protected void beforeTest() throws Exception {
        super.beforeTest();
        url = URL;
    }

    @Test
    public void testClientsInDifferentTimeZones() throws Exception {
        super.testClientsInDifferentTimeZones();
        IgniteEx ign = this.grid("init-node");
        Collection thinPorts = ign.compute(ign.cluster().forClients()).broadcast((IgniteCallable)new IgniteCallable<Integer>(){
            @IgniteInstanceResource
            Ignite ign;

            public Integer call() {
                return ((IgniteEx)this.ign).context().sqlListener().port();
            }
        });
        Iterator iterator = thinPorts.iterator();
        while (iterator.hasNext()) {
            int port = (Integer)iterator.next();
            url = "jdbc:ignite:thin://127.0.0.1:" + port;
            this.checkDates();
        }
    }
}

