/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.loadtests.client;

import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.client.ClientTcpSslMultiThreadedSelfTest;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.junit.Test;

public class ClientTcpSslLoadTest
extends ClientTcpSslMultiThreadedSelfTest {
    private static final long TEST_RUN_TIME = 28800000L;
    private static final long STATISTICS_PRINT_INTERVAL = 300000L;
    private static final long RELAX_INTERVAL = 60000L;

    @Test
    public void testLongRun() throws Exception {
        long start;
        long lastPrint = start = System.currentTimeMillis();
        do {
            this.clearCaches();
            this.testMultithreadedTaskRun();
            long now = System.currentTimeMillis();
            if (now - lastPrint > 300000L) {
                this.info(">>>>>>> Running test for " + (now - start) / 1000L + " seconds.");
                lastPrint = now;
            }
            U.sleep((long)60000L);
        } while (System.currentTimeMillis() - start < 28800000L);
    }

    @Override
    protected int topologyRefreshFrequency() {
        return 5000;
    }

    @Override
    protected int maxConnectionIdleTime() {
        return this.topologyRefreshFrequency() / 5;
    }

    private void clearCaches() {
        for (int i = 0; i < 5; ++i) {
            try {
                this.grid(i).cache("partitioned").clear();
                continue;
            }
            catch (IgniteException e) {
                log.error("Cache clear failed.", (Throwable)e);
            }
        }
    }
}

