/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.jdbc.thin;

import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.util.concurrent.Callable;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.jdbc.thin.ConnectionProperties;
import org.apache.ignite.internal.jdbc.thin.ConnectionPropertiesImpl;
import org.apache.ignite.internal.jdbc.thin.JdbcThinTcpIo;
import org.apache.ignite.testframework.GridTestUtils;
import org.apache.ignite.testframework.junits.common.GridCommonAbstractTest;
import org.junit.Test;

public class JdbcThinTcpIoTest
extends GridCommonAbstractTest {
    @Test
    public void testHostWithValidAddress() throws Exception {
        this.startGrids(1);
        try (JdbcThinTcpIo jdbcThinTcpIo = null;){
            jdbcThinTcpIo = new JdbcThinTcpIo((ConnectionProperties)new ConnectionPropertiesImpl(), new InetSocketAddress("127.0.0.1", 10800), null, 500);
        }
        this.stopGrid(0);
    }

    @Test
    public void testExceptionMessage() {
        Throwable throwable = GridTestUtils.assertThrows((IgniteLogger)log, (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                new JdbcThinTcpIo((ConnectionProperties)new ConnectionPropertiesImpl(), new InetSocketAddress("10.0.0.0", 10800), null, 500);
                return null;
            }
        }, SQLException.class, (String)"Failed to connect to server [host=/10.0.0.0, port=10800]");
        JdbcThinTcpIoTest.assertEquals(SocketTimeoutException.class, throwable.getCause().getClass());
        JdbcThinTcpIoTest.assertTrue((boolean)throwable.getCause().getMessage().contains("connect timed out"));
    }
}

